<?php include 'include/header.php'; ?>
<?php

// admin-approve-vendor.php - COMPLETE FIXED VERSION
require '../config/conn.php';

// Fetch admin details
$admin_id = $_SESSION['admin_id'];
$stmt = $conn->prepare("SELECT `id`, `admin_id`, `full_name`, `email`, `phone`, `gender`, `role`, `last_login`, `created_at` FROM `admins` WHERE `admin_id` = ?");
$stmt->bind_param("s", $admin_id);
$stmt->execute();
$result = $stmt->get_result();
$admin = $result->fetch_assoc();

$admin_admin_id = $admin['admin_id'] ?? $admin_id;

// Handle approval action
$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['approve_transactions'])) {
    $vendor_id = intval($_POST['vendor_id']);
    $approve_amount = floatval($_POST['approve_amount']);
    $selected_date = $_POST['selected_date'];
    $commission_amount = floatval($_POST['commission_amount'] ?? 0);
    
    if ($approve_amount <= 0) {
        $error = "Approval amount must be greater than 0";
    } elseif ($commission_amount < 0) {
        $error = "Commission amount cannot be negative";
    } elseif ($commission_amount > $approve_amount) {
        $error = "Commission amount cannot exceed approval amount";
    } else {
        // Check actual daily pending
        $daily_pending_check_query = "SELECT COALESCE(SUM(amount), 0) as total_daily_pending 
                                     FROM vendor_wallet_transactions 
                                     WHERE vendor_id = '$vendor_id' 
                                     AND DATE(created_at) = '$selected_date'
                                     AND status = 'pending'
                                     AND transaction_type NOT IN ('admin_approval', 'commission', 'withdrawal')";
        $daily_pending_result = mysqli_query($conn, $daily_pending_check_query);
        $daily_pending_data = mysqli_fetch_assoc($daily_pending_result);
        $actual_daily_pending = floatval($daily_pending_data['total_daily_pending']);
        
        if ($approve_amount > $actual_daily_pending) {
            $error = "Approval amount (₦" . number_format($approve_amount, 2) . ") 
                      exceeds actual pending for selected date (₦" . number_format($actual_daily_pending, 2) . ")";
        } else {
            $net_amount_to_vendor = $approve_amount - $commission_amount;
            
            mysqli_begin_transaction($conn);
            
            try {
                // Get vendor's current balances
                $vendor_wallet_query = "SELECT * FROM vendor_wallets WHERE vendor_id = '$vendor_id'";
                $vendor_wallet_result = mysqli_query($conn, $vendor_wallet_query);
                $vendor_wallet = mysqli_fetch_assoc($vendor_wallet_result);
                
                if (!$vendor_wallet) {
                    throw new Exception("Vendor wallet not found");
                }
                
                $current_balance = floatval($vendor_wallet['balance']);
                $current_pending = floatval($vendor_wallet['pending_balance']);
                
                if ($approve_amount > $current_pending) {
                    throw new Exception("Approval amount cannot exceed total pending balance");
                }
                
                if ($commission_amount > $approve_amount) {
                    throw new Exception("Commission amount cannot exceed approval amount");
                }
                
                // Get admin wallet
                $admin_wallet_query = "SELECT `id`, `balance` FROM `admin_wallets` WHERE `admin_id` = '$admin_admin_id' LIMIT 1";
                $admin_wallet_result = mysqli_query($conn, $admin_wallet_query);
                $admin_wallet = mysqli_fetch_assoc($admin_wallet_result);
                
                if (!$admin_wallet) {
                    $create_admin_wallet = "INSERT INTO admin_wallets (admin_id, balance, created_at, updated_at) 
                                           VALUES ('$admin_admin_id', 0, NOW(), NOW())";
                    
                    if (!mysqli_query($conn, $create_admin_wallet)) {
                        throw new Exception("Failed to create admin wallet");
                    }
                    $admin_wallet_id = mysqli_insert_id($conn);
                    $admin_current_balance = 0;
                } else {
                    $admin_wallet_id = $admin_wallet['id'];
                    $admin_current_balance = floatval($admin_wallet['balance']);
                }
                
                // Calculate new balances
                $new_vendor_balance = $current_balance + $net_amount_to_vendor;
                $new_vendor_pending = $current_pending - $approve_amount;
                $new_admin_balance = $admin_current_balance + $commission_amount;
                
                // DEBUG: Check current transaction status before update
                $debug_query = "SELECT COUNT(*) as count, SUM(amount) as total 
                               FROM vendor_wallet_transactions 
                               WHERE vendor_id = '$vendor_id' 
                               AND DATE(created_at) = '$selected_date'
                               AND status = 'pending'
                               AND transaction_type NOT IN ('admin_approval', 'commission', 'withdrawal')";
                $debug_result = mysqli_query($conn, $debug_query);
                $debug_data = mysqli_fetch_assoc($debug_result);
                
                // UPDATE ONLY VENDOR-ENTERED PENDING TRANSACTIONS FOR TODAY to 'approved'
                $update_pending_transactions = "UPDATE vendor_wallet_transactions 
                                               SET status = 'approved',
                                                   balance_before = '$current_balance',
                                                   balance_after = '$new_vendor_balance',
                                                   pending_before = '$current_pending',
                                                   pending_after = '$new_vendor_pending',
                                                   commission_deducted = '$commission_amount',
                                                   description = CONCAT(description, ' | Approved on " . date('Y-m-d H:i:s') . " with commission: ₦" . number_format($commission_amount, 2) . "')
                                               WHERE vendor_id = '$vendor_id' 
                                               AND DATE(created_at) = '$selected_date'
                                               AND status = 'pending'
                                               AND transaction_type NOT IN ('admin_approval', 'commission', 'withdrawal')";
                
                if (!mysqli_query($conn, $update_pending_transactions)) {
                    $update_error = mysqli_error($conn);
                    throw new Exception("Failed to update pending transactions: " . $update_error);
                }
                
                $updated_rows = mysqli_affected_rows($conn);
                
                if ($updated_rows === 0) {
                    throw new Exception("No vendor-entered transactions found to approve for this date. Please check transaction types.");
                }
                
                // Update vendor wallet
                $update_vendor_wallet = "UPDATE vendor_wallets SET 
                                       balance = '$new_vendor_balance', 
                                       pending_balance = '$new_vendor_pending', 
                                       updated_at = NOW() 
                                       WHERE vendor_id = '$vendor_id'";
                
                if (!mysqli_query($conn, $update_vendor_wallet)) {
                    throw new Exception("Failed to update vendor wallet");
                }
                
                // Update admin wallet
                $update_admin_wallet = "UPDATE admin_wallets SET 
                                      balance = '$new_admin_balance', 
                                      updated_at = NOW() 
                                      WHERE id = '$admin_wallet_id'";
                
                if (!mysqli_query($conn, $update_admin_wallet)) {
                    throw new Exception("Failed to update admin wallet");
                }
                
                // Record admin wallet transaction
                $admin_transaction_ref = 'COMM-' . time() . '-' . $vendor_id;
                $admin_transaction_desc = "Commission from vendor $vendor_id approval (Gross: ₦" . number_format($approve_amount, 2) . ", Commission: ₦" . number_format($commission_amount, 2) . ")";
                
                // Check if admin_wallet_transactions table exists
                $check_admin_transactions = "SHOW TABLES LIKE 'admin_wallet_transactions'";
                $transactions_table_check = mysqli_query($conn, $check_admin_transactions);
                
                if (mysqli_num_rows($transactions_table_check) > 0) {
                    $record_admin_transaction = "INSERT INTO admin_wallet_transactions 
                                               (admin_wallet_id, admin_id, amount, transaction_type, reference, 
                                                description, balance_before, balance_after, created_at)
                                               VALUES ('$admin_wallet_id', '$admin_admin_id', '$commission_amount', 
                                                       'commission', '$admin_transaction_ref',
                                                       '$admin_transaction_desc', '$admin_current_balance', 
                                                       '$new_admin_balance', NOW())";
                    
                    mysqli_query($conn, $record_admin_transaction);
                }
                
                // Record vendor approval transaction
                $approval_reference = 'APPROVAL-' . time() . '-' . $vendor_id;
                $approval_description = "Admin approval for " . date('Y-m-d', strtotime($selected_date)) . 
                                       " (Gross: ₦" . number_format($approve_amount, 2) . 
                                       ", Commission: -₦" . number_format($commission_amount, 2) .
                                       ", Net: ₦" . number_format($net_amount_to_vendor, 2) . ")";
                
                $vendor_approval_transaction = "INSERT INTO vendor_wallet_transactions 
                                               (vendor_id, amount, transaction_type, reference, 
                                                status, description, balance_before, balance_after,
                                                pending_before, pending_after, commission_deducted, created_at)
                                               VALUES ('$vendor_id', '$net_amount_to_vendor', 'admin_approval',
                                                       '$approval_reference', 'approved',
                                                       '$approval_description', '$current_balance', '$new_vendor_balance',
                                                       '$current_pending', '$new_vendor_pending', '$commission_amount', NOW())";
                
                mysqli_query($conn, $vendor_approval_transaction);
                
                // Record the approval
                $record_approval = "INSERT INTO admin_approvals 
                                   (vendor_id, admin_id, approval_amount, commission_amount, net_amount,
                                    approval_date, previous_balance, new_balance, previous_pending, new_pending,
                                    reference, description, created_at)
                                   VALUES ('$vendor_id', '$admin_admin_id', '$approve_amount', '$commission_amount', 
                                           '$net_amount_to_vendor', '$selected_date', '$current_balance', '$new_vendor_balance',
                                           '$current_pending', '$new_vendor_pending',
                                           '$approval_reference', '$approval_description', NOW())";
                
                mysqli_query($conn, $record_approval);
                
                mysqli_commit($conn);
                
                $commission_percentage = ($approve_amount > 0) ? ($commission_amount / $approve_amount * 100) : 0;
                $message = "Successfully approved ₦" . number_format($approve_amount, 2) . 
                          " for vendor ID $vendor_id.<br>" . 
                          "Commission: ₦" . number_format($commission_amount, 2) . " (" . number_format($commission_percentage, 2) . "%) moved to admin wallet.<br>" .
                          "Net to vendor: ₦" . number_format($net_amount_to_vendor, 2) . 
                          "<br><small>Updated $updated_rows vendor transactions to 'approved' status.</small>";
                
            } catch (Exception $e) {
                mysqli_rollback($conn);
                $error = $e->getMessage();
                error_log("Transaction failed: " . $e->getMessage());
            }
        }
    }
}

// Get date filter (default to today)
$selected_date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');

// Get vendors with proper calculations - FIXED QUERY
$vendors_query = "SELECT 
    v.id, 
    v.business_name, 
    COALESCE(vw.balance, 0) as balance, 
    COALESCE(vw.pending_balance, 0) as pending_balance,
    COALESCE(daily_stats.daily_pending, 0) as daily_pending,
    COALESCE(daily_stats.pending_count, 0) as pending_count,
    COALESCE(total_stats.total_pending_count, 0) as total_pending_count
    FROM vendors v
    LEFT JOIN vendor_wallets vw ON v.id = vw.vendor_id
    LEFT JOIN (
        SELECT 
            vendor_id,
            SUM(CASE WHEN status = 'pending' THEN amount ELSE 0 END) as daily_pending,
            COUNT(CASE WHEN status = 'pending' THEN 1 END) as pending_count
        FROM vendor_wallet_transactions 
        WHERE DATE(created_at) = '$selected_date'
        AND transaction_type NOT IN ('admin_approval', 'commission', 'withdrawal')
        GROUP BY vendor_id
    ) daily_stats ON v.id = daily_stats.vendor_id
    LEFT JOIN (
        SELECT 
            vendor_id,
            COUNT(*) as total_pending_count
        FROM vendor_wallet_transactions 
        WHERE status = 'pending'
        AND transaction_type NOT IN ('admin_approval', 'commission', 'withdrawal')
        GROUP BY vendor_id
    ) total_stats ON v.id = total_stats.vendor_id
    ORDER BY COALESCE(daily_stats.daily_pending, 0) DESC, v.business_name";

$vendors_result = mysqli_query($conn, $vendors_query);

// Get admin wallet balance
$admin_wallet_query = "SELECT COALESCE(SUM(balance), 0) as admin_total_balance 
                      FROM `admin_wallets` 
                      WHERE `admin_id` = '$admin_admin_id'";
$admin_wallet_result = mysqli_query($conn, $admin_wallet_query);
$admin_wallet = mysqli_fetch_assoc($admin_wallet_result);
$admin_total_balance = $admin_wallet ? floatval($admin_wallet['admin_total_balance']) : 0;

// Get total statistics - FIXED QUERY
$stats_query = "SELECT 
    COALESCE(SUM(vw.balance), 0) as total_approved,
    COALESCE(SUM(vw.pending_balance), 0) as total_pending,
    COUNT(DISTINCT v.id) as total_vendors,
    COUNT(DISTINCT CASE WHEN vw.pending_balance > 0 THEN v.id END) as vendors_with_pending,
    (
        SELECT COUNT(DISTINCT vwt.id) 
        FROM vendor_wallet_transactions vwt
        WHERE DATE(vwt.created_at) = '$selected_date'
        AND vwt.status = 'pending'
        AND vwt.transaction_type NOT IN ('admin_approval', 'commission', 'withdrawal')
    ) as today_vendor_transactions,
    (
        SELECT COALESCE(SUM(vwt.amount), 0)
        FROM vendor_wallet_transactions vwt
        WHERE DATE(vwt.created_at) = '$selected_date'
        AND vwt.status = 'pending'
        AND vwt.transaction_type NOT IN ('admin_approval', 'commission', 'withdrawal')
    ) as today_vendor_amount
    FROM vendors v
    LEFT JOIN vendor_wallets vw ON v.id = vw.vendor_id";
$stats_result = mysqli_query($conn, $stats_query);
$stats = mysqli_fetch_assoc($stats_result);

// Get total transactions (including all types) for comparison
$total_transactions_query = "SELECT 
    COUNT(*) as total_all_transactions,
    COALESCE(SUM(amount), 0) as total_all_amount
    FROM vendor_wallet_transactions 
    WHERE DATE(created_at) = '$selected_date'
    AND status = 'pending'";
$total_transactions_result = mysqli_query($conn, $total_transactions_query);
$total_transactions = mysqli_fetch_assoc($total_transactions_result);
?>

<!-- Content Area -->
<main class="main-content flex-1 p-6 bg-gray-50 dark:bg-gray-900 overflow-y-auto">
    <div class="max-w-7xl mx-auto">
        <!-- Header -->
        <div class="mb-6">
            <h1 class="text-2xl font-bold text-gray-900 dark:text-white">Vendor Transaction Approval</h1>
            <p class="text-gray-600 dark:text-gray-400">Approve vendor transactions - Admin can set specific commission amount</p>
        </div>

        <!-- Messages -->
        <?php if ($message): ?>
        <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
            <?php echo $message; ?>
        </div>
        <?php endif; ?>
        
        <?php if ($error): ?>
        <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
            <?php echo htmlspecialchars($error); ?>
        </div>
        <?php endif; ?>

        <!-- Statistics Cards -->
        <div class="grid grid-cols-1 md:grid-cols-5 gap-6 mb-6">
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
                <div class="flex items-center">
                    <div class="w-12 h-12 rounded-full bg-green-50 dark:bg-green-900/30 flex items-center justify-center mr-4">
                        <i class="fas fa-check-circle text-green-500 dark:text-green-400 text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Total Approved (Vendors)</p>
                        <p class="text-2xl font-bold text-gray-900 dark:text-white">₦<?php echo number_format($stats['total_approved'], 2); ?></p>
                    </div>
                </div>
            </div>
            
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
                <div class="flex items-center">
                    <div class="w-12 h-12 rounded-full bg-yellow-50 dark:bg-yellow-900/30 flex items-center justify-center mr-4">
                        <i class="fas fa-clock text-yellow-500 dark:text-yellow-400 text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Total Pending for Approval</p>
                        <p class="text-2xl font-bold text-gray-900 dark:text-white">₦<?php echo number_format($stats['total_pending'], 2); ?></p>
                        <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                            <?php echo $stats['vendors_with_pending']; ?> vendor(s) with pending
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
                <div class="flex items-center">
                    <div class="w-12 h-12 rounded-full bg-blue-50 dark:bg-blue-900/30 flex items-center justify-center mr-4">
                        <i class="fas fa-store text-blue-500 dark:text-blue-400 text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Total Vendors</p>
                        <p class="text-2xl font-bold text-gray-900 dark:text-white"><?php echo $stats['total_vendors']; ?></p>
                    </div>
                </div>
            </div>
            
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
                <div class="flex items-center">
                    <div class="w-12 h-12 rounded-full bg-purple-50 dark:bg-purple-900/30 flex items-center justify-center mr-4">
                        <i class="fas fa-wallet text-purple-500 dark:text-purple-400 text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Admin Wallet Balance</p>
                        <p class="text-2xl font-bold text-gray-900 dark:text-white">₦<?php echo number_format($admin_total_balance, 2); ?></p>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Commission from approvals</p>
                    </div>
                </div>
            </div>
            
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
                <div class="flex items-center">
                    <div class="w-12 h-12 rounded-full bg-cyan-50 dark:bg-cyan-900/30 flex items-center justify-center mr-4">
                        <i class="fas fa-calendar-day text-cyan-500 dark:text-cyan-400 text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Total Today (<?php echo date('M d', strtotime($selected_date)); ?>)</p>
                        <p class="text-2xl font-bold text-gray-900 dark:text-white"><?php echo $stats['today_vendor_transactions']; ?> transactions</p>
                        <p class="text-lg font-medium text-gray-900 dark:text-white">
                            ₦<?php echo number_format($stats['today_vendor_amount'], 2); ?> total value
                        </p>
                        <?php if ($stats['today_vendor_transactions'] < $total_transactions['total_all_transactions']): ?>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                            Excluding <?php echo ($total_transactions['total_all_transactions'] - $stats['today_vendor_transactions']); ?> admin transactions
                        </p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Date Filter -->
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700 mb-6">
            <h3 class="text-lg font-semibold dark:text-white mb-4">Select Date for Approval</h3>
            <form method="GET" action="" class="flex items-center space-x-4">
                <div>
                    <label for="date" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Date</label>
                    <input type="date" id="date" name="date" value="<?php echo htmlspecialchars($selected_date); ?>" 
                           class="px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md focus:outline-none focus:ring-2 focus:ring-yellow-500 dark:bg-gray-700 dark:text-white">
                </div>
                <div class="mt-6">
                    <button type="submit" class="bg-yellow-500 hover:bg-yellow-600 text-white px-4 py-2 rounded-md font-medium">
                        <i class="fas fa-filter mr-2"></i> Filter
                    </button>
                </div>
                <div class="mt-6">
                    <a href="?date=<?php echo date('Y-m-d'); ?>" class="bg-gray-200 dark:bg-gray-700 hover:bg-gray-300 dark:hover:bg-gray-600 text-gray-800 dark:text-white px-4 py-2 rounded-md font-medium">
                        <i class="fas fa-calendar-day mr-2"></i> Today
                    </a>
                </div>
            </form>
        </div>

        <!-- Vendors List -->
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm border border-gray-100 dark:border-gray-700 overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-100 dark:border-gray-700">
                <div class="flex justify-between items-center">
                    <div>
                        <h3 class="text-lg font-semibold dark:text-white">All Vendors - <?php echo date('F j, Y', strtotime($selected_date)); ?></h3>
                        <p class="text-sm text-gray-500 dark:text-gray-400">
                            Showing all vendors. Green = Has pending transactions, Gray = No pending transactions
                        </p>
                    </div>
                    <div class="text-sm">
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300 mr-2">
                            <span class="w-2 h-2 bg-green-500 rounded-full mr-1"></span>
                            Has Transactions
                        </span>
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300">
                            <span class="w-2 h-2 bg-gray-400 rounded-full mr-1"></span>
                            No Transactions
                        </span>
                    </div>
                </div>
            </div>
            
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                    <thead class="bg-gray-50 dark:bg-gray-800">
                        <tr>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Vendor</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Status</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Approved Balance</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Pending Balance</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Today's Pending</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Transactions</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                        <?php if (mysqli_num_rows($vendors_result) > 0): ?>
                            <?php while ($vendor = mysqli_fetch_assoc($vendors_result)): 
                                $daily_pending = floatval($vendor['daily_pending']);
                                $pending_count = intval($vendor['pending_count']);
                                $pending_balance = floatval($vendor['pending_balance']);
                                $has_pending = $pending_balance > 0 || $daily_pending > 0;
                                $status_class = $has_pending ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300' : 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300';
                                $status_text = $has_pending ? 'Has Transactions' : 'No Transactions';
                            ?>
                            <tr class="<?php echo $has_pending ? 'bg-green-50 dark:bg-green-900/20' : ''; ?>">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div class="w-10 h-10 rounded-full <?php echo $has_pending ? 'bg-green-100 dark:bg-green-900' : 'bg-gray-200 dark:bg-gray-700'; ?> flex items-center justify-center mr-3">
                                            <i class="fas fa-store <?php echo $has_pending ? 'text-green-500 dark:text-green-400' : 'text-gray-400 dark:text-gray-500'; ?>"></i>
                                        </div>
                                        <div>
                                            <div class="text-sm font-medium text-gray-900 dark:text-white"><?php echo htmlspecialchars($vendor['business_name']); ?></div>
                                            <div class="text-sm text-gray-500 dark:text-gray-400">ID: <?php echo $vendor['id']; ?></div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo $status_class; ?>">
                                        <?php if ($has_pending): ?>
                                            <span class="w-2 h-2 bg-green-500 rounded-full mr-1"></span>
                                        <?php else: ?>
                                            <span class="w-2 h-2 bg-gray-400 rounded-full mr-1"></span>
                                        <?php endif; ?>
                                        <?php echo $status_text; ?>
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-green-600 dark:text-green-400">
                                        ₦<?php echo number_format($vendor['balance'], 2); ?>
                                    </div>
                                    <div class="text-xs text-gray-500 dark:text-gray-400">Available for withdrawal</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium <?php echo $pending_balance > 0 ? 'text-yellow-600 dark:text-yellow-400' : 'text-gray-500 dark:text-gray-400'; ?>">
                                        ₦<?php echo number_format($pending_balance, 2); ?>
                                    </div>
                                    <div class="text-xs text-gray-500 dark:text-gray-400">Pending clearance</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium <?php echo $daily_pending > 0 ? 'text-gray-900 dark:text-white' : 'text-gray-500 dark:text-gray-400'; ?>">
                                        ₦<?php echo number_format($daily_pending, 2); ?>
                                    </div>
                                    <div class="text-xs text-gray-500 dark:text-gray-400">
                                        <?php echo $pending_count; ?> transaction(s) today
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <a href="transaction-details.php?vendor_id=<?php echo $vendor['id']; ?>&date=<?php echo urlencode($selected_date); ?>" 
                                       class="text-yellow-600 hover:text-yellow-800 dark:text-yellow-400 dark:hover:text-yellow-300 text-sm font-medium">
                                        <i class="fas fa-eye mr-1"></i> View Details
                                    </a>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php if ($daily_pending > 0): ?>
                                    <button onclick="openApprovalModal(<?php echo $vendor['id']; ?>, '<?php echo htmlspecialchars(addslashes($vendor['business_name'])); ?>', <?php echo $pending_balance; ?>, <?php echo $daily_pending; ?>, '<?php echo $selected_date; ?>')" 
                                            class="bg-green-500 hover:bg-green-600 text-white px-3 py-1 rounded text-sm font-medium">
                                        <i class="fas fa-check mr-1"></i> Approve
                                    </button>
                                    <?php else: ?>
                                    <button disabled class="bg-gray-300 dark:bg-gray-700 text-gray-500 dark:text-gray-400 px-3 py-1 rounded text-sm font-medium cursor-not-allowed">
                                        <i class="fas fa-check mr-1"></i> Approve
                                    </button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="px-6 py-4 text-center text-gray-500 dark:text-gray-400">
                                    No vendors found in the system.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Approval Modal -->
<div id="approvalModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
    <div class="relative top-20 mx-auto p-5 border w-full max-w-md shadow-lg rounded-md bg-white dark:bg-gray-800">
        <div class="mt-3">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4" id="modalTitle">Approve Vendor Transactions</h3>
            
            <form method="POST" action="" id="approvalForm">
                <input type="hidden" name="vendor_id" id="modalVendorId">
                <input type="hidden" name="selected_date" id="modalSelectedDate">
                
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Vendor</label>
                    <p class="text-gray-900 dark:text-white font-medium" id="modalVendorName"></p>
                </div>
                
                <div class="grid grid-cols-2 gap-4 mb-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Total Pending</label>
                        <p class="text-yellow-600 dark:text-yellow-400 font-medium" id="modalTotalPending"></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Today's Pending</label>
                        <p class="text-gray-900 dark:text-white font-medium" id="modalDailyPending"></p>
                    </div>
                </div>
                
                <div class="mb-4">
                    <label for="approve_amount" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Gross Amount to Approve *</label>
                    <input type="number" id="approve_amount" name="approve_amount" step="0.01" min="0.01" 
                           class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md focus:outline-none focus:ring-2 focus:ring-yellow-500 dark:bg-gray-700 dark:text-white"
                           placeholder="Enter gross amount to approve" oninput="calculateCommissionAmount()">
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                        Enter gross amount to approve from pending balance
                    </p>
                </div>
                
                <div class="mb-4">
                    <label for="commission_amount" class="block text-sm font-medium text-gray-500 dark:text-gray-300 mb-2">Commission Amount to Remove *</label>
                    <div class="flex items-center space-x-2">
                        <input type="number" id="commission_amount" name="commission_amount" step="0.01" min="0" 
                               class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md focus:outline-none focus:ring-2 focus:ring-yellow-500 dark:bg-gray-700 dark:text-white"
                               placeholder="Enter commission amount" oninput="calculateNetAmount()">
                        <span class="text-gray-500 dark:text-gray-400">₦</span>
                    </div>
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Enter specific amount to remove as commission</p>
                </div>
                
                <div class="bg-yellow-50 dark:bg-yellow-900/20 p-3 rounded-lg mb-4">
                    <div class="grid grid-cols-2 gap-3 text-sm">
                        <div>
                            <p class="text-gray-600 dark:text-gray-300">Commission Percentage</p>
                            <p class="text-red-600 dark:text-red-400 font-medium" id="modalCommissionPercentage"></p>
                        </div>
                        <div>
                            <p class="text-gray-600 dark:text-gray-300">Net to Vendor</p>
                            <p class="text-green-600 dark:text-green-400 font-medium" id="modalNetAmount"></p>
                        </div>
                    </div>
                </div>
                
                <div class="flex justify-end space-x-3 mt-6">
                    <button type="button" onclick="closeModal()" 
                            class="bg-gray-200 dark:bg-gray-700 hover:bg-gray-300 dark:hover:bg-gray-600 text-gray-800 dark:text-white px-4 py-2 rounded-md text-sm font-medium">
                        Cancel
                    </button>
                    <button type="submit" name="approve_transactions"
                            class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded-md text-sm font-medium">
                        <i class="fas fa-check mr-1"></i> Confirm Approval
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Modal functions
function openApprovalModal(vendorId, vendorName, totalPending, dailyPending, selectedDate) {
    document.getElementById('modalVendorId').value = vendorId;
    document.getElementById('modalVendorName').textContent = vendorName;
    document.getElementById('modalTotalPending').textContent = '₦' + parseFloat(totalPending).toFixed(2);
    document.getElementById('modalDailyPending').textContent = '₦' + parseFloat(dailyPending).toFixed(2);
    document.getElementById('modalSelectedDate').value = selectedDate;
    document.getElementById('approve_amount').value = parseFloat(dailyPending).toFixed(2);
    document.getElementById('approve_amount').max = parseFloat(totalPending).toFixed(2);
    document.getElementById('commission_amount').value = '0';
    
    // Calculate initial values
    calculateCommissionAmount();
    
    document.getElementById('approvalModal').classList.remove('hidden');
}

function closeModal() {
    document.getElementById('approvalModal').classList.add('hidden');
}

function calculateCommissionAmount() {
    const amount = parseFloat(document.getElementById('approve_amount').value) || 0;
    const commission = parseFloat(document.getElementById('commission_amount').value) || 0;
    const netAmount = amount - commission;
    const commissionPercentage = (amount > 0) ? (commission / amount * 100) : 0;
    
    document.getElementById('modalCommissionPercentage').textContent = commissionPercentage.toFixed(2) + '%';
    document.getElementById('modalNetAmount').textContent = '₦' + netAmount.toFixed(2);
}

function calculateNetAmount() {
    const amount = parseFloat(document.getElementById('approve_amount').value) || 0;
    const commission = parseFloat(document.getElementById('commission_amount').value) || 0;
    const netAmount = amount - commission;
    const commissionPercentage = (amount > 0) ? (commission / amount * 100) : 0;
    
    document.getElementById('modalCommissionPercentage').textContent = commissionPercentage.toFixed(2) + '%';
    document.getElementById('modalNetAmount').textContent = '₦' + netAmount.toFixed(2);
}

// Close modal when clicking outside
window.onclick = function(event) {
    const approvalModal = document.getElementById('approvalModal');
    
    if (event.target == approvalModal) {
        approvalModal.classList.add('hidden');
    }
}

// Form validation
document.getElementById('approvalForm').addEventListener('submit', function(e) {
    const amount = parseFloat(document.getElementById('approve_amount').value);
    const commission = parseFloat(document.getElementById('commission_amount').value);
    const totalPending = parseFloat(document.getElementById('modalTotalPending').textContent.replace('₦', ''));
    const dailyPending = parseFloat(document.getElementById('modalDailyPending').textContent.replace('₦', ''));
    
    if (isNaN(amount) || amount <= 0) {
        e.preventDefault();
        alert('Please enter a valid approval amount');
        return false;
    }
    
    if (amount > totalPending) {
        e.preventDefault();
        alert('Approval amount cannot exceed total pending balance');
        return false;
    }
    
    if (amount > dailyPending) {
        if (!confirm('Approval amount exceeds today\'s pending amount. Are you sure you want to approve more than today\'s transactions?')) {
            e.preventDefault();
            return false;
        }
    }
    
    if (isNaN(commission) || commission < 0) {
        e.preventDefault();
        alert('Please enter a valid commission amount (cannot be negative)');
        return false;
    }
    
    if (commission > amount) {
        e.preventDefault();
        alert('Commission amount cannot exceed approval amount');
        return false;
    }
    
    // Confirm if commission is more than 50% of amount
    if ((commission / amount * 100) > 50) {
        if (!confirm('Commission amount is more than 50% of the approval amount. Are you sure you want to proceed?')) {
            e.preventDefault();
            return false;
        }
    }
    
    return true;
});

// Auto-calculate on input
document.getElementById('approve_amount').addEventListener('input', calculateCommissionAmount);
document.getElementById('commission_amount').addEventListener('input', calculateNetAmount);
</script>

<?php include 'include/footer.php'; ?>