<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
require '../config/conn.php';
require '../config/session.php';
require '../vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Initialize error messages
$errors = [
    'email' => '',
    'password' => ''
];

// Redirect if already logged in
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header("Location: admin/dashboard.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Portal - Login</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        @layer components {
            .btn-primary {
                background-color: #fbbb01;
            }
            .btn-primary:hover {
                background-color: #e0a800;
            }
            .input-focus:focus {
                border-color: #fbbb01;
                ring-color: #fbbb01;
            }
        }
    </style>
</head>
<body class="bg-gray-100 min-h-screen flex items-center justify-center p-5 font-['Poppins']">
    <div class="w-full max-w-[1200px] flex flex-col items-center">
        <!-- Admin Portal Logo - Replace with your actual logo -->
        <div class="mb-8">
            <img src="path/to/your/admin-logo.png" alt="Admin Portal Logo" class="h-20 mx-auto">
        </div>

        <div class="text-center mb-8">
            <h1 class="text-4xl font-bold mb-2 bg-gradient-to-r from-[#fbbb01] to-[#ffcc33] bg-clip-text text-transparent">Admin Portal</h1>
            <p class="text-gray-600 text-lg">Sign in to access the admin dashboard</p>
        </div>

        <!-- Messages Container -->
        <div id="messageContainer" class="w-full max-w-md mb-5"></div>

        <!-- Display verification messages -->
        <?php if (isset($_SESSION['admin_verification_success'])): ?>
            <div class="bg-green-50 border-l-4 border-green-500 p-5 rounded-lg mb-8 w-full max-w-md">
                <h3 class="text-green-700 font-bold mb-2"><i class="fas fa-check-circle mr-2"></i> Verification Successful</h3>
                <p class="text-green-700 mb-3"><?php echo htmlspecialchars($_SESSION['admin_verification_success']); ?></p>
                <a href="admin-login.php" class="inline-block bg-green-600 text-white px-4 py-2 rounded font-medium hover:bg-green-700">Proceed to Login</a>
            </div>
            <?php unset($_SESSION['admin_verification_success']); ?>
        <?php endif; ?>
        
        <?php if (isset($_SESSION['admin_verification_error'])): ?>
            <div class="bg-red-50 border-l-4 border-red-500 p-4 rounded-lg mb-6 w-full max-w-md text-red-700">
                <?php echo htmlspecialchars($_SESSION['admin_verification_error']); ?>
                <?php if (isset($_SESSION['pending_admin_verification_email'])): ?>
                    <div class="mt-3">
                        <button type="button" id="showResendModal" class="text-[#fbbb01] underline hover:text-[#e0a800] text-sm">Resend verification code</button>
                    </div>
                <?php endif; ?>
            </div>
            <?php 
            unset($_SESSION['admin_verification_error']);
            unset($_SESSION['pending_admin_verification_email']);
            ?>
        <?php endif; ?>
        
        <div class="flex border-b-2 border-gray-300 mb-8 w-full max-w-md">
            <div class="flex-1 text-center py-4 font-medium text-[#fbbb01] border-b-2 border-[#fbbb01]">Login</div>
            <a href="admin-register.php" class="flex-1 text-center py-4 font-medium text-gray-500 hover:text-gray-700">Register</a>
        </div>

        <div class="w-full max-w-md">
            <form id="loginForm" class="bg-white rounded-lg shadow-md p-8" method="POST">
                <div class="mb-6">
                    <label for="loginEmail" class="block text-gray-700 font-medium mb-2">Email Address</label>
                    <div class="relative">
                        <i class="fas fa-envelope absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
                        <input type="email" id="loginEmail" name="email" class="w-full pl-10 pr-3 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[#fbbb01] focus:border-[#fbbb01] input-focus"
                               value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>" required>
                    </div>
                    <small class="text-red-500 text-sm mt-1 block" id="email_error"></small>
                </div>
                
                <div class="mb-6">
                    <label for="loginPassword" class="block text-gray-700 font-medium mb-2">Password</label>
                    <div class="relative">
                        <i class="fas fa-lock absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
                        <input type="password" id="loginPassword" name="password" class="w-full pl-10 pr-10 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[#fbbb01] focus:border-[#fbbb01] input-focus" required>
                        <i class="fas fa-eye absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400 cursor-pointer" id="togglePassword"></i>
                    </div>
                    <small class="text-red-500 text-sm mt-1 block" id="password_error"></small>
                </div>
                
                <div class="flex justify-between items-center mb-6 text-sm">
                    <div class="flex items-center">
                        <input type="checkbox" id="rememberMe" name="remember_me" value="1" class="mr-2">
                        <label for="rememberMe" class="text-gray-600">Remember me</label>
                    </div>
                    <a href="admin-forgot-password.php" class="text-[#fbbb01] hover:text-[#e0a800] hover:underline">Forgot password?</a>
                </div>
                
                <button type="submit" id="submitBtn" class="w-full py-3 px-4 bg-[#fbbb01] text-white font-medium rounded-lg hover:bg-[#e0a800] transition duration-200 relative disabled:opacity-70 disabled:cursor-not-allowed" name="login">
                    <span class="btn-text">Sign In</span>
                    <span class="loading-spinner hidden absolute inset-0 flex items-center justify-center">
                        <div class="w-5 h-5 border-2 border-white border-t-transparent rounded-full animate-spin"></div>
                    </span>
                </button>
            </form>
        </div>
    </div>

    <!-- Resend Verification Modal -->
    <div class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden" id="resendModal">
        <div class="bg-white rounded-lg p-6 w-full max-w-md relative">
            <span class="absolute top-4 right-4 text-gray-500 cursor-pointer text-2xl" id="closeModal">&times;</span>
            <h3 class="text-xl font-bold text-gray-800 mb-4">Resend Verification Code</h3>
            <p class="text-gray-600 mb-6">A new verification code will be sent to your email address. Do you want to proceed?</p>
            <div class="flex justify-end space-x-3">
                <button type="button" class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50" id="cancelResend">Cancel</button>
                <button type="button" class="px-4 py-2 bg-[#fbbb01] text-white rounded-lg hover:bg-[#e0a800] relative disabled:opacity-70 disabled:cursor-not-allowed" id="confirmResend">
                    <span class="btn-text">Resend</span>
                    <span class="loading-spinner hidden absolute inset-0 flex items-center justify-center">
                        <div class="w-5 h-5 border-2 border-white border-t-transparent rounded-full animate-spin"></div>
                    </span>
                </button>
            </div>
        </div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Password visibility toggle
        const togglePassword = document.getElementById('togglePassword');
        const passwordInput = document.getElementById('loginPassword');
        
        togglePassword.addEventListener('click', function() {
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                togglePassword.classList.remove('fa-eye');
                togglePassword.classList.add('fa-eye-slash');
            } else {
                passwordInput.type = 'password';
                togglePassword.classList.remove('fa-eye-slash');
                togglePassword.classList.add('fa-eye');
            }
        });
        
        // AJAX Form Submission
        const loginForm = document.getElementById('loginForm');
        const submitBtn = document.getElementById('submitBtn');
        const btnText = submitBtn.querySelector('.btn-text');
        const loadingSpinner = submitBtn.querySelector('.loading-spinner');
        const messageContainer = document.getElementById('messageContainer');
        
        loginForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Show loading state
            submitBtn.disabled = true;
            btnText.classList.add('opacity-0');
            loadingSpinner.classList.remove('hidden');
            
            // Clear previous messages
            messageContainer.innerHTML = '';
            clearErrorMessages();
            
            // Get form data
            const formData = new FormData(loginForm);
            
            // Send AJAX request
            fetch('process_admin_login.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                // Reset button state
                submitBtn.disabled = false;
                btnText.classList.remove('opacity-0');
                loadingSpinner.classList.add('hidden');
                
                if (data.success) {
                    // Show success message
                    showMessage(data.message, 'success');
                    
                    // Redirect based on response
                    if (data.redirect) {
                        setTimeout(() => {
                            window.location.href = data.redirect;
                        }, 1000);
                    } else if (data.verification_required) {
                        // Redirect to verification page
                        setTimeout(() => {
                            window.location.href = 'admin-verify-code.php';
                        }, 1000);
                    }
                } else {
                    // Show error messages
                    if (data.message) {
                        showMessage(data.message, 'error');
                    }
                    
                    // Show field-specific errors
                    if (data.errors) {
                        displayFieldErrors(data.errors);
                    }
                    
                    // Show resend verification option if account not verified
                    if (data.resend_verification) {
                        showResendVerificationOption(data.email);
                    }
                    
                    // Show account inactive message
                    if (data.account_inactive) {
                        showAccountInactiveMessage(data.message);
                    }
                }
            })
            .catch(error => {
                console.error('Error:', error);
                
                // Reset button state
                submitBtn.disabled = false;
                btnText.classList.remove('opacity-0');
                loadingSpinner.classList.add('hidden');
                
                showMessage('An error occurred. Please try again.', 'error');
            });
        });
        
        function showMessage(message, type) {
            const messageDiv = document.createElement('div');
            messageDiv.className = `w-full max-w-md mb-5 p-4 rounded border-l-4 ${
                type === 'success' 
                ? 'bg-green-50 text-green-700 border-green-500' 
                : 'bg-red-50 text-red-700 border-red-500'
            }`;
            messageDiv.innerHTML = `
                <div class="flex items-center">
                    <i class="fas ${type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle'} mr-2"></i>
                    <span>${message}</span>
                </div>
            `;
            messageContainer.appendChild(messageDiv);
            
            // Auto-hide success messages after 5 seconds
            if (type === 'success') {
                setTimeout(() => {
                    messageDiv.remove();
                }, 5000);
            }
        }
        
        function showAccountInactiveMessage(message) {
            const messageDiv = document.createElement('div');
            messageDiv.className = 'w-full max-w-md mb-5 p-4 bg-yellow-50 border-l-4 border-yellow-500 text-yellow-700 rounded';
            messageDiv.innerHTML = `
                <div class="flex items-center">
                    <i class="fas fa-exclamation-triangle mr-2"></i>
                    <span>${message}</span>
                </div>
                <div class="mt-2 text-sm">
                    <p>Please contact the super administrator to activate your account.</p>
                </div>
            `;
            messageContainer.appendChild(messageDiv);
        }
        
        function clearErrorMessages() {
            document.getElementById('email_error').textContent = '';
            document.getElementById('password_error').textContent = '';
        }
        
        function displayFieldErrors(errors) {
            for (const field in errors) {
                const errorElement = document.getElementById(field + '_error');
                if (errorElement && errors[field]) {
                    errorElement.textContent = errors[field];
                }
            }
        }
        
        function showResendVerificationOption(email) {
            const resendDiv = document.createElement('div');
            resendDiv.className = 'w-full max-w-md mb-5 p-4 bg-yellow-50 border-l-4 border-yellow-500 text-yellow-700';
            resendDiv.innerHTML = `
                <p class="mb-2">Your admin account is not verified. Would you like to resend the verification code?</p>
                <button type="button" class="resend-verification-btn text-[#fbbb01] underline hover:text-[#e0a800] text-sm font-medium" data-email="${email}">
                    Resend verification code
                </button>
            `;
            messageContainer.appendChild(resendDiv);
            
            // Add event listener to resend button
            resendDiv.querySelector('.resend-verification-btn').addEventListener('click', function() {
                const email = this.getAttribute('data-email');
                showResendModal(email);
            });
        }
        
        // Modal handling
        const modal = document.getElementById('resendModal');
        const showModalBtn = document.getElementById('showResendModal');
        const closeModalBtn = document.getElementById('closeModal');
        const cancelBtn = document.getElementById('cancelResend');
        const confirmResendBtn = document.getElementById('confirmResend');
        
        let pendingEmail = '';
        
        function showResendModal(email) {
            pendingEmail = email;
            modal.classList.remove('hidden');
        }
        
        if (showModalBtn) {
            showModalBtn.addEventListener('click', function() {
                // Get email from session data
                const email = '<?php echo isset($_SESSION["pending_admin_verification_email"]) ? $_SESSION["pending_admin_verification_email"] : ""; ?>';
                if (email) {
                    showResendModal(email);
                }
            });
        }
        
        if (closeModalBtn) {
            closeModalBtn.addEventListener('click', function() {
                modal.classList.add('hidden');
            });
        }
        
        if (cancelBtn) {
            cancelBtn.addEventListener('click', function() {
                modal.classList.add('hidden');
            });
        }
        
        // Confirm resend button
        if (confirmResendBtn) {
            confirmResendBtn.addEventListener('click', function() {
                if (!pendingEmail) {
                    showMessage('No email address found. Please try logging in again.', 'error');
                    modal.classList.add('hidden');
                    return;
                }
                
                // Show loading state
                const confirmBtnText = confirmResendBtn.querySelector('.btn-text');
                const confirmLoadingSpinner = confirmResendBtn.querySelector('.loading-spinner');
                
                confirmResendBtn.disabled = true;
                confirmBtnText.classList.add('opacity-0');
                confirmLoadingSpinner.classList.remove('hidden');
                
                resendVerificationCode(pendingEmail);
            });
        }
        
        // Close modal when clicking outside
        window.addEventListener('click', function(event) {
            if (event.target === modal) {
                modal.classList.add('hidden');
            }
        });
        
        function resendVerificationCode(email) {
            const formData = new FormData();
            formData.append('email', email);
            formData.append('resend_verification', '1');
            
            fetch('admin_resend_verification.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                // Reset modal button state
                const confirmResendBtn = document.getElementById('confirmResend');
                const confirmBtnText = confirmResendBtn.querySelector('.btn-text');
                const confirmLoadingSpinner = confirmResendBtn.querySelector('.loading-spinner');
                
                confirmResendBtn.disabled = false;
                confirmBtnText.classList.remove('opacity-0');
                confirmLoadingSpinner.classList.add('hidden');
                
                if (data.success) {
                    showMessage(data.message, 'success');
                    modal.classList.add('hidden');
                } else {
                    showMessage(data.message || 'Failed to send verification code.', 'error');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                
                // Reset modal button state
                const confirmResendBtn = document.getElementById('confirmResend');
                const confirmBtnText = confirmResendBtn.querySelector('.btn-text');
                const confirmLoadingSpinner = confirmResendBtn.querySelector('.loading-spinner');
                
                confirmResendBtn.disabled = false;
                confirmBtnText.classList.remove('opacity-0');
                confirmLoadingSpinner.classList.add('hidden');
                
                showMessage('An error occurred. Please try again.', 'error');
            });
        }
    });
    </script>
</body>
</html>