<?php
// admin_resend_verification.php
session_start();
require '../config/conn.php';
require '../vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Set content type to JSON
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['resend_verification'])) {
    $email = trim($_POST['email'] ?? '');
    
    if (empty($email)) {
        echo json_encode([
            'success' => false,
            'message' => 'Email address is required.'
        ]);
        exit();
    }
    
    // Check if admin exists and get their details
    $stmt = $conn->prepare("SELECT id, admin_id, full_name, email, is_verified, is_active FROM admins WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
        echo json_encode([
            'success' => false,
            'message' => 'Email address not found in admin system.'
        ]);
        exit();
    }
    
    $admin = $result->fetch_assoc();
    
    // Check if already verified
    if ($admin['is_verified']) {
        echo json_encode([
            'success' => false,
            'message' => 'Admin account is already verified. Please login.'
        ]);
        exit();
    }
    
    // Generate new verification token
    $verification_code = bin2hex(random_bytes(32));
    $verification_code_expiry = date('Y-m-d H:i:s', strtotime('+30 minutes'));
    
    // Update admin record with new verification code
    $stmt = $conn->prepare("UPDATE admins SET verification_code = ?, verification_code_expiry = ? WHERE email = ?");
    
    if ($stmt->bind_param("sss", $verification_code, $verification_code_expiry, $email) && $stmt->execute()) {
        // Send verification email
        $mail = new PHPMailer(true);
        
        try {
            // Server settings
            $mail->isSMTP();
            $mail->Host       = 'smtp.gmail.com';
            $mail->SMTPAuth   = true;
                    $mail->Username   = 'olorodemicheal2274@gmail.com';
                $mail->Password   = 'farq ptyc vjtl eses';
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
            $mail->Port       = 465;
            
            // Recipients
            $mail->setFrom('noreply@athenian.com', 'Anthes Epay Admin Portal');
            $mail->addAddress($email, $admin['full_name']);
            
            // Verification link
            $verification_link = "https://localhost/Epay-management/admin/verify.php?code=$verification_code&email=" . urlencode($email);
            
            // Content
            $mail->isHTML(true);
            $mail->Subject = 'New Verification Code - Anthes Epay Admin Portal';
            
            $mail->Body = "
            <div style='max-width: 600px; margin: 0 auto; border: 1px solid #e0e0e0; border-radius: 8px; overflow: hidden; font-family: Arial, sans-serif;'>
                <div style='background-color: #FBBB01; padding: 25px; text-align: center;'>
                    <h1 style='color: black; margin: 0; font-size: 24px;'>Anthes Epay Admin Portal</h1>
                    <p style='color: rgba(0,0,0,0.8); margin: 5px 0 0; font-size: 16px;'>Email Verification</p>
                </div>
                
                <div style='padding: 25px;'>
                    <h2 style='color: #FBBB01; margin-top: 0;'>Hello {$admin['full_name']},</h2>
                    
                    <p style='font-size: 16px;'>We received a request to resend your verification code.</p>
                    
                    <div style='background-color: #fff9e6; border-left: 4px solid #FBBB01; padding: 15px; margin: 20px 0;'>
                        <h3 style='color: #FBBB01; margin-top: 0;'>Admin Account Details</h3>
                        <p><strong>Admin ID:</strong> {$admin['admin_id']}</p>
                        <p>Please verify your email address to activate your admin account.</p>
                    </div>
                    
                    <div style='text-align: center; margin: 25px 0;'>
                        <a href='$verification_link' style='display: inline-block; padding: 12px 25px; background-color: #FBBB01; color: black; text-decoration: none; border-radius: 5px; font-weight: bold;'>
                            Verify Email Address
                        </a>
                    </div>
                    
                    <p style='font-size: 14px; color: #666;'>This link will expire in 30 minutes.</p>
                    
                    <div style='background-color: #f5f5f5; padding: 15px; border-radius: 5px; margin-top: 20px;'>
                        <p style='margin: 0; font-size: 13px; color: #666;'>If the button above doesn't work, copy and paste this link into your browser:</p>
                        <p style='margin: 5px 0 0; word-break: break-all; font-size: 13px; color: #333; background: #f1f1f1; padding: 10px; border-radius: 3px;'>$verification_link</p>
                    </div>
                </div>
                
                <div style='background-color: #f5f5f5; padding: 15px; text-align: center; font-size: 12px; color: #666;'>
                    <p>© " . date('Y') . " Anthes Epay Management System. All rights reserved.</p>
                </div>
            </div>
            ";
            
            $mail->AltBody = "Hello {$admin['full_name']},\n\n" .
                "We received a request to resend your verification code.\n\n" .
                "Admin Account Details:\n" .
                "Admin ID: {$admin['admin_id']}\n\n" .
                "Please verify your email address by clicking the link below:\n" .
                "$verification_link\n\n" .
                "This link will expire in 30 minutes.\n\n" .
                "If you didn't request this, please ignore this email.\n\n" .
                "Best regards,\n" .
                "Anthes Epay Admin Portal";
            
            $mail->send();
            
            echo json_encode([
                'success' => true,
                'message' => 'New verification code sent successfully! Please check your email.'
            ]);
            exit();
            
        } catch (Exception $e) {
            error_log("Email sending failed: " . $e->getMessage());
            echo json_encode([
                'success' => false,
                'message' => 'Failed to send verification email. Please try again later.'
            ]);
            exit();
        }
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Failed to generate verification code. Please try again.'
        ]);
        exit();
    }
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid request.'
    ]);
    exit();
}
?>