<?php
require_once '../config/conn.php';
session_start();

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

$admin_id = $_SESSION['user_id'];
$data = $_POST;

// Validate withdrawal
$wallet_stmt = $conn->prepare("SELECT balance FROM admin_wallets WHERE admin_id = ?");
$wallet_stmt->bind_param("i", $admin_id);
$wallet_stmt->execute();
$wallet = $wallet_stmt->get_result()->fetch_assoc();

if ($data['amount'] > $wallet['balance']) {
    echo json_encode(['success' => false, 'message' => 'Insufficient balance']);
    exit();
}

// Validate PIN (you should implement PIN verification)
// $pin_stmt = $conn->prepare("SELECT * FROM admin_pins WHERE admin_id = ? AND pin = ?");
// $pin_stmt->bind_param("is", $admin_id, $data['withdrawal_pin']);
// ...

// Create withdrawal request
$reference = 'WTH' . date('Ymd') . str_pad(rand(0, 9999), 4, '0', STR_PAD_LEFT);
$stmt = $conn->prepare("
    INSERT INTO admin_withdrawals (admin_id, amount, bank_account_id, reference) 
    VALUES (?, ?, ?, ?)
");
$stmt->bind_param("idis", $admin_id, $data['amount'], $data['bank_account'], $reference);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Withdrawal request submitted']);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to process withdrawal']);
}
?>