<?php
// process_admin_login.php
session_start();
require '../config/conn.php';
require '../vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $remember_me = isset($_POST['remember_me']) ? 1 : 0;

    $errors = [];

    // Basic validation
    if (empty($email)) {
        $errors['email'] = "Email is required";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors['email'] = "Invalid email format";
    }

    if (empty($password)) {
        $errors['password'] = "Password is required";
    }

    // Only proceed with database check if no validation errors
    if (empty($errors)) {
        // Check if admin exists
        $stmt = $conn->prepare("SELECT id, admin_id, full_name, email, password, is_verified, is_active FROM admins WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows === 1) {
            $admin = $result->fetch_assoc();

            // Verify password
            if (password_verify($password, $admin['password'])) {
                // Check if account is verified
                if (!$admin['is_verified']) {
                    echo json_encode([
                        'success' => false,
                        'message' => 'Account not verified. Please check your email.',
                        'errors' => ['email' => 'Account not verified'],
                        'resend_verification' => true,
                        'email' => $email
                    ]);
                    exit();
                } 
                // Check if account is active
                elseif (!$admin['is_active']) {
                    echo json_encode([
                        'success' => false,
                        'message' => 'Your admin account is not active. Please contact the super admin.',
                        'errors' => ['email' => 'Account not active'],
                        'account_inactive' => true
                    ]);
                    exit();
                }
                else {
                    // Generate a 6-digit verification code
                    $verification_code = str_pad(mt_rand(0, 999999), 6, '0', STR_PAD_LEFT);
                    $expires_at = date('Y-m-d H:i:s', strtotime('+10 minutes'));
                    
                    // Store the code in the database
                    $stmt = $conn->prepare("INSERT INTO admin_verification_codes (admin_id, code, expires_at) VALUES (?, ?, ?)");
                    
                    if ($stmt->bind_param("iss", $admin['id'], $verification_code, $expires_at) && $stmt->execute()) {
                        // Send the verification code via email
                        $mail = new PHPMailer(true);
                        try {
                            // Server settings
                            $mail->isSMTP();
                            $mail->Host       = 'smtp.gmail.com';
                            $mail->SMTPAuth   = true;
          $mail->Username   = 'olorodemicheal2274@gmail.com';
                $mail->Password   = 'farq ptyc vjtl eses';
                            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
                            $mail->Port       = 465;
                            
                            // Recipients
                            $mail->setFrom('noreply@athenian.com', 'Anthes Epay Admin Portal');
                            $mail->addAddress($email, $admin['full_name']);
                            
                            // Content
                            $mail->isHTML(true);
                            $mail->Subject = 'Your Admin Login Verification Code';
                            
                            $mail->Body = "
                            <div style='max-width: 600px; margin: 0 auto; border: 1px solid #e0e0e0; border-radius: 8px; overflow: hidden; font-family: Arial, sans-serif;'>
                                <div style='background-color: #FBBB01; padding: 25px; text-align: center;'>
                                    <h1 style='color: black; margin: 0; font-size: 24px;'>Anthes Epay Admin Portal</h1>
                                    <p style='color: rgba(0,0,0,0.8); margin: 5px 0 0; font-size: 16px;'>Login Verification</p>
                                </div>
                                
                                <div style='padding: 25px;'>
                                    <h2 style='color: #FBBB01; margin-top: 0;'>Hello {$admin['full_name']},</h2>
                                    
                                    <p style='font-size: 16px;'>Your admin login verification code is:</p>
                                    
                                    <div style='text-align: center; margin: 25px 0;'>
                                        <div style='display: inline-block; padding: 15px 30px; background-color: #f5f5f5; border: 2px dashed #FBBB01; border-radius: 5px; font-size: 24px; font-weight: bold; letter-spacing: 5px;'>
                                            $verification_code
                                        </div>
                                    </div>
                                    
                                    <p style='font-size: 14px; color: #666;'>This code will expire in 10 minutes. Please do not share this code with anyone.</p>
                                </div>
                                
                                <div style='background-color: #f5f5f5; padding: 15px; text-align: center; font-size: 12px; color: #666;'>
                                    <p>© " . date('Y') . " Anthes Epay Management System. All rights reserved.</p>
                                </div>
                            </div>
                            ";
                            
                            $mail->AltBody = "Hello {$admin['full_name']},\n\n" .
                                "Your admin login verification code is: $verification_code\n\n" .
                                "This code will expire in 10 minutes. Please do not share this code with anyone.\n\n" .
                                "Best regards,\n" .
                                "Anthes Epay Admin Portal";
                            
                            $mail->send();
                            
                            // Store admin ID in session for verification
                            $_SESSION['admin_2fa_id'] = $admin['id'];
                            $_SESSION['admin_2fa_remember_me'] = $remember_me;
                            
                            echo json_encode([
                                'success' => true,
                                'message' => 'Verification code sent to your email!',
                                'verification_required' => true
                            ]);
                            exit();
                            
                        } catch (Exception $e) {
                            echo json_encode([
                                'success' => false,
                                'message' => 'Failed to send verification code. Please try again.',
                                'errors' => ['email' => 'Email service temporarily unavailable']
                            ]);
                            exit();
                        }
                    } else {
                        echo json_encode([
                            'success' => false,
                            'message' => 'Failed to generate verification code. Please try again.'
                        ]);
                        exit();
                    }
                }
            } else {
                echo json_encode([
                    'success' => false,
                    'message' => 'Incorrect password.',
                    'errors' => ['password' => 'Incorrect password']
                ]);
                exit();
            }
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Email not registered as admin.',
                'errors' => ['email' => 'Email not registered']
            ]);
            exit();
        }
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Please fix the errors below.',
            'errors' => $errors
        ]);
        exit();
    }
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid request method.'
    ]);
    exit();
}
?>