
<?php include 'include/header.php'; ?>

<?php

require '../config/conn.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: admin-login.php");
    exit();
}

$date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : date('Y-m-01');
$end_date = isset($_GET['end_date']) ? $_GET['end_date'] : date('Y-m-t');
$report_type = isset($_GET['report_type']) ? $_GET['report_type'] : 'daily';

// Get reports based on type
if ($report_type === 'daily') {
    $reports_query = "
        SELECT 
            transaction_date,
            COUNT(*) as vendor_count,
            SUM(total_amount) as total_amount,
            SUM(approved_amount) as approved_amount,
            SUM(pending_amount) as pending_amount
        FROM vendor_daily_transactions
        WHERE transaction_date BETWEEN '$start_date' AND '$end_date'
        GROUP BY transaction_date
        ORDER BY transaction_date DESC
    ";
} elseif ($report_type === 'vendor') {
    $reports_query = "
        SELECT 
            v.id,
            v.business_name,
            COUNT(vdt.id) as days_count,
            SUM(vdt.total_amount) as total_amount,
            SUM(vdt.approved_amount) as approved_amount,
            SUM(vdt.pending_amount) as pending_amount,
            vw.balance,
            vw.pending_balance
        FROM vendors v
        LEFT JOIN vendor_daily_transactions vdt ON v.id = vdt.vendor_id
        LEFT JOIN vendor_wallets vw ON v.id = vw.vendor_id
        WHERE vdt.transaction_date BETWEEN '$start_date' AND '$end_date'
        GROUP BY v.id, v.business_name, vw.balance, vw.pending_balance
        ORDER BY total_amount DESC
    ";
} else {
    $reports_query = "
        SELECT 
            DATE(vdt.created_at) as report_date,
            COUNT(DISTINCT vdt.vendor_id) as vendor_count,
            SUM(vdt.approved_amount) as approved_amount,
            SUM(vdt.pending_amount) as pending_amount,
            COUNT(DISTINCT val.id) as approval_count
        FROM vendor_daily_transactions vdt
        LEFT JOIN vendor_approval_logs val ON vdt.vendor_id = val.vendor_id AND vdt.transaction_date = val.approval_date
        WHERE vdt.transaction_date BETWEEN '$start_date' AND '$end_date'
        GROUP BY DATE(vdt.created_at)
        ORDER BY report_date DESC
    ";
}

$reports_result = mysqli_query($conn, $reports_query);

// Get summary statistics
$summary_query = "
    SELECT 
        COUNT(DISTINCT vdt.vendor_id) as total_vendors,
        SUM(vdt.total_amount) as total_collected,
        SUM(vdt.approved_amount) as total_approved,
        SUM(vdt.pending_amount) as total_pending,
        COUNT(DISTINCT CASE WHEN vdt.pending_amount > 0 THEN vdt.vendor_id END) as vendors_with_pending
    FROM vendor_daily_transactions vdt
    WHERE vdt.transaction_date BETWEEN '$start_date' AND '$end_date'
";
$summary_result = mysqli_query($conn, $summary_query);
$summary = mysqli_fetch_assoc($summary_result);
?>

<?php include 'include/header.php'; ?>

<main class="main-content flex-1 p-6 bg-gray-50 dark:bg-gray-900 overflow-y-auto">
    <div class="max-w-7xl mx-auto">
        <!-- Header -->
        <div class="mb-6">
            <a href="vendor-approval.php?date=<?= $date ?>" 
               class="inline-flex items-center text-primary-500 hover:text-primary-600 mb-4">
                <i class="fas fa-arrow-left mr-2"></i> Back to Approval Page
            </a>
            
            <h1 class="text-2xl font-bold text-gray-900 dark:text-white">Approval Reports</h1>
            <p class="text-gray-600 dark:text-gray-400">Detailed reports and analytics</p>
        </div>

        <!-- Report Filters -->
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700 mb-6">
            <h3 class="text-lg font-semibold dark:text-white mb-4">Report Filters</h3>
            
            <form method="GET" action="" class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div>
                    <label class="block text-sm font-medium dark:text-gray-300 mb-2">Report Type</label>
                    <select name="report_type" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md dark:bg-gray-700 dark:text-white">
                        <option value="daily" <?= $report_type == 'daily' ? 'selected' : '' ?>>Daily Summary</option>
                        <option value="vendor" <?= $report_type == 'vendor' ? 'selected' : '' ?>>Vendor Performance</option>
                        <option value="approval" <?= $report_type == 'approval' ? 'selected' : '' ?>>Approval Tracking</option>
                    </select>
                </div>
                
                <div>
                    <label class="block text-sm font-medium dark:text-gray-300 mb-2">Start Date</label>
                    <input type="date" name="start_date" value="<?= $start_date ?>" 
                           class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md dark:bg-gray-700 dark:text-white">
                </div>
                
                <div>
                    <label class="block text-sm font-medium dark:text-gray-300 mb-2">End Date</label>
                    <input type="date" name="end_date" value="<?= $end_date ?>" 
                           class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md dark:bg-gray-700 dark:text-white">
                </div>
                
                <div class="flex items-end">
                    <button type="submit" 
                            class="w-full px-4 py-2 bg-primary-500 hover:bg-primary-600 text-white rounded-md">
                        Generate Report
                    </button>
                </div>
            </form>
            
            <!-- Quick Date Buttons -->
            <div class="flex space-x-2 mt-4">
                <button onclick="setDateRange('today')" 
                        class="px-3 py-1 bg-gray-200 dark:bg-gray-700 hover:bg-gray-300 dark:hover:bg-gray-600 rounded text-sm">
                    Today
                </button>
                <button onclick="setDateRange('yesterday')" 
                        class="px-3 py-1 bg-gray-200 dark:bg-gray-700 hover:bg-gray-300 dark:hover:bg-gray-600 rounded text-sm">
                    Yesterday
                </button>
                <button onclick="setDateRange('this_week')" 
                        class="px-3 py-1 bg-gray-200 dark:bg-gray-700 hover:bg-gray-300 dark:hover:bg-gray-600 rounded text-sm">
                    This Week
                </button>
                <button onclick="setDateRange('this_month')" 
                        class="px-3 py-1 bg-gray-200 dark:bg-gray-700 hover:bg-gray-300 dark:hover:bg-gray-600 rounded text-sm">
                    This Month
                </button>
            </div>
        </div>

        <!-- Summary Cards -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
                <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Total Collected</p>
                <p class="text-2xl font-bold text-gray-900 dark:text-white">
                    ₦<?= number_format($summary['total_collected'] ?? 0, 2) ?>
                </p>
            </div>
            
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
                <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Total Approved</p>
                <p class="text-2xl font-bold text-green-600 dark:text-green-400">
                    ₦<?= number_format($summary['total_approved'] ?? 0, 2) ?>
                </p>
            </div>
            
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
                <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Total Pending</p>
                <p class="text-2xl font-bold text-yellow-600 dark:text-yellow-400">
                    ₦<?= number_format($summary['total_pending'] ?? 0, 2) ?>
                </p>
            </div>
            
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
                <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Vendors</p>
                <p class="text-2xl font-bold text-gray-900 dark:text-white">
                    <?= $summary['total_vendors'] ?? 0 ?>
                </p>
            </div>
        </div>

        <!-- Reports Table -->
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm border border-gray-100 dark:border-gray-700 overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-100 dark:border-gray-700">
                <div class="flex flex-col md:flex-row md:items-center justify-between">
                    <h3 class="text-lg font-semibold dark:text-white">
                        <?= ucfirst($report_type) ?> Report
                        <span class="text-sm text-gray-500">
                            (<?= date('M j, Y', strtotime($start_date)) ?> - <?= date('M j, Y', strtotime($end_date)) ?>)
                        </span>
                    </h3>
                    <div class="mt-2 md:mt-0">
                        <button onclick="printReport()" 
                                class="px-4 py-2 bg-blue-500 hover:bg-blue-600 text-white rounded-md text-sm mr-2">
                            <i class="fas fa-print mr-2"></i> Print
                        </button>
                        <button onclick="exportReport()" 
                                class="px-4 py-2 bg-green-500 hover:bg-green-600 text-white rounded-md text-sm">
                            <i class="fas fa-file-excel mr-2"></i> Export
                        </button>
                    </div>
                </div>
            </div>

            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700" id="reportTable">
                    <thead class="bg-gray-50 dark:bg-gray-800">
                        <?php if ($report_type === 'daily'): ?>
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Date</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Vendors</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Total Amount</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Approved</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Pending</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Approval Rate</th>
                        </tr>
                        <?php elseif ($report_type === 'vendor'): ?>
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Vendor</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Days</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Total Amount</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Approved</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Pending</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Current Balance</th>
                        </tr>
                        <?php else: ?>
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Date</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Vendors</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Approved Amount</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Pending Amount</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Approvals</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Status</th>
                        </tr>
                        <?php endif; ?>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                        <?php if (mysqli_num_rows($reports_result) > 0): ?>
                            <?php while ($report = mysqli_fetch_assoc($reports_result)): ?>
                                <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                                    <?php if ($report_type === 'daily'): ?>
                                        <td class="px-6 py-4 text-sm font-medium dark:text-white">
                                            <?= date('M j, Y', strtotime($report['transaction_date'])) ?>
                                        </td>
                                        <td class="px-6 py-4 text-sm text-gray-700 dark:text-gray-300">
                                            <?= $report['vendor_count'] ?>
                                        </td>
                                        <td class="px-6 py-4 text-sm font-medium text-gray-900 dark:text-white">
                                            ₦<?= number_format($report['total_amount'], 2) ?>
                                        </td>
                                        <td class="px-6 py-4 text-sm font-medium text-green-600 dark:text-green-400">
                                            ₦<?= number_format($report['approved_amount'], 2) ?>
                                        </td>
                                        <td class="px-6 py-4 text-sm font-medium text-yellow-600 dark:text-yellow-400">
                                            ₦<?= number_format($report['pending_amount'], 2) ?>
                                        </td>
                                        <td class="px-6 py-4 text-sm">
                                            <?php
                                            $approval_rate = $report['total_amount'] > 0 ? ($report['approved_amount'] / $report['total_amount']) * 100 : 0;
                                            $rate_class = $approval_rate >= 80 ? 'text-green-600' : ($approval_rate >= 50 ? 'text-yellow-600' : 'text-red-600');
                                            ?>
                                            <span class="font-medium <?= $rate_class ?>">
                                                <?= number_format($approval_rate, 1) ?>%
                                            </span>
                                        </td>
                                    
                                    <?php elseif ($report_type === 'vendor'): ?>
                                        <td class="px-6 py-4">
                                            <div class="text-sm font-medium dark:text-white">
                                                <?= htmlspecialchars($report['business_name']) ?>
                                            </div>
                                            <div class="text-xs text-gray-500">ID: <?= $report['id'] ?></div>
                                        </td>
                                        <td class="px-6 py-4 text-sm text-gray-700 dark:text-gray-300">
                                            <?= $report['days_count'] ?>
                                        </td>
                                        <td class="px-6 py-4 text-sm font-medium text-gray-900 dark:text-white">
                                            ₦<?= number_format($report['total_amount'], 2) ?>
                                        </td>
                                        <td class="px-6 py-4 text-sm font-medium text-green-600 dark:text-green-400">
                                            ₦<?= number_format($report['approved_amount'], 2) ?>
                                        </td>
                                        <td class="px-6 py-4 text-sm font-medium text-yellow-600 dark:text-yellow-400">
                                            ₦<?= number_format($report['pending_amount'], 2) ?>
                                        </td>
                                        <td class="px-6 py-4">
                                            <div class="text-sm">
                                                <div class="text-green-600">Approved: ₦<?= number_format($report['balance'], 2) ?></div>
                                                <div class="text-yellow-600">Pending: ₦<?= number_format($report['pending_balance'], 2) ?></div>
                                            </div>
                                        </td>
                                    
                                    <?php else: ?>
                                        <td class="px-6 py-4 text-sm font-medium dark:text-white">
                                            <?= date('M j, Y', strtotime($report['report_date'])) ?>
                                        </td>
                                        <td class="px-6 py-4 text-sm text-gray-700 dark:text-gray-300">
                                            <?= $report['vendor_count'] ?>
                                        </td>
                                        <td class="px-6 py-4 text-sm font-medium text-green-600 dark:text-green-400">
                                            ₦<?= number_format($report['approved_amount'], 2) ?>
                                        </td>
                                        <td class="px-6 py-4 text-sm font-medium text-yellow-600 dark:text-yellow-400">
                                            ₦<?= number_format($report['pending_amount'], 2) ?>
                                        </td>
                                        <td class="px-6 py-4 text-sm text-gray-700 dark:text-gray-300">
                                            <?= $report['approval_count'] ?>
                                        </td>
                                        <td class="px-6 py-4 text-sm">
                                            <?php
                                            $pending_rate = $report['pending_amount'] > 0 ? 'bg-yellow-100 text-yellow-800' : 'bg-green-100 text-green-800';
                                            $status_text = $report['pending_amount'] > 0 ? 'Pending' : 'Completed';
                                            ?>
                                            <span class="px-2 py-1 rounded-full text-xs font-medium <?= $pending_rate ?>">
                                                <?= $status_text ?>
                                            </span>
                                        </td>
                                    <?php endif; ?>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" class="px-6 py-8 text-center text-gray-500 dark:text-gray-400">
                                    No report data found for the selected period
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Charts Section -->
        <div class="mt-6 bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
            <h3 class="text-lg font-semibold dark:text-white mb-4">Report Summary</h3>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Approval Rate -->
                <div>
                    <h4 class="text-sm font-medium text-gray-500 dark:text-gray-400 mb-2">Approval Rate</h4>
                    <div class="h-4 bg-gray-200 dark:bg-gray-700 rounded-full overflow-hidden">
                        <?php
                        $approved_rate = $summary['total_collected'] > 0 ? ($summary['total_approved'] / $summary['total_collected']) * 100 : 0;
                        ?>
                        <div class="h-full bg-green-500" style="width: <?= $approved_rate ?>%"></div>
                    </div>
                    <div class="flex justify-between mt-2">
                        <span class="text-sm text-gray-600 dark:text-gray-400">Approved: <?= number_format($approved_rate, 1) ?>%</span>
                        <span class="text-sm text-gray-600 dark:text-gray-400">Pending: <?= number_format(100 - $approved_rate, 1) ?>%</span>
                    </div>
                </div>
                
                <!-- Average Per Vendor -->
                <div>
                    <h4 class="text-sm font-medium text-gray-500 dark:text-gray-400 mb-2">Average per Vendor</h4>
                    <div class="grid grid-cols-2 gap-4">
                        <div class="text-center p-3 bg-gray-50 dark:bg-gray-700 rounded">
                            <p class="text-sm text-gray-500 dark:text-gray-400">Daily Average</p>
                            <p class="text-lg font-bold text-gray-900 dark:text-white">
                                ₦<?= number_format(($summary['total_collected'] ?? 0) / max($summary['total_vendors'] ?? 1, 1), 2) ?>
                            </p>
                        </div>
                        <div class="text-center p-3 bg-green-50 dark:bg-green-900/30 rounded">
                            <p class="text-sm text-green-600 dark:text-green-400">Approval Rate</p>
                            <p class="text-lg font-bold text-green-600 dark:text-green-400">
                                <?= number_format($approved_rate, 1) ?>%
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<script>
function setDateRange(type) {
    let startDate = new Date();
    let endDate = new Date();
    
    switch(type) {
        case 'today':
            // Already set
            break;
        case 'yesterday':
            startDate.setDate(startDate.getDate() - 1);
            endDate.setDate(endDate.getDate() - 1);
            break;
        case 'this_week':
            startDate.setDate(startDate.getDate() - startDate.getDay() + 1); // Monday
            break;
        case 'this_month':
            startDate.setDate(1);
            endDate = new Date(startDate.getFullYear(), startDate.getMonth() + 1, 0);
            break;
    }
    
    const startStr = startDate.toISOString().split('T')[0];
    const endStr = endDate.toISOString().split('T')[0];
    
    const url = new URL(window.location.href);
    url.searchParams.set('start_date', startStr);
    url.searchParams.set('end_date', endStr);
    window.location.href = url.toString();
}

function printReport() {
    window.print();
}

function exportReport() {
    const table = document.getElementById('reportTable');
    let csv = [];
    
    // Get headers
    let headers = [];
    for (let i = 0; i < table.rows[0].cells.length; i++) {
        headers.push(table.rows[0].cells[i].innerText);
    }
    csv.push(headers.join(','));
    
    // Get rows
    for (let i = 1; i < table.rows.length; i++) {
        let row = [];
        for (let j = 0; j < table.rows[i].cells.length; j++) {
            let cellText = table.rows[i].cells[j].innerText
                .replace(/,/g, '')
                .replace(/₦/g, '')
                .trim();
            row.push(`"${cellText}"`);
        }
        csv.push(row.join(','));
    }
    
    // Download CSV
    const csvContent = "data:text/csv;charset=utf-8," + csv.join('\n');
    const encodedUri = encodeURI(csvContent);
    const link = document.createElement("a");
    link.setAttribute("href", encodedUri);
    link.setAttribute("download", `vendor-report-${new Date().toISOString().split('T')[0]}.csv`);
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
}
</script>

<?php include 'include/footer.php'; ?>