<?php

// vendor-transfer-to-admin.php
session_start();
require '../config/conn.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: admin-login.php");
    exit();
}

$date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');

// Get total approved for the day
$total_approved_query = "
    SELECT COALESCE(SUM(approved_amount), 0) as total_approved
    FROM vendor_daily_transactions
    WHERE transaction_date = '$date'
";
$total_approved_result = mysqli_query($conn, $total_approved_query);
$total_approved = mysqli_fetch_assoc($total_approved_result)['total_approved'];

// Process transfer
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $transfer_amount = floatval($_POST['transfer_amount']);
    $notes = mysqli_real_escape_string($conn, $_POST['notes'] ?? '');
    
    if ($transfer_amount <= 0) {
        $_SESSION['error'] = "Please enter a valid transfer amount.";
        header("Location: vendor-transfer-to-admin.php?date=$date");
        exit();
    }
    
    // Get admin wallet
    $admin_wallet_query = "SELECT * FROM admin_wallets LIMIT 1";
    $admin_wallet_result = mysqli_query($conn, $admin_wallet_query);
    
    if (!$admin_wallet_result || mysqli_num_rows($admin_wallet_result) == 0) {
        // Create admin wallet if doesn't exist
        $create_wallet = "INSERT INTO admin_wallets (admin_id, balance) VALUES (1, 0)";
        mysqli_query($conn, $create_wallet);
        $admin_wallet_id = mysqli_insert_id($conn);
        $admin_wallet_balance = 0;
    } else {
        $admin_wallet = mysqli_fetch_assoc($admin_wallet_result);
        $admin_wallet_id = $admin_wallet['id'];
        $admin_wallet_balance = $admin_wallet['balance'];
    }
    
    mysqli_begin_transaction($conn);
    
    try {
        // Update admin wallet
        $new_admin_balance = $admin_wallet_balance + $transfer_amount;
        $update_admin_wallet = "UPDATE admin_wallets 
                               SET balance = $new_admin_balance, 
                                   updated_at = NOW() 
                               WHERE id = $admin_wallet_id";
        mysqli_query($conn, $update_admin_wallet);
        
        // Create admin wallet transaction
        $admin_transaction_ref = 'DAY-TRANSFER-' . date('YmdHis');
        $admin_wallet_transaction = "
            INSERT INTO admin_wallet_transactions 
            (admin_wallet_id, amount, transaction_type, reference, description, 
             balance_before, balance_after)
            VALUES (
                $admin_wallet_id,
                $transfer_amount,
                'credit',
                '$admin_transaction_ref',
                'Daily transfer from vendor approvals for $date',
                $admin_wallet_balance,
                $new_admin_balance
            )
        ";
        mysqli_query($conn, $admin_wallet_transaction);
        
        // Create transfer log
        $transfer_log = "
            INSERT INTO vendor_transfer_logs 
            (transfer_date, amount, notes, admin_id, created_at)
            VALUES (
                '$date',
                $transfer_amount,
                '$notes',
                {$_SESSION['admin_id']},
                NOW()
            )
        ";
        mysqli_query($conn, $transfer_log);
        
        mysqli_commit($conn);
        
        $_SESSION['success'] = "Successfully transferred ₦" . number_format($transfer_amount, 2) . 
                              " to admin wallet.";
        header("Location: vendor-approval.php?date=$date");
        exit();
        
    } catch (Exception $e) {
        mysqli_rollback($conn);
        $_SESSION['error'] = "Transfer failed: " . $e->getMessage();
        header("Location: vendor-transfer-to-admin.php?date=$date");
        exit();
    }
}

include 'include/header.php';
?>

<main class="main-content flex-1 p-6 bg-gray-50 dark:bg-gray-900 overflow-y-auto">
    <div class="max-w-4xl mx-auto">
        <!-- Header -->
        <div class="mb-6">
            <a href="vendor-approval.php?date=<?= $date ?>" 
               class="inline-flex items-center text-primary-500 hover:text-primary-600 mb-4">
                <i class="fas fa-arrow-left mr-2"></i> Back to Approval Page
            </a>
            
            <h1 class="text-2xl font-bold text-gray-900 dark:text-white">Transfer to Admin Wallet</h1>
            <p class="text-gray-600 dark:text-gray-400">
                Transfer approved vendor money to admin wallet for <?= date('F j, Y', strtotime($date)) ?>
            </p>
        </div>

        <!-- Statistics -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
                <div class="flex items-center">
                    <div class="w-12 h-12 rounded-full bg-green-50 dark:bg-green-900/30 flex items-center justify-center mr-4">
                        <i class="fas fa-money-bill-wave text-green-500 dark:text-green-400 text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Approved Today</p>
                        <p class="text-2xl font-bold text-gray-900 dark:text-white">
                            ₦<?= number_format($total_approved, 2) ?>
                        </p>
                    </div>
                </div>
            </div>
            
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
                <div class="flex items-center">
                    <div class="w-12 h-12 rounded-full bg-blue-50 dark:bg-blue-900/30 flex items-center justify-center mr-4">
                        <i class="fas fa-wallet text-blue-500 dark:text-blue-400 text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Admin Wallet</p>
                        <?php
                        $admin_wallet_query = "SELECT balance FROM admin_wallets LIMIT 1";
                        $admin_wallet_result = mysqli_query($conn, $admin_wallet_query);
                        $admin_wallet = mysqli_fetch_assoc($admin_wallet_result);
                        ?>
                        <p class="text-2xl font-bold text-blue-600 dark:text-blue-400">
                            ₦<?= number_format($admin_wallet['balance'] ?? 0, 2) ?>
                        </p>
                    </div>
                </div>
            </div>
            
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
                <div class="flex items-center">
                    <div class="w-12 h-12 rounded-full bg-purple-50 dark:bg-purple-900/30 flex items-center justify-center mr-4">
                        <i class="fas fa-calendar-day text-purple-500 dark:text-purple-400 text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Date</p>
                        <p class="text-2xl font-bold text-gray-900 dark:text-white">
                            <?= date('M j, Y', strtotime($date)) ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Transfer Form -->
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
            <form method="POST" action="vendor-transfer-to-admin.php">
                <input type="hidden" name="date" value="<?= $date ?>">
                
                <div class="space-y-6">
                    <!-- Transfer Amount -->
                    <div>
                        <label for="transfer_amount" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Transfer Amount *
                        </label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <span class="text-gray-500 dark:text-gray-400">₦</span>
                            </div>
                            <input type="number" id="transfer_amount" name="transfer_amount" 
                                   step="0.01" min="0.01" max="<?= $total_approved ?>"
                                   value="<?= $total_approved ?>"
                                   class="pl-8 w-full px-3 py-3 border border-gray-300 dark:border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary-500 dark:bg-gray-700 dark:text-white"
                                   required>
                        </div>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-2">
                            Max: ₦<?= number_format($total_approved, 2) ?> (Today's total approved)
                        </p>
                    </div>
                    
                    <!-- Quick Amount Buttons -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Quick Amount
                        </label>
                        <div class="flex flex-wrap gap-2">
                            <button type="button" onclick="setAmount(10000)" 
                                    class="px-3 py-2 bg-gray-100 dark:bg-gray-700 hover:bg-gray-200 dark:hover:bg-gray-600 text-gray-800 dark:text-white rounded-md text-sm">
                                ₦10,000
                            </button>
                            <button type="button" onclick="setAmount(50000)" 
                                    class="px-3 py-2 bg-gray-100 dark:bg-gray-700 hover:bg-gray-200 dark:hover:bg-gray-600 text-gray-800 dark:text-white rounded-md text-sm">
                                ₦50,000
                            </button>
                            <button type="button" onclick="setAmount(100000)" 
                                    class="px-3 py-2 bg-gray-100 dark:bg-gray-700 hover:bg-gray-200 dark:hover:bg-gray-600 text-gray-800 dark:text-white rounded-md text-sm">
                                ₦100,000
                            </button>
                            <button type="button" onclick="setAmount(<?= $total_approved ?>)" 
                                    class="px-3 py-2 bg-green-100 dark:bg-green-900/30 hover:bg-green-200 dark:hover:bg-green-800/30 text-green-800 dark:text-green-400 rounded-md text-sm">
                                Full Amount
                            </button>
                        </div>
                    </div>
                    
                    <!-- Notes -->
                    <div>
                        <label for="notes" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Notes (Optional)
                        </label>
                        <textarea id="notes" name="notes" rows="3" 
                                  class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md focus:outline-none focus:ring-2 focus:ring-primary-500 dark:bg-gray-700 dark:text-white"
                                  placeholder="Add notes about this transfer"></textarea>
                    </div>
                    
                    <!-- Preview -->
                    <div class="bg-blue-50 dark:bg-blue-900/30 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
                        <h4 class="font-medium text-blue-800 dark:text-blue-300 mb-3">Transfer Preview</h4>
                        <div class="grid grid-cols-2 gap-4 text-sm">
                            <div>
                                <p class="text-blue-600 dark:text-blue-400">Current Admin Balance</p>
                                <p class="font-medium text-gray-900 dark:text-white">
                                    ₦<?= number_format($admin_wallet['balance'] ?? 0, 2) ?>
                                </p>
                            </div>
                            <div>
                                <p class="text-blue-600 dark:text-blue-400">After Transfer</p>
                                <p class="font-medium text-green-600 dark:text-green-400" id="previewNewBalance">
                                    ₦<?= number_format(($admin_wallet['balance'] ?? 0) + $total_approved, 2) ?>
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Submit Buttons -->
                    <div class="flex justify-end space-x-3 pt-4 border-t border-gray-200 dark:border-gray-700">
                        <a href="vendor-approval.php?date=<?= $date ?>" 
                           class="px-6 py-3 bg-gray-200 dark:bg-gray-700 hover:bg-gray-300 dark:hover:bg-gray-600 text-gray-800 dark:text-white rounded-md font-medium">
                            Cancel
                        </a>
                        <button type="submit" 
                                class="px-6 py-3 bg-green-500 hover:bg-green-600 text-white rounded-md font-medium">
                            <i class="fas fa-money-bill-transfer mr-2"></i> Confirm Transfer
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</main>

<script>
const currentBalance = <?= $admin_wallet['balance'] ?? 0 ?>;
const maxAmount = <?= $total_approved ?>;

function setAmount(amount) {
    if (amount > maxAmount) {
        amount = maxAmount;
    }
    document.getElementById('transfer_amount').value = amount.toFixed(2);
    updatePreview();
}

function updatePreview() {
    const amountInput = document.getElementById('transfer_amount');
    const amount = parseFloat(amountInput.value) || 0;
    
    // Validate max amount
    if (amount > maxAmount) {
        amountInput.value = maxAmount.toFixed(2);
        amount = maxAmount;
    }
    
    // Update preview
    const newBalance = currentBalance + amount;
    document.getElementById('previewNewBalance').textContent = '₦' + newBalance.toFixed(2);
}

// Add event listener
document.getElementById('transfer_amount').addEventListener('input', updatePreview);

// Initialize on page load
updatePreview();
</script>

<?php include 'include/footer.php'; ?>