<?php 
// Start output buffering at the very beginning
ob_start();

require '../config/conn.php';

require '../vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

// Handle AJAX requests
if (isset($_POST['ajax_action'])) {
    header('Content-Type: application/json');
    
    switch ($_POST['ajax_action']) {
        case 'approve_vendor':
            $vendorId = intval($_POST['vendor_id']);
            $adminId = $_SESSION['admin_id'] ?? 1;
            
            // Get vendor email first
            $stmt = mysqli_prepare($conn, "SELECT email, business_name FROM vendors WHERE id = ?");
            mysqli_stmt_bind_param($stmt, "i", $vendorId);
            mysqli_stmt_execute($stmt);
            $result = mysqli_stmt_get_result($stmt);
            $vendor = mysqli_fetch_assoc($result);
            
            if ($vendor) {
                // Update vendor status
                $stmt = mysqli_prepare($conn, "UPDATE vendors SET is_approved = 1, approved_by = ?, approval_date = NOW() WHERE id = ?");
                mysqli_stmt_bind_param($stmt, "ii", $adminId, $vendorId);
                
                if (mysqli_stmt_execute($stmt)) {
                    // Send approval email
                    $emailSent = sendApprovalEmail($vendor['email'], $vendor['business_name']);
                    
                    echo json_encode([
                        'success' => true,
                        'message' => 'Vendor approved successfully' . ($emailSent ? ' and email sent' : ' but email failed to send')
                    ]);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Failed to approve vendor']);
                }
            } else {
                echo json_encode(['success' => false, 'message' => 'Vendor not found']);
            }
            exit;
            
        case 'disapprove_vendor':
            $vendorId = intval($_POST['vendor_id']);
            $adminId = $_SESSION['admin_id'] ?? 1;
            
            $stmt = mysqli_prepare($conn, "UPDATE vendors SET is_approved = -1, approved_by = ?, approval_date = NOW() WHERE id = ?");
            mysqli_stmt_bind_param($stmt, "ii", $adminId, $vendorId);
            
            if (mysqli_stmt_execute($stmt)) {
                echo json_encode(['success' => true, 'message' => 'Vendor disapproved successfully']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Failed to disapprove vendor']);
            }
            exit;
            
        case 'reset_vendor':
            $vendorId = intval($_POST['vendor_id']);
            
            $stmt = mysqli_prepare($conn, "UPDATE vendors SET is_approved = 0, approved_by = NULL, approval_date = NULL WHERE id = ?");
            mysqli_stmt_bind_param($stmt, "i", $vendorId);
            
            if (mysqli_stmt_execute($stmt)) {
                echo json_encode(['success' => true, 'message' => 'Vendor status reset to pending successfully']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Failed to reset vendor status']);
            }
            exit;
    }
}

// Email sending function
function sendApprovalEmail($vendorEmail, $businessName) {
    $mail = new PHPMailer(true);
    
    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host       = 'smtp.gmail.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'olorodemicheal2274@gmail.com';
        $mail->Password   = 'farq ptyc vjtl eses';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port       = 465;
        
        // Recipients
        $mail->setFrom('olorodemicheal2274@gmail.com', 'Epay Management');
        $mail->addAddress($vendorEmail, $businessName);
        
        // Content
        $mail->isHTML(true);
        $mail->Subject = 'Vendor Account Approved - Epay Management';
        $mail->Body    = "
            <html>
            <head>
                <style>
                    body { font-family: Arial, sans-serif; }
                    .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                    .header { background: #4F46E5; color: white; padding: 20px; text-align: center; }
                    .content { padding: 20px; background: #f9f9f9; }
                    .footer { padding: 20px; text-align: center; color: #666; }
                </style>
            </head>
            <body>
                <div class='container'>
                    <div class='header'>
                        <h1>Account Approved!</h1>
                    </div>
                    <div class='content'>
                        <h2>Dear $businessName,</h2>
                        <p>We are pleased to inform you that your vendor account has been approved.</p>
                        <p>You can now access all features of your vendor dashboard and start managing your services.</p>
                        <p><strong>Next Steps:</strong></p>
                        <ul>
                            <li>Login to your vendor dashboard</li>
                            <li>Complete your business profile</li>
                            <li>Start adding your services</li>
                        </ul>
                        <p>If you have any questions, please contact our support team.</p>
                    </div>
                    <div class='footer'>
                        <p>Best regards,<br>Epay Management Team</p>
                    </div>
                </div>
            </body>
            </html>
        ";
        
        $mail->AltBody = "Dear $businessName,\n\nWe are pleased to inform you that your vendor account has been approved.\n\nYou can now access all features of your vendor dashboard and start managing your services.\n\nBest regards,\nEpay Management Team";
        
        $mail->send();
        return true;
    } catch (Exception $e) {
        error_log("Email sending failed: " . $mail->ErrorInfo);
        return false;
    }
}

include 'include/header.php'; 
?>

<!-- Content Area -->
<main class="main-content flex-1 p-6 bg-gray-50 dark:bg-gray-900 overflow-y-auto">
    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Total Vendors</p>
                    <p class="text-2xl font-bold dark:text-white">
                        <?php
                        $result = mysqli_query($conn, "SELECT COUNT(*) as total FROM vendors");
                        $row = mysqli_fetch_assoc($result);
                        echo $row['total'];
                        ?>
                    </p>
                </div>
                <div class="p-3 bg-blue-100 dark:bg-blue-900 rounded-lg">
                    <i class="fas fa-store text-blue-500 text-xl"></i>
                </div>
            </div>
        </div>
        
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Pending Approval</p>
                    <p class="text-2xl font-bold dark:text-white">
                        <?php
                        $result = mysqli_query($conn, "SELECT COUNT(*) as total FROM vendors WHERE is_approved = 0 AND is_verified = 1");
                        $row = mysqli_fetch_assoc($result);
                        echo $row['total'];
                        ?>
                    </p>
                </div>
                <div class="p-3 bg-yellow-100 dark:bg-yellow-900 rounded-lg">
                    <i class="fas fa-clock text-yellow-500 text-xl"></i>
                </div>
            </div>
        </div>
        
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Approved Vendors</p>
                    <p class="text-2xl font-bold dark:text-white">
                        <?php
                        $result = mysqli_query($conn, "SELECT COUNT(*) as total FROM vendors WHERE is_approved = 1");
                        $row = mysqli_fetch_assoc($result);
                        echo $row['total'];
                        ?>
                    </p>
                </div>
                <div class="p-3 bg-green-100 dark:bg-green-900 rounded-lg">
                    <i class="fas fa-check-circle text-green-500 text-xl"></i>
                </div>
            </div>
        </div>
        
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Disapproved</p>
                    <p class="text-2xl font-bold dark:text-white">
                        <?php
                        $result = mysqli_query($conn, "SELECT COUNT(*) as total FROM vendors WHERE is_approved = -1");
                        $row = mysqli_fetch_assoc($result);
                        echo $row['total'];
                        ?>
                    </p>
                </div>
                <div class="p-3 bg-red-100 dark:bg-red-900 rounded-lg">
                    <i class="fas fa-ban text-red-500 text-xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Vendor Management Section -->
    <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700 mb-6">
        <div class="flex flex-col md:flex-row md:justify-between md:items-center mb-6">
            <h3 class="text-lg font-semibold dark:text-white mb-4 md:mb-0">Manage Vendors</h3>
            <div class="flex flex-col sm:flex-row space-y-2 sm:space-y-0 sm:space-x-3">
                <form method="get" action="" class="relative">
                    <input type="text" name="search" placeholder="Search vendors..." 
                           value="<?= htmlspecialchars($_GET['search'] ?? '') ?>" 
                           class="search-input pl-10 pr-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500 dark:bg-gray-700 dark:text-white">
                    <i class="fas fa-search absolute left-3 top-3 text-gray-400"></i>
                </form>
            </div>
        </div>
        
        <!-- Tabs -->
        <div class="border-b border-gray-200 dark:border-gray-700 mb-6">
            <ul class="flex flex-wrap -mb-px" id="vendor-tabs">
                <li class="mr-2">
                    <a href="?status=all<?= isset($_GET['search']) ? '&search=' . htmlspecialchars($_GET['search']) : '' ?>" 
                       class="inline-block p-4 border-b-2 <?= (!isset($_GET['status']) || $_GET['status'] === 'all') ? 'border-primary-500 text-primary-500 dark:text-primary-400 dark:border-primary-400' : 'border-transparent' ?> rounded-t-lg">
                        All Vendors
                    </a>
                </li>
                <li class="mr-2">
                    <a href="?status=pending<?= isset($_GET['search']) ? '&search=' . htmlspecialchars($_GET['search']) : '' ?>" 
                       class="inline-block p-4 border-b-2 <?= (isset($_GET['status']) && $_GET['status'] === 'pending') ? 'border-primary-500 text-primary-500 dark:text-primary-400 dark:border-primary-400' : 'border-transparent' ?> rounded-t-lg">
                        Pending
                    </a>
                </li>
                <li class="mr-2">
                    <a href="?status=disapproved<?= isset($_GET['search']) ? '&search=' . htmlspecialchars($_GET['search']) : '' ?>" 
                       class="inline-block p-4 border-b-2 <?= (isset($_GET['status']) && $_GET['status'] === 'disapproved') ? 'border-primary-500 text-primary-500 dark:text-primary-400 dark:border-primary-400' : 'border-transparent' ?> rounded-t-lg">
                        Disapproved
                    </a>
                </li>
                <li class="mr-2">
                    <a href="?status=approved<?= isset($_GET['search']) ? '&search=' . htmlspecialchars($_GET['search']) : '' ?>" 
                       class="inline-block p-4 border-b-2 <?= (isset($_GET['status']) && $_GET['status'] === 'approved') ? 'border-primary-500 text-primary-500 dark:text-primary-400 dark:border-primary-400' : 'border-transparent' ?> rounded-t-lg">
                        Approved
                    </a>
                </li>
            </ul>
        </div>
        
        <!-- Vendors Table -->
        <div class="overflow-x-auto">
            <table class="w-full" id="vendors-table">
                <thead>
                    <tr>
                        <th class="text-left py-3 px-4 dark:text-white">Vendor ID</th>
                        <th class="text-left py-3 px-4 dark:text-white">Business Name</th>
                        <th class="text-left py-3 px-4 dark:text-white">Email</th>
                        <th class="text-left py-3 px-4 dark:text-white">Business Type</th>
                        <th class="text-left py-3 px-4 dark:text-white">Status</th>
                        <th class="text-left py-3 px-4 dark:text-white">Actions</th>
                    </tr>
                </thead>
                <tbody id="vendors-table-body">
                    <?php
                    // Get vendor data based on current filters
                    $status = $_GET['status'] ?? 'all';
                    $search = $_GET['search'] ?? '';
                    $page = max(1, intval($_GET['page'] ?? 1));
                    $perPage = 10;
                    $offset = ($page - 1) * $perPage;
                    
                    // Build query
                    $where = [];
                    $params = [];
                    $types = '';
                    
                    if ($status === 'approved') {
                        $where[] = "is_approved = 1";
                    } elseif ($status === 'pending') {
                        $where[] = "is_approved = 0 AND is_verified = 1";
                    } elseif ($status === 'disapproved') {
                        $where[] = "is_approved = -1";
                    }
                    
                    if ($search) {
                        $where[] = "(business_name LIKE ? OR email LIKE ? OR vendor_id LIKE ?)";
                        $searchTerm = "%$search%";
                        $params = array_merge($params, [$searchTerm, $searchTerm, $searchTerm]);
                        $types .= 'sss';
                    }
                    
                    $whereClause = $where ? "WHERE " . implode(" AND ", $where) : "";
                    
                    // Get total count
                    $countQuery = "SELECT COUNT(*) FROM vendors $whereClause";
                    if ($params) {
                        $stmt = mysqli_prepare($conn, $countQuery);
                        mysqli_stmt_bind_param($stmt, $types, ...$params);
                        mysqli_stmt_execute($stmt);
                        $result = mysqli_stmt_get_result($stmt);
                    } else {
                        $result = mysqli_query($conn, $countQuery);
                    }
                    $total = mysqli_fetch_row($result)[0];
                    
                    // Get paginated results
                    $query = "SELECT id, vendor_id, business_name, email, phone, business_type, is_verified, is_approved 
                              FROM vendors $whereClause 
                              ORDER BY created_at DESC 
                              LIMIT ? OFFSET ?";
                    
                    $types .= 'ii';
                    $params[] = $perPage;
                    $params[] = $offset;
                    
                    $stmt = mysqli_prepare($conn, $query);
                    mysqli_stmt_bind_param($stmt, $types, ...$params);
                    mysqli_stmt_execute($stmt);
                    $result = mysqli_stmt_get_result($stmt);
                    
                    if (mysqli_num_rows($result) === 0): ?>
                        <tr>
                            <td colspan="6" class="text-center py-4 text-gray-500 dark:text-gray-400">No vendors found</td>
                        </tr>
                    <?php else: 
                        while ($vendor = mysqli_fetch_assoc($result)): ?>
                            <tr class="hover:bg-gray-50 dark:hover:bg-gray-700" id="vendor-row-<?= $vendor['id'] ?>">
                                <td class="py-3 px-4 dark:text-white"><?= htmlspecialchars($vendor['vendor_id']) ?></td>
                                <td class="py-3 px-4 dark:text-white"><?= htmlspecialchars($vendor['business_name']) ?></td>
                                <td class="py-3 px-4 dark:text-white"><?= htmlspecialchars($vendor['email']) ?></td>
                                <td class="py-3 px-4 dark:text-white"><?= htmlspecialchars($vendor['business_type']) ?></td>
                                <td class="py-3 px-4">
                                    <?php if ($vendor['is_approved'] == '1'): ?>
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">Approved</span>
                                    <?php elseif ($vendor['is_approved'] == '0' && $vendor['is_verified'] == '1'): ?>
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200">Pending</span>
                                    <?php elseif ($vendor['is_approved'] == '-1'): ?>
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200">Disapproved</span>
                                    <?php else: ?>
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300">Unverified</span>
                                    <?php endif; ?>
                                </td>
                                <td class="py-3 px-4">
                                    <div class="flex space-x-2">
                                        <a href="?action=view&id=<?= $vendor['id'] ?>&<?= http_build_query(array_diff_key($_GET, ['action' => '', 'id' => ''])) ?>" 
                                           class="text-blue-500 hover:text-blue-700 dark:hover:text-blue-400" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <?php if ($vendor['is_approved'] != '1'): ?>
                                            <button onclick="approveVendor(<?= $vendor['id'] ?>)" class="text-green-500 hover:text-green-700 dark:hover:text-green-400" title="Approve">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        <?php endif; ?>
                                        <?php if ($vendor['is_approved'] != '-1'): ?>
                                            <button onclick="disapproveVendor(<?= $vendor['id'] ?>)" class="text-yellow-500 hover:text-yellow-700 dark:hover:text-yellow-400" title="Disapprove">
                                                <i class="fas fa-ban"></i>
                                            </button>
                                        <?php endif; ?>
                                        <?php if ($vendor['is_approved'] == '1' || $vendor['is_approved'] == '-1'): ?>
                                            <button onclick="resetVendor(<?= $vendor['id'] ?>)" class="text-blue-500 hover:text-blue-700 dark:hover:text-blue-400" title="Reset to Pending">
                                                <i class="fas fa-undo"></i>
                                            </button>
                                        <?php endif; ?>
                                        <button onclick="deleteVendor(<?= $vendor['id'] ?>)" class="text-red-500 hover:text-red-700 dark:hover:text-red-400" title="Delete">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endwhile;
                    endif; ?>
                </tbody>
            </table>
        </div>
        
        <!-- Pagination -->
        <div class="flex flex-col sm:flex-row items-center justify-between mt-6 space-y-3 sm:space-y-0" id="vendor-pagination">
            <?php if ($total > 0): ?>
                <div class="text-sm text-gray-500 dark:text-gray-400">
                    Showing <span class="font-medium"><?= ($page - 1) * $perPage + 1 ?></span> to 
                    <span class="font-medium"><?= min($page * $perPage, $total) ?></span> of 
                    <span class="font-medium"><?= $total ?></span> entries
                </div>
                <div class="flex space-x-2">
                    <!-- Previous button -->
                    <a href="?<?= http_build_query(array_merge($_GET, ['page' => $page - 1])) ?>" 
                       class="px-3 py-1 border border-gray-300 dark:border-gray-600 rounded-md text-sm font-medium text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 <?= $page === 1 ? 'opacity-50 cursor-not-allowed' : '' ?>" 
                       <?= $page === 1 ? 'onclick="return false;"' : '' ?>>
                        Previous
                    </a>
                    
                    <!-- Page numbers -->
                    <?php for ($i = 1; $i <= ceil($total / $perPage); $i++): ?>
                        <a href="?<?= http_build_query(array_merge($_GET, ['page' => $i])) ?>" 
                           class="px-3 py-1 <?= $page === $i ? 'bg-primary-500 text-white' : 'border border-gray-300 dark:border-gray-600 text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700' ?> rounded-md text-sm font-medium">
                            <?= $i ?>
                        </a>
                    <?php endfor; ?>
                    
                    <!-- Next button -->
                    <a href="?<?= http_build_query(array_merge($_GET, ['page' => $page + 1])) ?>" 
                       class="px-3 py-1 border border-gray-300 dark:border-gray-600 rounded-md text-sm font-medium text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 <?= $page >= ceil($total / $perPage) ? 'opacity-50 cursor-not-allowed' : '' ?>" 
                       <?= $page >= ceil($total / $perPage) ? 'onclick="return false;"' : '' ?>>
                        Next
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</main>

<!-- Vendor View Modal -->
<?php if (isset($_GET['action']) && $_GET['action'] === 'view' && isset($_GET['id'])): 
    $vendorId = intval($_GET['id']);
    $stmt = mysqli_prepare($conn, "SELECT * FROM vendors WHERE id = ?");
    mysqli_stmt_bind_param($stmt, "i", $vendorId);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $vendor = mysqli_fetch_assoc($result);
    
    if ($vendor): ?>
        <div id="vendor-view-modal" class="fixed inset-0 z-50 flex items-center justify-center bg-black bg-opacity-50 p-4">
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-xl w-full max-w-4xl max-h-[90vh] overflow-y-auto">
                <div class="p-6">
                    <div class="flex justify-between items-center mb-6 pb-4 border-b border-gray-200 dark:border-gray-700">
                        <h3 class="text-2xl font-bold dark:text-white">Vendor Details</h3>
                        <a href="?" class="text-gray-500 hover:text-gray-700 dark:hover:text-gray-300 text-xl">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                    
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                        <!-- Business Information -->
                        <div>
                            <h4 class="text-lg font-semibold dark:text-white mb-4 text-primary-600">Business Information</h4>
                            <div class="space-y-4">
                                <div>
                                    <label class="text-sm font-medium text-gray-500 dark:text-gray-400">Business Name</label>
                                    <p class="dark:text-white text-lg font-medium"><?= htmlspecialchars($vendor['business_name']) ?></p>
                                </div>
                                <div>
                                    <label class="text-sm font-medium text-gray-500 dark:text-gray-400">Business Type</label>
                                    <p class="dark:text-white"><?= htmlspecialchars($vendor['business_type']) ?></p>
                                </div>
                                <div>
                                    <label class="text-sm font-medium text-gray-500 dark:text-gray-400">Vendor ID</label>
                                    <p class="dark:text-white font-mono"><?= htmlspecialchars($vendor['vendor_id']) ?></p>
                                </div>
                                <div>
                                    <label class="text-sm font-medium text-gray-500 dark:text-gray-400">Address</label>
                                    <p class="dark:text-white"><?= htmlspecialchars($vendor['address'] ?? 'Not provided') ?></p>
                                </div>
                                <div>
                                    <label class="text-sm font-medium text-gray-500 dark:text-gray-400">Business Registration</label>
                                    <p class="dark:text-white"><?= htmlspecialchars($vendor['business_reg_number'] ?? 'Not provided') ?></p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Contact Information -->
                        <div>
                            <h4 class="text-lg font-semibold dark:text-white mb-4 text-primary-600">Contact Information</h4>
                            <div class="space-y-4">
                                <div>
                                    <label class="text-sm font-medium text-gray-500 dark:text-gray-400">Email Address</label>
                                    <p class="dark:text-white"><?= htmlspecialchars($vendor['email']) ?></p>
                                </div>
                                <div>
                                    <label class="text-sm font-medium text-gray-500 dark:text-gray-400">Phone Number</label>
                                    <p class="dark:text-white"><?= htmlspecialchars($vendor['phone']) ?></p>
                                </div>
                                <div>
                                    <label class="text-sm font-medium text-gray-500 dark:text-gray-400">Contact Person</label>
                                    <p class="dark:text-white"><?= htmlspecialchars($vendor['contact_person'] ?? 'Not provided') ?></p>
                                </div>
                                <div>
                                    <label class="text-sm font-medium text-gray-500 dark:text-gray-400">Website</label>
                                    <p class="dark:text-white">
                                        <?php if (!empty($vendor['website'])): ?>
                                            <a href="<?= htmlspecialchars($vendor['website']) ?>" target="_blank" class="text-blue-500 hover:text-blue-700">
                                                <?= htmlspecialchars($vendor['website']) ?>
                                            </a>
                                        <?php else: ?>
                                            Not provided
                                        <?php endif; ?>
                                    </p>
                                </div>
                            </div>
                            
                            <!-- Status Information -->
                            <h4 class="text-lg font-semibold dark:text-white mt-6 mb-4 text-primary-600">Status Information</h4>
                            <div class="space-y-4">
                                <div class="flex justify-between items-center">
                                    <label class="text-sm font-medium text-gray-500 dark:text-gray-400">Verification Status</label>
                                    <span class="px-3 py-1 text-xs font-semibold rounded-full <?= $vendor['is_verified'] == '1' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300' ?>">
                                        <?= $vendor['is_verified'] == '1' ? 'Verified' : 'Not Verified' ?>
                                    </span>
                                </div>
                                <div class="flex justify-between items-center">
                                    <label class="text-sm font-medium text-gray-500 dark:text-gray-400">Approval Status</label>
                                    <span class="px-3 py-1 text-xs font-semibold rounded-full 
                                        <?php 
                                        switch($vendor['is_approved']) {
                                            case '1': echo 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200'; break;
                                            case '0': echo 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200'; break;
                                            case '-1': echo 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200'; break;
                                            default: echo 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300';
                                        }
                                        ?>">
                                        <?php 
                                        switch($vendor['is_approved']) {
                                            case '1': echo 'Approved'; break;
                                            case '0': echo 'Pending'; break;
                                            case '-1': echo 'Disapproved'; break;
                                            default: echo 'Unknown';
                                        }
                                        ?>
                                    </span>
                                </div>
                                
                                <?php if ($vendor['approval_date']): ?>
                                <div>
                                    <label class="text-sm font-medium text-gray-500 dark:text-gray-400">Approval Date</label>
                                    <p class="dark:text-white"><?= date('M j, Y g:i A', strtotime($vendor['approval_date'])) ?></p>
                                </div>
                                <?php endif; ?>
                                
                                <?php if ($vendor['approved_by']): 
                                    $stmt = mysqli_prepare($conn, "SELECT full_name FROM admins WHERE id = ?");
                                    mysqli_stmt_bind_param($stmt, "i", $vendor['approved_by']);
                                    mysqli_stmt_execute($stmt);
                                    $result = mysqli_stmt_get_result($stmt);
                                    $admin = mysqli_fetch_assoc($result);
                                ?>
                                    <div>
                                        <label class="text-sm font-medium text-gray-500 dark:text-gray-400">Approved By</label>
                                        <p class="dark:text-white"><?= htmlspecialchars($admin['full_name'] ?? 'Unknown') ?></p>
                                    </div>
                                <?php endif; ?>
                                
                                <div>
                                    <label class="text-sm font-medium text-gray-500 dark:text-gray-400">Registration Date</label>
                                    <p class="dark:text-white"><?= date('M j, Y g:i A', strtotime($vendor['created_at'])) ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Action Buttons -->
                    <div class="mt-8 pt-6 border-t border-gray-200 dark:border-gray-700 flex flex-wrap gap-3">
                        <?php if ($vendor['is_approved'] != '1'): ?>
                            <button onclick="approveVendor(<?= $vendor['id'] ?>)" class="px-4 py-2 bg-green-500 text-white rounded-md hover:bg-green-600 transition-colors">
                                <i class="fas fa-check mr-2"></i>Approve Vendor
                            </button>
                        <?php endif; ?>
                        <?php if ($vendor['is_approved'] != '-1'): ?>
                            <button onclick="disapproveVendor(<?= $vendor['id'] ?>)" class="px-4 py-2 bg-yellow-500 text-white rounded-md hover:bg-yellow-600 transition-colors">
                                <i class="fas fa-ban mr-2"></i>Disapprove Vendor
                            </button>
                        <?php endif; ?>
                        <?php if ($vendor['is_approved'] == '1' || $vendor['is_approved'] == '-1'): ?>
                            <button onclick="resetVendor(<?= $vendor['id'] ?>)" class="px-4 py-2 bg-blue-500 text-white rounded-md hover:bg-blue-600 transition-colors">
                                <i class="fas fa-undo mr-2"></i>Reset to Pending
                            </button>
                        <?php endif; ?>
                        <button onclick="deleteVendor(<?= $vendor['id'] ?>)" class="px-4 py-2 bg-red-500 text-white rounded-md hover:bg-red-600 transition-colors">
                            <i class="fas fa-trash-alt mr-2"></i>Delete Vendor
                        </button>
                        <a href="?" class="px-4 py-2 border border-gray-300 dark:border-gray-600 text-gray-700 dark:text-gray-300 rounded-md hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                            <i class="fas fa-times mr-2"></i>Close
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        <script>
        // Auto-show modal when page loads with view action
        document.addEventListener('DOMContentLoaded', function() {
            const modal = document.getElementById('vendor-view-modal');
            if (modal) {
                modal.style.display = 'flex';
            }
        });
        
        // Close modal when clicking outside
        document.addEventListener('click', function(e) {
            const modal = document.getElementById('vendor-view-modal');
            if (e.target === modal) {
                window.location.href = '?';
            }
        });
        </script>
    <?php else: ?>
        <script>
        showNotification('Vendor not found', 'error');
        </script>
    <?php endif; ?>
<?php endif; ?>

<!-- Notification System -->
<div id="notification" class="fixed top-4 right-4 z-50 hidden">
    <div class="px-6 py-4 rounded-lg shadow-lg">
        <div class="flex items-center">
            <span id="notification-icon" class="mr-3"></span>
            <span id="notification-message" class="text-sm font-medium"></span>
        </div>
    </div>
</div>

<!-- Loading Spinner -->
<div id="loading-spinner" class="fixed inset-0 z-50 flex items-center justify-center bg-black bg-opacity-50 hidden">
    <div class="bg-white dark:bg-gray-800 rounded-lg p-6 flex items-center space-x-3">
        <div class="animate-spin rounded-full h-8 w-8 border-b-2 border-primary-500"></div>
        <span class="text-gray-700 dark:text-gray-300" id="loading-text">Processing...</span>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
// AJAX functions for vendor management
function approveVendor(vendorId) {
    if (confirm('Are you sure you want to approve this vendor? An approval email will be sent.')) {
        showLoading('Approving vendor...');
        
        $.ajax({
            url: 'vendor.php',
            type: 'POST',
            data: {
                ajax_action: 'approve_vendor',
                vendor_id: vendorId
            },
            success: function(response) {
                hideLoading();
                const result = JSON.parse(response);
                showNotification(result.message, result.success ? 'success' : 'error');
                
                if (result.success) {
                    // Reload the page to reflect changes
                    setTimeout(() => {
                        location.reload();
                    }, 1500);
                }
            },
            error: function() {
                hideLoading();
                showNotification('An error occurred while approving the vendor', 'error');
            }
        });
    }
}

function disapproveVendor(vendorId) {
    if (confirm('Are you sure you want to disapprove this vendor?')) {
        showLoading('Disapproving vendor...');
        
        $.ajax({
            url: 'vendor.php',
            type: 'POST',
            data: {
                ajax_action: 'disapprove_vendor',
                vendor_id: vendorId
            },
            success: function(response) {
                hideLoading();
                const result = JSON.parse(response);
                showNotification(result.message, result.success ? 'success' : 'error');
                
                if (result.success) {
                    setTimeout(() => {
                        location.reload();
                    }, 1500);
                }
            },
            error: function() {
                hideLoading();
                showNotification('An error occurred while disapproving the vendor', 'error');
            }
        });
    }
}

function resetVendor(vendorId) {
    if (confirm('Are you sure you want to reset this vendor status to pending?')) {
        showLoading('Resetting vendor status...');
        
        $.ajax({
            url: 'vendor.php',
            type: 'POST',
            data: {
                ajax_action: 'reset_vendor',
                vendor_id: vendorId
            },
            success: function(response) {
                hideLoading();
                const result = JSON.parse(response);
                showNotification(result.message, result.success ? 'success' : 'error');
                
                if (result.success) {
                    setTimeout(() => {
                        location.reload();
                    }, 1500);
                }
            },
            error: function() {
                hideLoading();
                showNotification('An error occurred while resetting vendor status', 'error');
            }
        });
    }
}

function deleteVendor(vendorId) {
    if (confirm('Are you sure you want to delete this vendor? This action cannot be undone.')) {
        showLoading('Deleting vendor...');
        
        // Redirect to the traditional delete method
        window.location.href = '?action=delete&id=' + vendorId + '&<?= http_build_query(array_diff_key($_GET, ['action' => '', 'id' => ''])) ?>';
    }
}

// Notification system
function showNotification(message, type = 'info') {
    const notification = $('#notification');
    const icon = $('#notification-icon');
    const messageEl = $('#notification-message');
    
    // Set styles based on type
    const styles = {
        success: 'bg-green-100 border border-green-400 text-green-700',
        error: 'bg-red-100 border border-red-400 text-red-700',
        warning: 'bg-yellow-100 border border-yellow-400 text-yellow-700',
        info: 'bg-blue-100 border border-blue-400 text-blue-700'
    };
    
    const icons = {
        success: '✅',
        error: '❌',
        warning: '⚠️',
        info: 'ℹ️'
    };
    
    notification.removeClass().addClass(styles[type] + ' fixed top-4 right-4 z-50 px-6 py-4 rounded-lg shadow-lg');
    icon.text(icons[type]);
    messageEl.text(message);
    
    notification.removeClass('hidden').show();
    
    // Auto hide after 5 seconds
    setTimeout(() => {
        notification.fadeOut();
    }, 5000);
}

function showLoading(message = 'Processing...') {
    $('#loading-text').text(message);
    $('#loading-spinner').removeClass('hidden');
}

function hideLoading() {
    $('#loading-spinner').addClass('hidden');
}

// Handle traditional form submissions for non-AJAX actions
$(document).ready(function() {
    // Display any flash messages
    <?php if (isset($_SESSION['message'])): ?>
        showNotification('<?= addslashes($_SESSION['message']) ?>', 'success');
        <?php unset($_SESSION['message']); ?>
    <?php endif; ?>
    
    <?php if (isset($_SESSION['error'])): ?>
        showNotification('<?= addslashes($_SESSION['error']) ?>', 'error');
        <?php unset($_SESSION['error']); ?>
    <?php endif; ?>
});
</script>

<?php
// Handle traditional form submissions (for delete action)
if (isset($_GET['action']) && $_GET['action'] === 'delete' && isset($_GET['id'])) {
    $vendorId = intval($_GET['id']);
    
    $stmt = mysqli_prepare($conn, "DELETE FROM vendors WHERE id = ?");
    mysqli_stmt_bind_param($stmt, "i", $vendorId);
    
    if (mysqli_stmt_execute($stmt)) {
        $_SESSION['message'] = 'Vendor deleted successfully';
    } else {
        $_SESSION['error'] = 'Failed to delete vendor';
    }
    
    // Fix the redirect path - remove action and id from query parameters
    $queryParams = $_GET;
    unset($queryParams['action'], $queryParams['id']);
    $redirectUrl = 'vendor.php';
    if (!empty($queryParams)) {
        $redirectUrl .= '?' . http_build_query($queryParams);
    }
    
    header("Location: " . $redirectUrl);
    exit;
}

ob_end_flush();
include 'include/footer.php'; 
?>