<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    die("Unauthorized");
}

require '../../config/conn.php';

$vendor_id = intval($_GET['vendor_id']);
$selected_date = mysqli_real_escape_string($conn, $_GET['date']);

$query = "SELECT vwt.*, 
          DATE_FORMAT(vwt.created_at, '%h:%i %p') as time,
          DATE_FORMAT(vwt.created_at, '%M %d, %Y') as date
          FROM vendor_wallet_transactions vwt
          WHERE vwt.vendor_id = '$vendor_id'
          AND DATE(vwt.created_at) = '$selected_date'
          AND vwt.status = 'pending'
          ORDER BY vwt.created_at ASC";

$result = mysqli_query($conn, $query);

if (mysqli_num_rows($result) > 0): ?>
    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
        <thead class="bg-gray-50 dark:bg-gray-800">
            <tr>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Time</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Reference</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Amount</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Description</th>
            </tr>
        </thead>
        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
            <?php while ($transaction = mysqli_fetch_assoc($result)): ?>
            <tr>
                <td class="px-4 py-2 text-sm text-gray-900 dark:text-white"><?php echo $transaction['time']; ?></td>
                <td class="px-4 py-2 text-sm text-gray-900 dark:text-white"><?php echo $transaction['reference']; ?></td>
                <td class="px-4 py-2 text-sm text-yellow-600 dark:text-yellow-400">₦<?php echo number_format($transaction['amount'], 2); ?></td>
                <td class="px-4 py-2 text-sm text-gray-900 dark:text-white"><?php echo htmlspecialchars($transaction['description']); ?></td>
            </tr>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
            <?php endwhile; ?>
        </tbody>
    </table>
    <div class="mt-4 p-2 bg-gray-50 dark:bg-gray-700 rounded">
        <p class="text-sm text-gray-600 dark:text-gray-400">
            <i class="fas fa-info-circle mr-1"></i>
            These transactions are pending admin approval. Once approved, the funds will be moved to the vendor's approved balance.
        </p>
    </div>
<?php else: ?>
    <p class="text-gray-500 dark:text-gray-400 text-center py-4">No pending transactions found for this date.</p>
<?php endif; ?>