<?php
require_once '../config/conn.php';
session_start();

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    http_response_code(401);
    echo json_encode([]);
    exit();
}

$admin_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT * FROM admin_bank_accounts WHERE admin_id = ? ORDER BY is_primary DESC");
$stmt->bind_param("i", $admin_id);
$stmt->execute();
$result = $stmt->get_result();

$accounts = [];
while ($row = $result->fetch_assoc()) {
    $accounts[] = $row;
}

header('Content-Type: application/json');
echo json_encode($accounts);
?>