
<?php include 'include/header.php'; ?>

<?php
require_once '../config/conn.php';




$admin_id = $_SESSION['admin_id'];

// Get admin wallet using admin ID as wallet ID
$wallet_stmt = $conn->prepare("
    SELECT id, wallet_id, balance 
    FROM admin_wallets 
    WHERE admin_id = ?
");
$wallet_stmt->bind_param("i", $admin_id);
$wallet_stmt->execute();
$wallet_result = $wallet_stmt->get_result();

if ($wallet_result->num_rows === 0) {
    // Create wallet if doesn't exist using admin ID as wallet ID
    $wallet_id = 'ADM' . str_pad($admin_id, 6, '0', STR_PAD_LEFT);
    $create_stmt = $conn->prepare("
        INSERT INTO admin_wallets (wallet_id, admin_id, balance) 
        VALUES (?, ?, 0.00)
    ");
    $create_stmt->bind_param("si", $wallet_id, $admin_id);
    $create_stmt->execute();
    
    // Re-fetch wallet
    $wallet_stmt->execute();
    $wallet_result = $wallet_stmt->get_result();
}

$wallet = $wallet_result->fetch_assoc();

// Get recent withdrawals
$withdrawals_stmt = $conn->prepare("
    SELECT * FROM admin_withdrawals 
    WHERE admin_id = ? 
    ORDER BY created_at DESC 
    LIMIT 5
");
$withdrawals_stmt->bind_param("i", $admin_id);
$withdrawals_stmt->execute();
$withdrawals_result = $withdrawals_stmt->get_result();
$withdrawals = $withdrawals_result->fetch_all(MYSQLI_ASSOC);
?>

<!-- Main Content -->
<main class="main-content flex-1 p-6 bg-gray-50 dark:bg-gray-900 overflow-y-auto">
    <!-- Page Header -->
    <div class="mb-6">
        <h2 class="text-2xl font-bold text-gray-800 dark:text-white">Admin Wallet</h2>
        <p class="text-gray-600 dark:text-gray-400">Manage your admin wallet</p>
    </div>

    <!-- Wallet Balance Card -->
    <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700 mb-6">
        <div class="flex justify-between items-start mb-6">
            <div>
                <h3 class="text-lg font-semibold dark:text-white mb-2">Wallet Balance</h3>
                <div class="flex items-center mb-4">
                    <p class="text-3xl font-bold text-primary-600" id="balance-amount">
                        ₦<?= number_format($wallet['balance'], 2) ?>
                    </p>
                    <button id="toggle-balance" class="ml-3 text-gray-500 hover:text-primary-500">
                        <svg id="eye-icon" class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                        </svg>
                    </button>
                </div>
                
                <div class="flex items-center">
                    <div class="w-10 h-10 bg-primary-100 dark:bg-primary-900/30 rounded-full flex items-center justify-center mr-3">
                        <i class="fas fa-id-card text-primary-500"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Wallet ID</p>
                        <p class="font-medium dark:text-white">
                            <?= $wallet['wallet_id'] ?>
                            <button onclick="copyWalletId()" class="ml-2 text-gray-500 hover:text-primary-500 text-sm">
                                <i class="fas fa-copy"></i>
                            </button>
                        </p>
                    </div>
                </div>
            </div>
            
            <div class="w-16 h-16 bg-primary-100 dark:bg-primary-900/30 rounded-full flex items-center justify-center">
                <i class="fas fa-wallet text-primary-500 text-2xl"></i>
            </div>
        </div>
        
        <!-- Withdraw Button -->
        <button onclick="openWithdrawModal()" 
            class="w-full bg-primary-500 hover:bg-primary-600 text-white font-medium py-3 rounded-lg transition">
            <i class="fas fa-money-bill-wave mr-2"></i>
            Withdraw Funds
        </button>
    </div>

    <!-- Recent Withdrawals -->
    <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-lg font-semibold dark:text-white">Recent Withdrawals</h3>
            <a href="withdrawal_history.php" class="text-primary-500 hover:text-primary-600 text-sm">
                View All
            </a>
        </div>
        
        <?php if (empty($withdrawals)): ?>
            <div class="text-center py-8 text-gray-500">
                <i class="fas fa-money-bill-wave text-4xl mb-3 text-gray-400"></i>
                <p>No withdrawals yet</p>
            </div>
        <?php else: ?>
            <div class="space-y-3">
                <?php foreach ($withdrawals as $withdrawal): ?>
                    <div class="flex items-center justify-between p-3 border border-gray-100 dark:border-gray-700 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700">
                        <div class="flex items-center">
                            <div class="w-10 h-10 rounded-full flex items-center justify-center mr-3 
                                <?= $withdrawal['status'] === 'completed' ? 'bg-green-100 dark:bg-green-900/30' : 
                                   ($withdrawal['status'] === 'pending' ? 'bg-yellow-100 dark:bg-yellow-900/30' : 
                                   'bg-red-100 dark:bg-red-900/30') ?>">
                                <i class="fas fa-money-bill-wave 
                                    <?= $withdrawal['status'] === 'completed' ? 'text-green-500' : 
                                       ($withdrawal['status'] === 'pending' ? 'text-yellow-500' : 
                                       'text-red-500') ?>"></i>
                            </div>
                            <div>
                                <p class="font-medium dark:text-white">₦<?= number_format($withdrawal['amount'], 2) ?></p>
                                <p class="text-xs text-gray-500">
                                    <?= date('M j, Y', strtotime($withdrawal['created_at'])) ?>
                                </p>
                            </div>
                        </div>
                        <span class="px-2 py-1 rounded text-xs font-medium 
                            <?= $withdrawal['status'] === 'completed' ? 'bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-400' : 
                               ($withdrawal['status'] === 'pending' ? 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-400' : 
                               'bg-red-100 text-red-800 dark:bg-red-900/30 dark:text-red-400') ?>">
                            <?= ucfirst($withdrawal['status']) ?>
                        </span>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</main>

<!-- Withdraw Modal -->
<div id="withdrawModal" class="hidden fixed inset-0 bg-black bg-opacity-50 z-50 flex items-center justify-center">
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-xl w-full max-w-md p-6">
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-lg font-semibold dark:text-white">Withdraw Funds</h3>
            <button onclick="closeWithdrawModal()" class="text-gray-500 hover:text-gray-700">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <form id="withdrawForm" onsubmit="withdrawFunds(event)">
            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium dark:text-gray-300 mb-2">Amount (₦)</label>
                    <input type="number" name="amount" min="100" step="0.01" 
                        class="w-full border border-gray-300 dark:border-gray-600 rounded-lg p-3 dark:bg-gray-700 dark:text-white" 
                        placeholder="Enter amount" 
                        max="<?= $wallet['balance'] ?>"
                        required>
                    <p class="text-xs text-gray-500 mt-1">
                        Available: ₦<?= number_format($wallet['balance'], 2) ?>
                    </p>
                </div>
                
                <div>
                    <label class="block text-sm font-medium dark:text-gray-300 mb-2">Bank Account</label>
                    <select name="bank_account" class="w-full border border-gray-300 dark:border-gray-600 rounded-lg p-3 dark:bg-gray-700 dark:text-white" required>
                        <option value="">Select bank account</option>
                        <!-- Bank accounts will be loaded here -->
                    </select>
                    <a href="add_bank_account.php" class="text-xs text-primary-500 hover:text-primary-600 mt-1 block">
                        + Add new bank account
                    </a>
                </div>
                
                <div>
                    <label class="block text-sm font-medium dark:text-gray-300 mb-2">Withdrawal PIN</label>
                    <input type="password" name="withdrawal_pin" maxlength="4" 
                        class="w-full border border-gray-300 dark:border-gray-600 rounded-lg p-3 dark:bg-gray-700 dark:text-white" 
                        placeholder="Enter 4-digit PIN" required>
                </div>
                
                <div class="flex justify-end space-x-3 mt-6">
                    <button type="button" onclick="closeWithdrawModal()"
                        class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50">
                        Cancel
                    </button>
                    <button type="submit"
                        class="px-4 py-2 bg-primary-500 text-white rounded-lg hover:bg-primary-600">
                        Withdraw
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle balance visibility
    const toggleBtn = document.getElementById('toggle-balance');
    const balanceAmount = document.getElementById('balance-amount');
    let isVisible = true;
    
    toggleBtn.addEventListener('click', function() {
        if (isVisible) {
            balanceAmount.textContent = '₦••••••';
        } else {
            balanceAmount.textContent = '₦<?= number_format($wallet['balance'], 2) ?>';
        }
        isVisible = !isVisible;
    });
});

function copyWalletId() {
    const walletId = '<?= $wallet['wallet_id'] ?>';
    navigator.clipboard.writeText(walletId).then(() => {
        alert('Wallet ID copied to clipboard!');
    });
}

function openWithdrawModal() {
    document.getElementById('withdrawModal').classList.remove('hidden');
    loadBankAccounts();
}

function closeWithdrawModal() {
    document.getElementById('withdrawModal').classList.add('hidden');
}

function loadBankAccounts() {
    fetch('api/get_admin_bank_accounts.php')
        .then(response => response.json())
        .then(data => {
            const select = document.querySelector('select[name="bank_account"]');
            select.innerHTML = '<option value="">Select bank account</option>';
            data.forEach(account => {
                const option = document.createElement('option');
                option.value = account.id;
                option.textContent = `${account.bank_name} - ${account.account_number} (${account.account_name})`;
                select.appendChild(option);
            });
        })
        .catch(error => console.error('Error loading bank accounts:', error));
}

function withdrawFunds(event) {
    event.preventDefault();
    const formData = new FormData(event.target);
    const amount = parseFloat(formData.get('amount'));
    
    if (amount > <?= $wallet['balance'] ?>) {
        alert('Insufficient balance!');
        return;
    }
    
    fetch('api/withdraw_funds.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Withdrawal request submitted successfully!');
            closeWithdrawModal();
            location.reload();
        } else {
            alert('Error: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred. Please try again.');
    });
}
</script>

<?php include 'include/footer.php'; ?>