<?php
session_start();
require '../config/conn.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: admin-login.php");
    exit();
}

$vendor_id = isset($_GET['vendor_id']) ? intval($_GET['vendor_id']) : 0;
$date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');

if (!$vendor_id) {
    header("Location: vendor_approval.php");
    exit();
}

// Get vendor details
$vendor_query = "SELECT v.*, vw.* FROM vendors v 
                 LEFT JOIN vendor_wallets vw ON v.id = vw.vendor_id 
                 WHERE v.id = $vendor_id";
$vendor_result = mysqli_query($conn, $vendor_query);
$vendor = $vendor_result ? mysqli_fetch_assoc($vendor_result) : null;

if (!$vendor) {
    header("Location: vendor_approval.php");
    exit();
}

// Get daily transaction
$daily_query = "SELECT * FROM vendor_daily_transactions 
                WHERE vendor_id = $vendor_id AND transaction_date = '$date'";
$daily_result = mysqli_query($conn, $daily_query);
$daily_transaction = $daily_result ? mysqli_fetch_assoc($daily_result) : null;

// Get vendor wallet transactions for this date
$transactions_query = "
    SELECT * FROM vendor_wallet_transactions 
    WHERE vendor_id = $vendor_id 
    AND DATE(created_at) = '$date'
    AND transaction_type = 'credit'
    ORDER BY created_at DESC
";
$transactions_result = mysqli_query($conn, $transactions_query);
$transactions = [];
$total_transactions = 0;
if ($transactions_result) {
    while ($row = mysqli_fetch_assoc($transactions_result)) {
        $transactions[] = $row;
        $total_transactions++;
    }
}

// Get approval history for this vendor
$approval_query = "
    SELECT * FROM vendor_approval_logs 
    WHERE vendor_id = $vendor_id 
    AND approval_date = '$date'
    ORDER BY created_at DESC
";
$approval_result = mysqli_query($conn, $approval_query);
$approvals = [];
$total_approvals = 0;
if ($approval_result) {
    while ($row = mysqli_fetch_assoc($approval_result)) {
        $approvals[] = $row;
        $total_approvals++;
    }
}

// Get vendor's transaction history
$history_query = "
    SELECT transaction_date, 
           SUM(total_amount) as total,
           SUM(approved_amount) as approved,
           SUM(pending_amount) as pending,
           SUM(vendor_approved) as vendor_approved,
           SUM(admin_approved) as admin_approved,
           status
    FROM vendor_daily_transactions 
    WHERE vendor_id = $vendor_id 
    AND transaction_date < '$date'
    GROUP BY transaction_date 
    ORDER BY transaction_date DESC 
    LIMIT 10
";
$history_result = mysqli_query($conn, $history_query);
$history = [];
if ($history_result) {
    while ($row = mysqli_fetch_assoc($history_result)) {
        $history[] = $row;
    }
}

// Get vendor name field
$name_field = 'business_name';
$vendor_columns_query = "SHOW COLUMNS FROM vendors";
$vendor_columns_result = mysqli_query($conn, $vendor_columns_query);
if ($vendor_columns_result) {
    $vendor_columns = [];
    while ($row = mysqli_fetch_assoc($vendor_columns_result)) {
        $vendor_columns[] = $row['Field'];
    }
    
    if (in_array('business_name', $vendor_columns)) {
        $name_field = 'business_name';
    } elseif (in_array('vendor_name', $vendor_columns)) {
        $name_field = 'vendor_name';
    } elseif (in_array('full_name', $vendor_columns)) {
        $name_field = 'full_name';
    } elseif (in_array('name', $vendor_columns)) {
        $name_field = 'name';
    }
}
?>

<!DOCTYPE html>
<html lang="en" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vendor Transaction Details</title>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        .status-badge {
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 500;
        }
        
        .transaction-card {
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            padding: 16px;
            margin-bottom: 16px;
        }
        
        .dark .transaction-card {
            border-color: #4b5563;
            background-color: #1f2937;
        }
        
        .amount-badge {
            padding: 2px 8px;
            border-radius: 4px;
            font-size: 11px;
            font-weight: 500;
        }
        
        .print-only {
            display: none;
        }
        
        @media print {
            .no-print {
                display: none;
            }
            .print-only {
                display: block;
            }
            body {
                font-size: 12px;
            }
        }
    </style>
</head>
<body class="bg-gray-50 dark:bg-gray-900 text-gray-800 dark:text-gray-200">
    
    <!-- Include Header -->
    <?php include 'include/header.php'; ?>

    <main class="main-content flex-1 p-4 md:p-6 bg-gray-50 dark:bg-gray-900 overflow-y-auto">
        <div class="max-w-7xl mx-auto">
            <!-- Back Button & Header -->
            <div class="mb-6">
                <a href="vendor_approval.php?date=<?= $date ?>" 
                   class="inline-flex items-center text-blue-500 hover:text-blue-600 mb-4 no-print">
                    <i class="fas fa-arrow-left mr-2"></i> Back to Approval Page
                </a>
                
                <div class="flex flex-col md:flex-row md:items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-900 dark:text-white">
                            Transaction Details
                        </h1>
                        <p class="text-gray-600 dark:text-gray-400">
                            <?= htmlspecialchars($vendor[$name_field] ?? 'Vendor') ?> - <?= date('F j, Y', strtotime($date)) ?>
                        </p>
                    </div>
                    
                    <div class="mt-4 md:mt-0 space-x-2 no-print">
                        <a href="vendor_approval.php?vendor_id=<?= $vendor_id ?>&date=<?= $date ?>" 
                           class="inline-flex items-center px-4 py-2 bg-green-500 hover:bg-green-600 text-white rounded-md text-sm md:text-base">
                            <i class="fas fa-check mr-2"></i> Approve Money
                        </a>
                        <button onclick="window.print()" 
                               class="inline-flex items-center px-4 py-2 bg-blue-500 hover:bg-blue-600 text-white rounded-md text-sm md:text-base">
                            <i class="fas fa-print mr-2"></i> Print
                        </button>
                    </div>
                </div>
            </div>

            <!-- Vendor Summary -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-4 border border-gray-100 dark:border-gray-700">
                    <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Today's Total</p>
                    <p class="text-xl md:text-2xl font-bold text-gray-900 dark:text-white">
                        ₦<?= number_format($daily_transaction['total_amount'] ?? 0, 2) ?>
                    </p>
                </div>
                
                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-4 border border-gray-100 dark:border-gray-700">
                    <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Approved Amount</p>
                    <p class="text-xl md:text-2xl font-bold text-green-600 dark:text-green-400">
                        ₦<?= number_format($daily_transaction['approved_amount'] ?? 0, 2) ?>
                    </p>
                </div>
                
                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-4 border border-gray-100 dark:border-gray-700">
                    <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Pending Amount</p>
                    <p class="text-xl md:text-2xl font-bold text-yellow-600 dark:text-yellow-400">
                        ₦<?= number_format($daily_transaction['pending_amount'] ?? 0, 2) ?>
                    </p>
                </div>
                
                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-4 border border-gray-100 dark:border-gray-700">
                    <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Status</p>
                    <?php
                    $status = $daily_transaction['status'] ?? 'pending';
                    $status_class = $status == 'fully_approved' ? 'bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-400' :
                                  ($status == 'partially_approved' ? 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-400' :
                                   'bg-red-100 text-red-800 dark:bg-red-900/30 dark:text-red-400');
                    ?>
                    <span class="status-badge <?= $status_class ?>">
                        <?= ucfirst(str_replace('_', ' ', $status)) ?>
                    </span>
                </div>
            </div>

            <!-- Vendor Information -->
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-4 md:p-6 border border-gray-100 dark:border-gray-700 mb-6">
                <h3 class="text-lg font-semibold dark:text-white mb-4">Vendor Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Vendor Name</p>
                        <p class="font-medium dark:text-white"><?= htmlspecialchars($vendor[$name_field] ?? 'N/A') ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Email</p>
                        <p class="font-medium dark:text-white"><?= htmlspecialchars($vendor['email'] ?? 'N/A') ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Phone</p>
                        <p class="font-medium dark:text-white"><?= htmlspecialchars($vendor['phone'] ?? 'N/A') ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Status</p>
                        <span class="px-2 py-1 rounded-full text-xs font-medium 
                            <?= $vendor['status'] == 'active' ? 'bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-400' : 'bg-red-100 text-red-800 dark:bg-red-900/30 dark:text-red-400' ?>">
                            <?= ucfirst($vendor['status'] ?? 'inactive') ?>
                        </span>
                    </div>
                </div>
            </div>

            <!-- Wallet Information -->
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-4 md:p-6 border border-gray-100 dark:border-gray-700 mb-6">
                <h3 class="text-lg font-semibold dark:text-white mb-4">Wallet Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Approved Balance</p>
                        <p class="text-lg font-bold text-green-600 dark:text-green-400">
                            ₦<?= number_format($vendor['balance'] ?? 0, 2) ?>
                        </p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Pending Balance</p>
                        <p class="text-lg font-bold text-yellow-600 dark:text-yellow-400">
                            ₦<?= number_format($vendor['pending_balance'] ?? 0, 2) ?>
                        </p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Total Collected</p>
                        <p class="text-lg font-bold text-blue-600 dark:text-blue-400">
                            ₦<?= number_format($vendor['total_collected'] ?? 0, 2) ?>
                        </p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Last Updated</p>
                        <p class="font-medium dark:text-white">
                            <?= $vendor['updated_at'] ? date('M j, Y H:i', strtotime($vendor['updated_at'])) : 'Never' ?>
                        </p>
                    </div>
                </div>
            </div>

            <!-- Daily Transaction Summary -->
            <?php if ($daily_transaction): ?>
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-4 md:p-6 border border-gray-100 dark:border-gray-700 mb-6">
                <h3 class="text-lg font-semibold dark:text-white mb-4">Daily Summary - <?= date('F j, Y', strtotime($date)) ?></h3>
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
                    <div class="text-center p-4 bg-gray-50 dark:bg-gray-700 rounded-lg">
                        <p class="text-sm text-gray-500 dark:text-gray-400">Total Amount</p>
                        <p class="text-xl font-bold text-gray-900 dark:text-white">
                            ₦<?= number_format($daily_transaction['total_amount'], 2) ?>
                        </p>
                    </div>
                    <div class="text-center p-4 bg-green-50 dark:bg-green-900/30 rounded-lg">
                        <p class="text-sm text-green-600 dark:text-green-400">Approved</p>
                        <p class="text-xl font-bold text-green-600 dark:text-green-400">
                            ₦<?= number_format($daily_transaction['approved_amount'], 2) ?>
                        </p>
                    </div>
                    <div class="text-center p-4 bg-yellow-50 dark:bg-yellow-900/30 rounded-lg">
                        <p class="text-sm text-yellow-600 dark:text-yellow-400">Pending</p>
                        <p class="text-xl font-bold text-yellow-600 dark:text-yellow-400">
                            ₦<?= number_format($daily_transaction['pending_amount'], 2) ?>
                        </p>
                    </div>
                    <div class="text-center p-4 bg-blue-50 dark:bg-blue-900/30 rounded-lg">
                        <p class="text-sm text-blue-600 dark:text-blue-400">Remaining</p>
                        <p class="text-xl font-bold text-blue-600 dark:text-blue-400">
                            ₦<?= number_format($daily_transaction['remaining_amount'] ?? ($daily_transaction['total_amount'] - $daily_transaction['approved_amount']), 2) ?>
                        </p>
                    </div>
                </div>
                
                <!-- Approval Breakdown -->
                <div class="mt-4 p-4 bg-gray-50 dark:bg-gray-700 rounded-lg">
                    <h4 class="font-medium text-gray-700 dark:text-gray-300 mb-2">Approval Breakdown</h4>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Approved to Vendor</p>
                            <p class="text-lg font-bold text-green-600 dark:text-green-400">
                                ₦<?= number_format($daily_transaction['vendor_approved'] ?? 0, 2) ?>
                            </p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Approved to Admin</p>
                            <p class="text-lg font-bold text-blue-600 dark:text-blue-400">
                                ₦<?= number_format($daily_transaction['admin_approved'] ?? 0, 2) ?>
                            </p>
                        </div>
                    </div>
                </div>
                
                <?php if (!empty($daily_transaction['notes'])): ?>
                <div class="mt-4 p-4 bg-gray-50 dark:bg-gray-700 rounded-lg">
                    <p class="text-sm text-gray-500 dark:text-gray-400 mb-2">Notes</p>
                    <p class="text-gray-700 dark:text-gray-300 whitespace-pre-line"><?= htmlspecialchars($daily_transaction['notes']) ?></p>
                </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <!-- Individual Transactions -->
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-4 md:p-6 border border-gray-100 dark:border-gray-700 mb-6">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-semibold dark:text-white">Individual Transactions</h3>
                    <span class="text-sm text-gray-500 dark:text-gray-400">
                        <?= $total_transactions ?> transactions
                    </span>
                </div>
                
                <?php if (!empty($transactions)): ?>
                    <div class="space-y-4">
                        <?php foreach ($transactions as $transaction): ?>
                            <div class="transaction-card">
                                <div class="flex flex-col md:flex-row md:items-center justify-between">
                                    <div class="mb-2 md:mb-0">
                                        <div class="flex items-center space-x-2">
                                            <span class="text-sm text-gray-500 dark:text-gray-400">
                                                <?= date('H:i:s', strtotime($transaction['created_at'])) ?>
                                            </span>
                                            <span class="amount-badge 
                                                <?= strpos($transaction['reference'], 'VENDOR-APP') !== false ? 'bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-400' : 'bg-blue-100 text-blue-800 dark:bg-blue-900/30 dark:text-blue-400' ?>">
                                                <?= strpos($transaction['reference'], 'VENDOR-APP') !== false ? 'Vendor' : 'Admin' ?>
                                            </span>
                                        </div>
                                        <div class="mt-1">
                                            <p class="text-sm font-medium text-gray-900 dark:text-white">
                                                <?= htmlspecialchars($transaction['description'] ?? 'Transaction') ?>
                                            </p>
                                            <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                                Ref: <?= $transaction['reference'] ?>
                                            </p>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <p class="text-lg font-bold 
                                            <?= $transaction['transaction_type'] == 'credit' ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' ?>">
                                            <?= $transaction['transaction_type'] == 'credit' ? '+' : '-' ?>
                                            ₦<?= number_format($transaction['amount'], 2) ?>
                                        </p>
                                        <div class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                                            <div>Balance: ₦<?= number_format($transaction['balance_after'], 2) ?></div>
                                            <div>Status: 
                                                <span class="px-1 py-0.5 rounded text-xs 
                                                    <?= $transaction['status'] == 'completed' ? 'bg-green-100 text-green-800' :
                                                       ($transaction['status'] == 'pending' ? 'bg-yellow-100 text-yellow-800' :
                                                        'bg-red-100 text-red-800') ?>">
                                                    <?= ucfirst($transaction['status']) ?>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php if (!empty($transaction['notes'])): ?>
                                <div class="mt-2 pt-2 border-t border-gray-100 dark:border-gray-700">
                                    <p class="text-xs text-gray-500 dark:text-gray-400">Note: <?= htmlspecialchars($transaction['notes']) ?></p>
                                </div>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <div class="text-center py-8 text-gray-500 dark:text-gray-400">
                        <i class="fas fa-exchange-alt text-4xl mb-2"></i>
                        <p>No transactions found for this date</p>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Approval History -->
            <?php if (!empty($approvals)): ?>
                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-4 md:p-6 border border-gray-100 dark:border-gray-700 mb-6">
                    <h3 class="text-lg font-semibold dark:text-white mb-4">Approval History</h3>
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                            <thead class="bg-gray-50 dark:bg-gray-800">
                                <tr>
                                    <th class="px-3 md:px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Approved At</th>
                                    <th class="px-3 md:px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Vendor Amount</th>
                                    <th class="px-3 md:px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Admin Amount</th>
                                    <th class="px-3 md:px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Daily Total</th>
                                    <th class="px-3 md:px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Remaining</th>
                                    <th class="px-3 md:px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Notes</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                                <?php foreach ($approvals as $approval): ?>
                                    <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                                        <td class="px-3 md:px-4 py-2 text-sm text-gray-700 dark:text-gray-300">
                                            <?= date('H:i:s', strtotime($approval['created_at'])) ?>
                                        </td>
                                        <td class="px-3 md:px-4 py-2 text-sm font-medium text-green-600 dark:text-green-400">
                                            ₦<?= number_format($approval['vendor_approved_amount'], 2) ?>
                                        </td>
                                        <td class="px-3 md:px-4 py-2 text-sm font-medium text-blue-600 dark:text-blue-400">
                                            ₦<?= number_format($approval['admin_approved_amount'], 2) ?>
                                        </td>
                                        <td class="px-3 md:px-4 py-2 text-sm text-gray-700 dark:text-gray-300">
                                            ₦<?= number_format($approval['daily_total'], 2) ?>
                                        </td>
                                        <td class="px-3 md:px-4 py-2 text-sm text-gray-700 dark:text-gray-300">
                                            ₦<?= number_format($approval['remaining_amount'], 2) ?>
                                        </td>
                                        <td class="px-3 md:px-4 py-2 text-sm text-gray-700 dark:text-gray-300">
                                            <?= htmlspecialchars($approval['notes'] ?? '') ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Previous Days -->
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-4 md:p-6 border border-gray-100 dark:border-gray-700">
                <h3 class="text-lg font-semibold dark:text-white mb-4">Previous Days</h3>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                        <thead class="bg-gray-50 dark:bg-gray-800">
                            <tr>
                                <th class="px-3 md:px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Date</th>
                                <th class="px-3 md:px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Total</th>
                                <th class="px-3 md:px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Approved</th>
                                <th class="px-3 md:px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Pending</th>
                                <th class="px-3 md:px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Vendor</th>
                                <th class="px-3 md:px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Admin</th>
                                <th class="px-3 md:px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Status</th>
                                <th class="px-3 md:px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400">Action</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                            <?php if (!empty($history)): ?>
                                <?php foreach ($history as $day): ?>
                                    <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                                        <td class="px-3 md:px-4 py-2 text-sm text-gray-700 dark:text-gray-300">
                                            <?= date('M j, Y', strtotime($day['transaction_date'])) ?>
                                        </td>
                                        <td class="px-3 md:px-4 py-2 text-sm font-medium text-gray-900 dark:text-white">
                                            ₦<?= number_format($day['total'], 2) ?>
                                        </td>
                                        <td class="px-3 md:px-4 py-2 text-sm text-green-600 dark:text-green-400">
                                            ₦<?= number_format($day['approved'], 2) ?>
                                        </td>
                                        <td class="px-3 md:px-4 py-2 text-sm text-yellow-600 dark:text-yellow-400">
                                            ₦<?= number_format($day['pending'], 2) ?>
                                        </td>
                                        <td class="px-3 md:px-4 py-2 text-sm text-green-600 dark:text-green-400">
                                            ₦<?= number_format($day['vendor_approved'], 2) ?>
                                        </td>
                                        <td class="px-3 md:px-4 py-2 text-sm text-blue-600 dark:text-blue-400">
                                            ₦<?= number_format($day['admin_approved'], 2) ?>
                                        </td>
                                        <td class="px-3 md:px-4 py-2">
                                            <?php
                                            $status_class = $day['status'] == 'fully_approved' ? 'bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-400' :
                                                          ($day['status'] == 'partially_approved' ? 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-400' :
                                                           'bg-red-100 text-red-800 dark:bg-red-900/30 dark:text-red-400');
                                            ?>
                                            <span class="px-2 py-1 rounded-full text-xs font-medium <?= $status_class ?>">
                                                <?= ucfirst(str_replace('_', ' ', $day['status'])) ?>
                                            </span>
                                        </td>
                                        <td class="px-3 md:px-4 py-2">
                                            <a href="?vendor_id=<?= $vendor_id ?>&date=<?= $day['transaction_date'] ?>" 
                                               class="text-blue-500 hover:text-blue-600 text-sm">
                                                View Details
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="8" class="px-4 py-8 text-center text-gray-500 dark:text-gray-400">
                                        No previous transaction history
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            
            <!-- Print Header -->
            <div class="print-only">
                <div class="text-center mb-8">
                    <h1 class="text-2xl font-bold">Transaction Report</h1>
                    <p class="text-gray-600"><?= htmlspecialchars($vendor[$name_field] ?? 'Vendor') ?> - <?= date('F j, Y', strtotime($date)) ?></p>
                    <p class="text-sm text-gray-500">Generated on <?= date('F j, Y H:i:s') ?></p>
                </div>
            </div>
        </div>
    </main>

    <script>
    // Print function
    function printDetails() {
        window.print();
    }
    
    // Initialize tooltips if needed
    document.addEventListener('DOMContentLoaded', function() {
        // Add any additional initialization here
    });
    </script>

</body>
</html>