<?php
// vendor-wallet-summary.php
session_start();
require '../config/conn.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: admin-login.php");
    exit();
}

$date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');

// Get vendor wallets with statistics
$wallets_query = "
    SELECT 
        v.id,
        v.business_name,
        v.email,
        vw.balance,
        vw.pending_balance,
        vw.total_collected,
        vw.created_at as wallet_created,
        vw.updated_at as last_updated,
        COALESCE(vdt.total_amount, 0) as today_total,
        COALESCE(vdt.approved_amount, 0) as today_approved,
        COALESCE(vdt.pending_amount, 0) as today_pending
    FROM vendors v
    LEFT JOIN vendor_wallets vw ON v.id = vw.vendor_id
    LEFT JOIN vendor_daily_transactions vdt ON v.id = vdt.vendor_id AND vdt.transaction_date = '$date'
    ORDER BY vw.balance DESC, v.business_name
";

$wallets_result = mysqli_query($conn, $wallets_query);

// Calculate totals
$total_balance = 0;
$total_pending = 0;
$total_collected = 0;
$total_today = 0;

while ($wallet = mysqli_fetch_assoc($wallets_result)) {
    $total_balance += $wallet['balance'];
    $total_pending += $wallet['pending_balance'];
    $total_collected += $wallet['total_collected'];
    $total_today += $wallet['today_total'];
}

mysqli_data_seek($wallets_result, 0); // Reset pointer

include 'include/header.php';
?>

<main class="main-content flex-1 p-6 bg-gray-50 dark:bg-gray-900 overflow-y-auto">
    <div class="max-w-7xl mx-auto">
        <!-- Header -->
        <div class="mb-6">
            <div class="flex flex-col md:flex-row md:items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-gray-900 dark:text-white">Vendor Wallet Summary</h1>
                    <p class="text-gray-600 dark:text-gray-400">All vendor wallet balances and statistics</p>
                </div>
                
                <div class="mt-4 md:mt-0">
                    <input type="date" id="datePicker" value="<?= $date ?>" 
                           class="px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md focus:outline-none focus:ring-2 focus:ring-primary-500 dark:bg-gray-700 dark:text-white">
                </div>
            </div>
        </div>

        <!-- Statistics -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
                <div class="flex items-center">
                    <div class="w-12 h-12 rounded-full bg-green-50 dark:bg-green-900/30 flex items-center justify-center mr-4">
                        <i class="fas fa-wallet text-green-500 dark:text-green-400 text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Total Approved</p>
                        <p class="text-2xl font-bold text-green-600 dark:text-green-400">
                            ₦<?= number_format($total_balance, 2) ?>
                        </p>
                    </div>
                </div>
            </div>
            
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
                <div class="flex items-center">
                    <div class="w-12 h-12 rounded-full bg-yellow-50 dark:bg-yellow-900/30 flex items-center justify-center mr-4">
                        <i class="fas fa-clock text-yellow-500 dark:text-yellow-400 text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Total Pending</p>
                        <p class="text-2xl font-bold text-yellow-600 dark:text-yellow-400">
                            ₦<?= number_format($total_pending, 2) ?>
                        </p>
                    </div>
                </div>
            </div>
            
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
                <div class="flex items-center">
                    <div class="w-12 h-12 rounded-full bg-blue-50 dark:bg-blue-900/30 flex items-center justify-center mr-4">
                        <i class="fas fa-money-bill-wave text-blue-500 dark:text-blue-400 text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Total Collected</p>
                        <p class="text-2xl font-bold text-blue-600 dark:text-blue-400">
                            ₦<?= number_format($total_collected, 2) ?>
                        </p>
                    </div>
                </div>
            </div>
            
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
                <div class="flex items-center">
                    <div class="w-12 h-12 rounded-full bg-purple-50 dark:bg-purple-900/30 flex items-center justify-center mr-4">
                        <i class="fas fa-calendar-day text-purple-500 dark:text-purple-400 text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Today's Total</p>
                        <p class="text-2xl font-bold text-purple-600 dark:text-purple-400">
                            ₦<?= number_format($total_today, 2) ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Wallets Table -->
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm border border-gray-100 dark:border-gray-700 overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-100 dark:border-gray-700 bg-gray-50 dark:bg-gray-900">
                <div class="flex items-center justify-between">
                    <h3 class="text-lg font-semibold dark:text-white">Vendor Wallets</h3>
                    <span class="text-sm text-gray-500 dark:text-gray-400">
                        Showing <?= mysqli_num_rows($wallets_result) ?> vendors
                    </span>
                </div>
            </div>
            
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                    <thead class="bg-gray-50 dark:bg-gray-800">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Vendor</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Approved Balance</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Pending Balance</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Total Collected</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Today's Activity</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Last Updated</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                        <?php if (mysqli_num_rows($wallets_result) > 0): ?>
                            <?php while ($wallet = mysqli_fetch_assoc($wallets_result)): ?>
                                <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="flex items-center">
                                            <div class="w-10 h-10 rounded-full bg-gray-200 dark:bg-gray-700 flex items-center justify-center mr-3">
                                                <i class="fas fa-store text-gray-400 dark:text-gray-500"></i>
                                            </div>
                                            <div>
                                                <div class="text-sm font-medium text-gray-900 dark:text-white">
                                                    <?= htmlspecialchars($wallet['business_name']) ?>
                                                </div>
                                                <div class="text-sm text-gray-500 dark:text-gray-400">
                                                    <?= htmlspecialchars($wallet['email']) ?>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                    
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-lg font-bold text-green-600 dark:text-green-400">
                                            ₦<?= number_format($wallet['balance'], 2) ?>
                                        </div>
                                    </td>
                                    
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-lg font-bold text-yellow-600 dark:text-yellow-400">
                                            ₦<?= number_format($wallet['pending_balance'], 2) ?>
                                        </div>
                                    </td>
                                    
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-lg font-bold text-blue-600 dark:text-blue-400">
                                            ₦<?= number_format($wallet['total_collected'], 2) ?>
                                        </div>
                                    </td>
                                    
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm">
                                            <div class="flex items-center space-x-2">
                                                <span class="text-gray-500 dark:text-gray-400">Total:</span>
                                                <span class="font-medium text-gray-900 dark:text-white">
                                                    ₦<?= number_format($wallet['today_total'], 2) ?>
                                                </span>
                                            </div>
                                            <div class="flex items-center space-x-2 mt-1">
                                                <span class="text-gray-500 dark:text-gray-400">Approved:</span>
                                                <span class="font-medium text-green-600 dark:text-green-400">
                                                    ₦<?= number_format($wallet['today_approved'], 2) ?>
                                                </span>
                                            </div>
                                            <div class="flex items-center space-x-2 mt-1">
                                                <span class="text-gray-500 dark:text-gray-400">Pending:</span>
                                                <span class="font-medium text-yellow-600 dark:text-yellow-400">
                                                    ₦<?= number_format($wallet['today_pending'], 2) ?>
                                                </span>
                                            </div>
                                        </div>
                                    </td>
                                    
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm text-gray-500 dark:text-gray-400">
                                            <?= $wallet['last_updated'] ? date('M j, H:i', strtotime($wallet['last_updated'])) : 'Never' ?>
                                        </div>
                                    </td>
                                    
                                    <td class="px-6 py-4 whitespace-nowrap space-x-2">
                                        <a href="vendor-transaction-details.php?vendor_id=<?= $wallet['id'] ?>&date=<?= $date ?>" 
                                           class="inline-flex items-center px-3 py-1 bg-blue-500 hover:bg-blue-600 text-white rounded text-sm">
                                            <i class="fas fa-eye mr-1"></i> View
                                        </a>
                                        <a href="vendor-transactions.php?vendor_id=<?= $wallet['id'] ?>" 
                                           class="inline-flex items-center px-3 py-1 bg-green-500 hover:bg-green-600 text-white rounded text-sm">
                                            <i class="fas fa-history mr-1"></i> History
                                        </a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="px-6 py-8 text-center text-gray-500 dark:text-gray-400">
                                    No vendor wallets found
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        
        <!-- Export Options -->
        <div class="mt-6 flex justify-end space-x-3">
            <a href="export-wallets.php?date=<?= $date ?>&format=csv" 
               class="px-4 py-2 bg-gray-200 dark:bg-gray-700 hover:bg-gray-300 dark:hover:bg-gray-600 text-gray-800 dark:text-white rounded-md">
                <i class="fas fa-file-csv mr-2"></i> Export CSV
            </a>
            <a href="export-wallets.php?date=<?= $date ?>&format=pdf" 
               class="px-4 py-2 bg-red-500 hover:bg-red-600 text-white rounded-md">
                <i class="fas fa-file-pdf mr-2"></i> Export PDF
            </a>
            <button onclick="window.print()" 
                    class="px-4 py-2 bg-blue-500 hover:bg-blue-600 text-white rounded-md">
                <i class="fas fa-print mr-2"></i> Print
            </button>
        </div>
    </div>
</main>

<script>
// Date picker functionality
document.getElementById('datePicker').addEventListener('change', function() {
    const date = this.value;
    window.location.href = `vendor-wallet-summary.php?date=${date}`;
});
</script>

<?php include 'include/footer.php'; ?>