<?php
// api/sse-vendor-updates.php
header('Content-Type: text/event-stream');
header('Cache-Control: no-cache');
header('X-Accel-Buffering: no'); // Disable Nginx buffering
header('Connection: keep-alive');
header('Access-Control-Allow-Origin: *');

session_start();
include '../config/conn.php';

ignore_user_abort(true);
set_time_limit(0);

// Get vendor ID from session or query parameter
$vendor_id = $_SESSION['vendor_id'] ?? $_GET['vendor_id'] ?? null;

if (!$vendor_id) {
    echo "data: " . json_encode(['error' => 'Vendor ID required']) . "\n\n";
    ob_flush();
    flush();
    exit();
}

// Track last transaction ID for this session
$last_transaction_id = 0;

// Send initial ping
echo "event: connected\n";
echo "data: " . json_encode(['status' => 'connected', 'vendor_id' => $vendor_id, 'time' => date('H:i:s')]) . "\n\n";
ob_flush();
flush();

while (true) {
    // Check if client is still connected
    if (connection_aborted()) {
        break;
    }
    
    // Get latest wallet data
    $wallet_query = "SELECT * FROM vendor_wallets WHERE vendor_id = '$vendor_id'";
    $wallet_result = mysqli_query($conn, $wallet_query);
    $wallet = mysqli_fetch_assoc($wallet_result);
    
    if (!$wallet) {
        $data = ['error' => 'Wallet not found'];
        echo "data: " . json_encode($data) . "\n\n";
        ob_flush();
        flush();
        sleep(5);
        continue;
    }
    
    // Get new transactions since last check
    $trans_query = "SELECT * FROM vendor_wallet_transactions 
                    WHERE vendor_id = '$vendor_id' 
                    AND id > $last_transaction_id
                    AND created_at >= DATE_SUB(NOW(), INTERVAL 1 HOUR)
                    ORDER BY id ASC";
    
    $trans_result = mysqli_query($conn, $trans_query);
    $new_transactions = [];
    
    while ($row = mysqli_fetch_assoc($trans_result)) {
        $new_transactions[] = [
            'id' => $row['id'],
            'amount' => $row['amount'],
            'description' => $row['description'],
            'reference' => $row['reference'],
            'status' => $row['status'],
            'type' => $row['transaction_type'],
            'created_at' => $row['created_at']
        ];
        
        // Update last transaction ID
        if ($row['id'] > $last_transaction_id) {
            $last_transaction_id = $row['id'];
        }
    }
    
    // Prepare data to send
    $data = [
        'vendor_id' => $vendor_id,
        'balances' => [
            'pending' => floatval($wallet['pending_balance'] ?? 0),
            'approved' => floatval($wallet['balance'] ?? 0)
        ],
        'new_transactions' => $new_transactions,
        'total_transactions' => count($new_transactions),
        'timestamp' => time(),
        'server_time' => date('H:i:s')
    ];
    
    // Send update
    echo "data: " . json_encode($data) . "\n\n";
    ob_flush();
    flush();
    
    // Sleep for 2 seconds before next check
    sleep(2);
}

// Clean up
mysqli_close($conn);
?>