<?php
// paystack_callback.php
session_start();

// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include your database connection
include 'conn/conn.php';

// Check if reference is provided
if (!isset($_GET['reference']) && !isset($_GET['trxref'])) {
    die('No payment reference supplied');
}

// Get reference from either parameter (Paystack uses both)
$reference = isset($_GET['reference']) ? $_GET['reference'] : $_GET['trxref'];

// Clean the reference
$reference = trim($reference);

// Log the callback for debugging
error_log("Paystack callback received. Reference: $reference");

// Verify payment with Paystack
$paystack_secret_key = 'sk_test_e961ecf6ab503d4b5d63853a2dfc0c9ec6ac78e6'; // Your Paystack secret key - SAME AS IN paystack_payment.php

$url = "https://api.paystack.co/transaction/verify/" . rawurlencode($reference);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Authorization: Bearer $paystack_secret_key",
    "Cache-Control: no-cache",
]);

// For local testing, you might need to disable SSL verification
// Remove this in production
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($response === false) {
    error_log("cURL Error while verifying Paystack payment");
    header('Location: payment_error.php?error=verification_failed');
    exit;
}

$result = json_decode($response, true);

// Log the full response for debugging
error_log("Paystack verification response: " . print_r($result, true));

if (!$result['status']) {
    // Paystack API call failed
    $error_message = isset($result['message']) ? $result['message'] : 'Unknown Paystack error';
    error_log("Paystack verification failed: $error_message");
    header('Location: payment_error.php?error=' . urlencode($error_message));
    exit;
}

// Check if transaction was successful
if ($result['data']['status'] == 'success') {
    // Payment was successful
    
    $transaction_data = $result['data'];
    $order_number = $transaction_data['reference'];
    $amount_paid = $transaction_data['amount'] / 100; // Convert from kobo to main unit
    $payment_reference = $transaction_data['reference'];
    $transaction_id = $transaction_data['id'];
    
    // Get metadata
    $metadata = isset($transaction_data['metadata']) ? $transaction_data['metadata'] : [];
    $user_id = isset($metadata['user_id']) ? $metadata['user_id'] : 0;
    
    // Log successful transaction
    error_log("Paystack payment successful for order: $order_number, Amount: $amount_paid");
    
    // Start database transaction
    mysqli_begin_transaction($conn);
    
    try {
        // 1. Update the order in database
        $update_sql = "UPDATE orders SET 
            payment_status = 'paid',
            payment_reference = '$payment_reference',
            paid_amount = '$amount_paid',
            status = 'processing',  // Change from 'pending' to 'processing'
            updated_at = NOW()
            WHERE order_number = '$order_number'";
        
        if (!mysqli_query($conn, $update_sql)) {
            throw new Exception("Failed to update order: " . mysqli_error($conn));
        }
        
        // Check if any rows were affected
        if (mysqli_affected_rows($conn) == 0) {
            // Try to find order by checking if it exists
            $check_sql = "SELECT id FROM orders WHERE order_number = '$order_number'";
            $check_result = mysqli_query($conn, $check_sql);
            
            if (mysqli_num_rows($check_result) == 0) {
                throw new Exception("Order not found in database: $order_number");
            }
            
            // Order exists but update didn't affect rows (maybe already updated)
            error_log("Order $order_number already updated or no changes needed");
        }
        
        // 2. Clear cart from session if user is logged in
        if (isset($_SESSION['user_id'])) {
            // If you store cart in database
            $clear_cart_sql = "DELETE FROM cart WHERE user_id = " . $_SESSION['user_id'];
            mysqli_query($conn, $clear_cart_sql);
            
            // If you store cart in session
            if (isset($_SESSION['cart'])) {
                unset($_SESSION['cart']);
            }
        }
        
        // 3. Clear pending order from session
        if (isset($_SESSION['pending_order'])) {
            // Store order data before clearing (for success page)
            $order_data = $_SESSION['pending_order'];
            unset($_SESSION['pending_order']);
            
            // Set session variables for success page
            $_SESSION['last_order_number'] = $order_number;
            $_SESSION['last_order_amount'] = $amount_paid;
            $_SESSION['last_payment_method'] = 'paystack';
            $_SESSION['last_payment_status'] = 'paid';
            $_SESSION['last_transaction_id'] = $transaction_id;
        }
        
        // 4. Send email notification (optional)
        // You can implement email sending here
        
        // 5. Commit transaction
        mysqli_commit($conn);
        
        // 6. Redirect to success page
        header('Location: order_success.php?order=' . urlencode($order_number) . '&payment=success');
        exit;
        
    } catch (Exception $e) {
        // Rollback transaction on error
        mysqli_rollback($conn);
        
        error_log("Database error during payment processing: " . $e->getMessage());
        
        // Still redirect to success page but with warning flag
        header('Location: order_success.php?order=' . urlencode($order_number) . '&payment=success&warning=database_error');
        exit;
    }
    
} else {
    // Payment failed or was abandoned
    $transaction_data = $result['data'];
    $order_number = $transaction_data['reference'];
    $failure_reason = isset($transaction_data['gateway_response']) ? $transaction_data['gateway_response'] : 'Payment failed';
    
    error_log("Paystack payment failed for order: $order_number, Reason: $failure_reason");
    
    // Update order status to failed
    $update_sql = "UPDATE orders SET 
        payment_status = 'failed',
        status = 'pending',
        updated_at = NOW()
        WHERE order_number = '$order_number'";
    
    mysqli_query($conn, $update_sql);
    
    // Store error in session for error page
    $_SESSION['payment_error'] = "Payment failed: $failure_reason";
    $_SESSION['failed_order_number'] = $order_number;
    
    // Redirect to payment failed page
    header('Location: payment_failed.php?order=' . urlencode($order_number) . '&reason=' . urlencode($failure_reason));
    exit;
}
?>