// Toastr notification setup - must be at the beginning
toastr.options = {
  "closeButton": true,
  "newestOnTop": true,
  "progressBar": true,
  "positionClass": "toast-top-right",
  "preventDuplicates": true,
  "showDuration": "300",
  "hideDuration": "1000",
  "timeOut": "5000",
  "extendedTimeOut": "1000",
  "showEasing": "swing",
  "hideEasing": "linear",
  "showMethod": "fadeIn",
  "hideMethod": "fadeOut"
};

document.addEventListener('DOMContentLoaded', function() {
  const form = document.getElementById('registrationForm');
  const passwordInput = document.getElementById('password');
  const confirmPasswordInput = document.getElementById('confirm-password');
  const passwordMatch = document.getElementById('password-match');
  const strengthBar = document.getElementById('password-strength-bar');
  const strengthText = document.getElementById('strength-text');
  
  // Password strength indicator
  passwordInput.addEventListener('input', function() {
    const password = this.value;
    let strength = 0;
    
    if (password.length >= 8) strength += 1;
    if (password.length >= 12) strength += 1;
    if (/[A-Z]/.test(password)) strength += 1;
    if (/[a-z]/.test(password)) strength += 1;
    if (/[0-9]/.test(password)) strength += 1;
    if (/[^A-Za-z0-9]/.test(password)) strength += 1;
    
    let width = 0;
    let color = '';
    let text = 'Very Weak';
    
    if (strength <= 2) {
      width = 25;
      color = 'bg-red-500';
    } else if (strength <= 4) {
      width = 50;
      color = 'bg-yellow-500';
      text = 'Medium';
    } else if (strength <= 6) {
      width = 75;
      color = 'bg-blue-500';
      text = 'Strong';
    } else {
      width = 100;
      color = 'bg-green-500';
      text = 'Very Strong';
    }
    
    strengthBar.style.width = `${width}%`;
    strengthBar.className = `password-strength-bar ${color}`;
    strengthText.textContent = text;
  });
  
  // Password match checker
  confirmPasswordInput.addEventListener('input', function() {
    if (this.value !== passwordInput.value) {
      passwordMatch.textContent = 'Passwords do not match';
      passwordMatch.className = 'mt-1 text-xs text-red-500';
      passwordMatch.classList.remove('hidden');
    } else {
      passwordMatch.textContent = 'Passwords match';
      passwordMatch.className = 'mt-1 text-xs text-green-500';
      passwordMatch.classList.remove('hidden');
    }
  });
  
  // Form submission with AJAX
 // ... (keep your existing toastr setup and DOMContentLoaded code)

form.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    // Clear previous errors
    document.querySelectorAll('.text-red-500').forEach(el => el.remove());
    
    const submitBtn = form.querySelector('button[type="submit"]');
    const originalBtnText = submitBtn.innerHTML;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Processing...';
    submitBtn.disabled = true;
    
    try {
        const formData = {
            username: document.getElementById('username').value,
            email: document.getElementById('email').value,
            password: passwordInput.value,
            confirm_password: confirmPasswordInput.value,
            terms: document.getElementById('terms').checked
        };
        
        const response = await fetch('registrationForm.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(formData)
        });
        
        const data = await response.json();
        
        if (!response.ok) {
            throw new Error(data.message || 'Registration failed');
        }
        
        if (data.success) {
            toastr.success(data.message);
            
            if (data.jwt) {
                localStorage.setItem('auth_token', data.jwt);
                setTimeout(() => {
                    window.location.href = 'verify-pending.html';
                }, 1500);
            }
        } else {
            if (data.errors) {
                for (const field in data.errors) {
                    const input = document.getElementById(field);
                    const errorDiv = document.createElement('div');
                    errorDiv.className = 'text-red-500 text-xs mt-1';
                    errorDiv.textContent = data.errors[field];
                    input.parentNode.insertBefore(errorDiv, input.nextSibling);
                }
            }
            toastr.error(data.message || 'Registration failed');
        }
    } catch (error) {
        console.error('Error:', error);
        toastr.error(error.message || 'An error occurred. Please try again.');
    } finally {
        submitBtn.innerHTML = originalBtnText;
        submitBtn.disabled = false;
    }
});

// ... (keep the rest of your existing code)
  // Dark mode toggle
  const themeToggle = document.getElementById('theme-toggle');
  const themeIconLight = document.getElementById('theme-icon-light');
  const themeIconDark = document.getElementById('theme-icon-dark');
  
  themeToggle.addEventListener('click', function() {
    document.documentElement.classList.toggle('dark');
    localStorage.setItem('darkMode', document.documentElement.classList.contains('dark'));
    themeIconLight.classList.toggle('hidden');
    themeIconDark.classList.toggle('hidden');
  });
  
  if (localStorage.getItem('darkMode') === 'true') {
    document.documentElement.classList.add('dark');
    themeIconLight.classList.add('hidden');
    themeIconDark.classList.remove('hidden');
  }
});

function togglePassword(fieldId) {
  const field = document.getElementById(fieldId);
  const toggle = field.nextElementSibling.querySelector('i');
  
  if (field.type === 'password') {
    field.type = 'text';
    toggle.classList.remove('fa-eye');
    toggle.classList.add('fa-eye-slash');
  } else {
    field.type = 'password';
    toggle.classList.remove('fa-eye-slash');
    toggle.classList.add('fa-eye');
  }
}