<?php
require_once '../../config/conn.php';
session_start();
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit();
}

$student_id = $_SESSION['user_id'];
$account_id = $_POST['account_id'] ?? '';

if (empty($account_id)) {
    echo json_encode(['success' => false, 'message' => 'Account ID is required']);
    exit();
}

try {
    $stmt = $conn->prepare("DELETE FROM student_bank_accounts WHERE id = ? AND student_id = ?");
    $stmt->bind_param("ii", $account_id, $student_id);
    
    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Bank account deleted successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to delete bank account']);
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}
?>