<?php
require_once '../../config/conn.php';
header('Content-Type: application/json');

// Check if Paystack is configured
$paystack_secret_key = getenv('PAYSTACK_SECRET_KEY') ?: (function() {
    if (file_exists('../../config/paystack.php')) {
        include '../../config/paystack.php';
        return PAYSTACK_SECRET_KEY ?? '';
    }
    return '';
})();

if (empty($paystack_secret_key)) {
    echo json_encode([
        'success' => false,
        'message' => 'Paystack not configured'
    ]);
    exit();
}

// Fetch banks from Paystack API
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'https://api.paystack.co/bank');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $paystack_secret_key
]);

$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true);

if ($data['status'] && isset($data['data'])) {
    $banks = [];
    foreach ($data['data'] as $bank) {
        $banks[] = [
            'name' => $bank['name'],
            'code' => $bank['code'],
            'slug' => $bank['slug']
        ];
    }
    
    echo json_encode([
        'success' => true,
        'banks' => $banks
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Failed to fetch banks from Paystack'
    ]);
}
?>