<?php
require_once '../../config/conn.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

$account_number = $_POST['account_number'] ?? '';
$bank_code = $_POST['bank_code'] ?? '';

if (empty($account_number) || empty($bank_code)) {
    echo json_encode(['success' => false, 'message' => 'Account number and bank code are required']);
    exit();
}

// Check if Paystack is configured
$paystack_secret_key = getenv('PAYSTACK_SECRET_KEY') ?: (function() {
    if (file_exists('../../config/paystack.php')) {
        include '../../config/paystack.php';
        return PAYSTACK_SECRET_KEY ?? '';
    }
    return '';
})();

if (empty($paystack_secret_key)) {
    echo json_encode([
        'success' => false,
        'message' => 'Paystack verification not available'
    ]);
    exit();
}

// Verify account with Paystack
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'https://api.paystack.co/bank/resolve?account_number=' . urlencode($account_number) . '&bank_code=' . urlencode($bank_code));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $paystack_secret_key
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$data = json_decode($response, true);

if ($data['status'] && isset($data['data']['account_name'])) {
    echo json_encode([
        'success' => true,
        'account_name' => $data['data']['account_name'],
        'account_number' => $data['data']['account_number'],
        'bank_id' => $data['data']['bank_id']
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => $data['message'] ?? 'Failed to verify account. Please check the details.'
    ]);
}
?>