<?php
session_start();
require_once '../config/conn.php';

header('Content-Type: application/json');

$response = ['success' => false, 'message' => '', 'errors' => []];

try {
    if (!isset($_SESSION['user_id'])) {
        throw new Exception('Session expired. Please login again.');
    }

    $student_id = $_SESSION['user_id'];
    $bank_code = $_POST['bank_code'] ?? '';
    $account_number = $_POST['account_number'] ?? '';
    $account_name = $_POST['account_name'] ?? '';

    // Validation
    if (empty($bank_code)) {
        $response['errors']['bank_code'] = 'Please select a bank.';
    }
    if (empty($account_number) || !preg_match('/^\d{10}$/', $account_number)) {
        $response['errors']['account_number'] = 'Please enter a valid 10-digit account number.';
    }
    if (empty($account_name)) {
        $response['errors']['account_name'] = 'Account name is required.';
    }

    if (!empty($response['errors'])) {
        $response['message'] = 'Please fix the errors below.';
        echo json_encode($response);
        exit;
    }

    // Check if student already has an account
    $check_stmt = $conn->prepare("SELECT id FROM student_bank_accounts WHERE student_id = ?");
    $check_stmt->bind_param("i", $student_id);
    $check_stmt->execute();
    if ($check_stmt->get_result()->num_rows > 0) {
        throw new Exception('You already have a bank account linked.');
    }

    // Get bank name
    $bank_stmt = $conn->prepare("SELECT name FROM banks WHERE code = ?");
    $bank_stmt->bind_param("s", $bank_code);
    $bank_stmt->execute();
    $bank_result = $bank_stmt->get_result();
    $bank = $bank_result->fetch_assoc();

    if (!$bank) {
        throw new Exception('Invalid bank selected.');
    }

    // Insert bank account
    $insert_stmt = $conn->prepare("
        INSERT INTO student_bank_accounts (student_id, bank_code, bank_name, account_number, account_name, created_at) 
        VALUES (?, ?, ?, ?, ?, NOW())
    ");
    $insert_stmt->bind_param("issss", $student_id, $bank_code, $bank['name'], $account_number, $account_name);

    if ($insert_stmt->execute()) {
        $response['success'] = true;
        $response['message'] = 'Bank account added successfully!';
    } else {
        throw new Exception('Failed to add bank account: ' . $conn->error);
    }

} catch (Exception $e) {
    $response['message'] = $e->getMessage();
}

echo json_encode($response);
?>