<?php
session_start();
require_once '../config/conn.php';

header('Content-Type: application/json');

$response = ['success' => false, 'message' => ''];

try {
    if (!isset($_SESSION['user_id'])) {
        throw new Exception('Session expired. Please login again.');
    }

    $account_id = $_POST['account_id'] ?? 0;

    // Verify ownership and delete
    $delete_stmt = $conn->prepare("
        DELETE FROM student_bank_accounts 
        WHERE id = ? AND student_id = ?
    ");
    $delete_stmt->bind_param("ii", $account_id, $_SESSION['user_id']);

    if ($delete_stmt->execute()) {
        if ($delete_stmt->affected_rows > 0) {
            $response['success'] = true;
            $response['message'] = 'Bank account deleted successfully!';
        } else {
            throw new Exception('Account not found or you do not have permission to delete it.');
        }
    } else {
        throw new Exception('Failed to delete bank account: ' . $conn->error);
    }

} catch (Exception $e) {
    $response['message'] = $e->getMessage();
}

echo json_encode($response);
?>