<?php
header('Content-Type: application/json');

// This is a mock implementation
// In production, you would integrate with a service like Paystack, Flutterwave, etc.

$account_number = $_POST['account_number'] ?? '';
$bank_code = $_POST['bank_code'] ?? '';

// Simulate API delay
sleep(1);

// Mock response - in real implementation, you would call the bank's API
$response = [
    'success' => false,
    'account_name' => '',
    'message' => ''
];

try {
    if (empty($account_number) || empty($bank_code)) {
        throw new Exception('Account number and bank code are required.');
    }

    // Mock successful verification for demonstration
    // In reality, you would call: https://api.paystack.co/bank/resolve?account_number=...&bank_code=...
    if (strlen($account_number) === 10) {
        $response['success'] = true;
        $response['account_name'] = 'John Doe'; // This would come from the actual API
        $response['message'] = 'Account verified successfully';
    } else {
        throw new Exception('Unable to verify account number. Please check and try again.');
    }

} catch (Exception $e) {
    $response['message'] = $e->getMessage();
}

echo json_encode($response);
?>