<?php
ob_start();
// buy-product.php - Purchase Specific Product with AJAX
include 'include/header.php';

// Verify session
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

require_once '../config/conn.php';

$student_id = $_SESSION['user_id'];

// Get vendor ID and product ID from URL
if (!isset($_GET['vendor_id']) || empty($_GET['vendor_id']) || !isset($_GET['product_id']) || empty($_GET['product_id'])) {
    die("Vendor ID and Product ID are required");
}

$vendor_id = intval($_GET['vendor_id']);
$product_id = intval($_GET['product_id']);

// Get vendor details
$vendor_query = "SELECT * FROM vendors WHERE id = '$vendor_id'";
$vendor_result = mysqli_query($conn, $vendor_query);
$vendor = mysqli_fetch_assoc($vendor_result);

if (!$vendor) {
    die("Vendor not found");
}

// Get product details
$product_query = "SELECT * FROM products WHERE id = '$product_id' AND vendor_id = '$vendor_id'";
$product_result = mysqli_query($conn, $product_query);
$product = mysqli_fetch_assoc($product_result);

if (!$product) {
    die("Product not found");
}

// Check if product is in stock
if ($product['stock_status'] != 'in_stock') {
    die("This product is out of stock");
}

// Get student wallet
$wallet_query = "SELECT * FROM student_wallets WHERE student_id = '$student_id'";
$wallet_result = mysqli_query($conn, $wallet_query);
$student_wallet = mysqli_fetch_assoc($wallet_result);

if (!$student_wallet) {
    die("Student wallet not found");
}

// Get student PIN
$pin_query = "SELECT * FROM wallet_pins WHERE student_id = '$student_id'";
$pin_result = mysqli_query($conn, $pin_query);
$wallet_pin = mysqli_fetch_assoc($pin_result);

ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Buy Product - <?= htmlspecialchars($product['name']) ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        .loading-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            z-index: 9999;
            justify-content: center;
            align-items: center;
        }
        .spinner {
            border: 4px solid #f3f3f3;
            border-top: 4px solid #3498db;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            animation: spin 1s linear infinite;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body class="bg-gray-50 dark:bg-gray-900">

    <!-- Loading Overlay -->
    <div id="loadingOverlay" class="loading-overlay">
        <div class="spinner"></div>
    </div>

    <main class="main-content flex-1 p-6 dark:bg-gray-900 overflow-y-auto">
        <!-- Back Button -->
        <div class="mb-4">
            <a href="vendor-products.php?vendor_id=<?= $vendor_id ?>" class="inline-flex items-center text-yellow-600 hover:text-yellow-800 dark:text-yellow-400 dark:hover:text-yellow-300">
                <i class="fas fa-arrow-left mr-2"></i> Back to Products
            </a>
        </div>

        <!-- Page Header -->
        <div class="mb-6">
            <h1 class="text-2xl font-bold text-gray-900 dark:text-white">Complete Your Purchase</h1>
            <p class="text-gray-600 dark:text-gray-400">Review and confirm your order details</p>
        </div>

        <!-- Messages Container -->
        <div id="messageContainer" class="mb-4" style="display: none;">
            <div id="successMessage" class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4 hidden">
                <div class="flex items-center">
                    <i class="fas fa-check-circle mr-2"></i>
                    <span id="successText"></span>
                </div>
            </div>
            <div id="errorMessage" class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4 hidden">
                <div class="flex items-center">
                    <i class="fas fa-exclamation-circle mr-2"></i>
                    <span id="errorText"></span>
                </div>
            </div>
        </div>

        <!-- Product and Vendor Info -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-6">
            <!-- Product Card -->
            <div class="lg:col-span-2">
                <div class="bg-white dark:bg-gray-800   p-6">
                    <div class="flex flex-col md:flex-row gap-6">
                        <!-- Product Image -->
                        <div class="md:w-1/3">
                            <div class="h-64 bg-gray-200 dark:bg-gray-700  overflow-hidden">
                                <?php if (!empty($product['image_path'])): ?>
                                    <img src="../<?= htmlspecialchars($product['image_path']) ?>" 
                                         alt="<?= htmlspecialchars($product['name']) ?>"
                                         class="w-full h-full object-cover">
                                <?php else: ?>
                                    <div class="w-full h-full flex items-center justify-center">
                                        <i class="fas fa-box text-4xl text-gray-400 dark:text-gray-500"></i>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <!-- Product Details -->
                        <div class="md:w-2/3">
                            <h2 class="text-xl font-bold text-gray-900 dark:text-white mb-2"><?= htmlspecialchars($product['name']) ?></h2>
                            
                            <!-- Price -->
                            <div class="mb-4">
                                <span class="text-3xl font-bold text-yellow-600 dark:text-yellow-400">
                                    ₦<?= number_format($product['price'], 2) ?>
                                </span>
                            </div>
                            
                            <!-- Description -->
                            <div class="mb-4">
                                <h3 class="font-semibold text-gray-700 dark:text-gray-300 mb-2">Description</h3>
                                <p class="text-gray-600 dark:text-gray-400"><?= htmlspecialchars($product['description']) ?></p>
                            </div>
                            
                            <!-- Product Info -->
                            <div class="grid grid-cols-2 gap-4 text-sm">
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Status:</span>
                                    <span class="ml-2 px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">
                                        In Stock
                                    </span>
                                </div>
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Added:</span>
                                    <span class="text-gray-900 dark:text-white"><?= date('M d, Y', strtotime($product['created_at'])) ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Vendor & Wallet Info -->
            <div class="space-y-6">
                <!-- Vendor Card -->
                <div class="bg-white dark:bg-gray-800   p-6">
                    <h3 class="font-semibold text-gray-900 dark:text-white mb-4">Vendor Information</h3>
                    <div class="flex items-center mb-4">
                        <div class="w-12 h-12 rounded-full bg-gray-200 dark:bg-gray-700 flex items-center justify-center mr-3">
                            <i class="fas fa-store text-lg text-gray-400 dark:text-gray-500"></i>
                        </div>
                        <div>
                            <h4 class="font-medium text-gray-900 dark:text-white"><?= htmlspecialchars($vendor['business_name']) ?></h4>
                            <p class="text-sm text-gray-600 dark:text-gray-400"><?= htmlspecialchars($vendor['business_type']) ?></p>
                        </div>
                    </div>
                    <div class="text-sm space-y-2">
                        <?php if (!empty($vendor['location'])): ?>
                        <div class="flex items-center text-gray-600 dark:text-gray-400">
                            <i class="fas fa-map-marker-alt mr-2"></i>
                            <span><?= htmlspecialchars($vendor['location']) ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Wallet Balance -->
                <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800  p-6">
                    <div class="flex items-center mb-4">
                        <i class="fas fa-wallet text-2xl text-blue-500 mr-3"></i>
                        <div>
                            <h3 class="font-semibold text-blue-800 dark:text-blue-300">Your Wallet Balance</h3>
                            <p id="walletBalance" class="text-blue-600 dark:text-blue-400 text-2xl font-bold">
                                ₦<?= number_format($student_wallet['balance'], 2) ?>
                            </p>
                        </div>
                    </div>
                    <?php if (!$wallet_pin): ?>
                    <div class="mt-3 p-2 bg-yellow-100 dark:bg-yellow-900/30 border border-yellow-200 dark:border-yellow-800 rounded">
                        <p class="text-sm text-yellow-800 dark:text-yellow-300">
                            <i class="fas fa-exclamation-triangle mr-1"></i>
                            You need to set a PIN before making purchases.
                        </p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Order Form -->
        <div class="bg-white dark:bg-gray-800   p-6">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-6">Order Details</h3>
            
            <form id="purchaseForm" method="POST">
                <input type="hidden" name="vendor_id" value="<?= $vendor_id ?>">
                <input type="hidden" name="product_id" value="<?= $product_id ?>">
                <input type="hidden" name="product_name" value="<?= htmlspecialchars($product['name']) ?>">
                <input type="hidden" name="unit_price" value="<?= $product['price'] ?>">
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Left Column -->
                    <div>
                        <!-- Quantity -->
                        <div class="mb-6">
                            <label for="quantity" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Quantity *</label>
                            <div class="flex items-center">
                                <button type="button" id="decreaseQuantity" class="bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-300 w-10 h-10 rounded-l-md flex items-center justify-center hover:bg-gray-300 dark:hover:bg-gray-600">
                                    <i class="fas fa-minus"></i>
                                </button>
                                <input type="number" id="quantity" name="quantity" min="1" value="1" required
                                       class="w-20 h-10 text-center border-t border-b border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white focus:outline-none">
                                <button type="button" id="increaseQuantity" class="bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-300 w-10 h-10 rounded-r-md flex items-center justify-center hover:bg-gray-300 dark:hover:bg-gray-600">
                                    <i class="fas fa-plus"></i>
                                </button>
                                <span class="ml-4 text-gray-600 dark:text-gray-400">
                                    @ ₦<?= number_format($product['price'], 2) ?> each
                                </span>
                            </div>
                        </div>

                        <!-- Special Instructions -->
                        <div class="mb-6">
                            <label for="special_instructions" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Special Instructions</label>
                            <textarea id="special_instructions" name="special_instructions" rows="3"
                                      placeholder="Any special instructions for the vendor (optional)"
                                      class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md focus:outline-none focus:ring-2 focus:ring-yellow-500 dark:bg-gray-700 dark:text-white"></textarea>
                        </div>
                    </div>
                    
                    <!-- Right Column - Order Summary -->
                    <div>
                        <div class="bg-gray-50 dark:bg-gray-700 border border-gray-200 dark:border-gray-600  p-6">
                            <h4 class="font-semibold text-gray-900 dark:text-white mb-4">Order Summary</h4>
                            
                            <div class="space-y-3 mb-4">
                                <div class="flex justify-between">
                                    <span class="text-gray-600 dark:text-gray-400">Product:</span>
                                    <span class="font-medium text-gray-900 dark:text-white"><?= htmlspecialchars($product['name']) ?></span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600 dark:text-gray-400">Unit Price:</span>
                                    <span class="font-medium">₦<?= number_format($product['price'], 2) ?></span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600 dark:text-gray-400">Quantity:</span>
                                    <span id="summaryQuantity" class="font-medium">1</span>
                                </div>
                            </div>
                            
                            <div class="border-t dark:border-gray-600 pt-4 space-y-2">
                                <div class="flex justify-between text-lg font-semibold">
                                    <span>Total Amount:</span>
                                    <span id="summaryTotal" class="text-yellow-600">₦<?= number_format($product['price'], 2) ?></span>
                                </div>
                                <div class="flex justify-between text-sm">
                                    <span class="text-gray-500 dark:text-gray-400">Your balance after purchase:</span>
                                    <span id="summaryBalanceAfter" class="text-gray-500 dark:text-gray-400">
                                        ₦<?= number_format($student_wallet['balance'] - $product['price'], 2) ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                        
                        <!-- PIN Input -->
                        <div class="mt-4">
                            <label for="pin" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Enter PIN to Confirm *</label>
                            <input type="password" id="pin" name="pin" maxlength="4" required
                                   pattern="[0-9]{4}"
                                   placeholder="Enter your 4-digit PIN"
                                   class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md focus:outline-none focus:ring-2 focus:ring-yellow-500 dark:bg-gray-700 dark:text-white">
                            <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">Enter your 4-digit wallet PIN to confirm the payment</p>
                        </div>
                        
                        <!-- Submit Button -->
                        <button type="submit"
                                class="w-full mt-6 bg-yellow-500 text-white py-3 px-4 rounded-md hover:bg-yellow-600 focus:outline-none focus:ring-2 focus:ring-yellow-500 transition duration-200 font-medium text-lg">
                            <i class="fas fa-lock mr-2"></i> Confirm & Pay from Wallet
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </main>

    <script>
    $(document).ready(function() {
        const unitPrice = <?= $product['price'] ?>;
        const initialBalance = <?= $student_wallet['balance'] ?>;
        let currentQuantity = 1;
        let currentTotalAmount = unitPrice;

        // Show/hide messages
        function showMessage(type, message) {
            $('#messageContainer').show();
            if (type === 'success') {
                $('#successText').text(message);
                $('#successMessage').removeClass('hidden');
                $('#errorMessage').addClass('hidden');
            } else {
                $('#errorText').text(message);
                $('#errorMessage').removeClass('hidden');
                $('#successMessage').addClass('hidden');
            }
            
            // Auto-hide after 5 seconds
            setTimeout(() => {
                $('#messageContainer').hide();
            }, 5000);
        }

        function updateOrderSummary() {
            currentQuantity = parseInt($('#quantity').val()) || 1;
            currentTotalAmount = unitPrice * currentQuantity;
            const balanceAfter = initialBalance - currentTotalAmount;

            $('#summaryQuantity').text(currentQuantity);
            $('#summaryTotal').text(`₦${currentTotalAmount.toFixed(2)}`);
            $('#summaryBalanceAfter').text(`₦${balanceAfter.toFixed(2)}`);
            
            if (balanceAfter < 0) {
                $('#summaryBalanceAfter').removeClass('text-gray-500 dark:text-gray-400')
                    .addClass('text-red-600 dark:text-red-400');
            } else {
                $('#summaryBalanceAfter').removeClass('text-red-600 dark:text-red-400')
                    .addClass('text-gray-500 dark:text-gray-400');
            }
        }

        // Quantity controls
        $('#decreaseQuantity').click(function() {
            let quantity = parseInt($('#quantity').val()) || 1;
            if (quantity > 1) {
                $('#quantity').val(quantity - 1);
                updateOrderSummary();
            }
        });

        $('#increaseQuantity').click(function() {
            let quantity = parseInt($('#quantity').val()) || 1;
            $('#quantity').val(quantity + 1);
            updateOrderSummary();
        });

        $('#quantity').on('input change', function() {
            if (this.value < 1) {
                this.value = 1;
            }
            updateOrderSummary();
        });

        // Restrict PIN input to numbers only
        $('#pin').on('input', function() {
            this.value = this.value.replace(/[^0-9]/g, '');
        });

        // AJAX form submission
        $('#purchaseForm').submit(function(e) {
            e.preventDefault();
            
            // Basic validation
            const quantity = parseInt($('#quantity').val()) || 0;
            const total = unitPrice * quantity;
            const pin = $('#pin').val().trim();

            // Clear previous error styling
            $('#quantity, #pin').removeClass('border-red-500');

            let isValid = true;
            let errorMessage = '';

            if (quantity < 1) {
                $('#quantity').addClass('border-red-500');
                errorMessage = 'Please enter a valid quantity';
                isValid = false;
            } else if (total > initialBalance) {
                errorMessage = 'Insufficient wallet balance for this purchase';
                isValid = false;
            } else if (pin.length !== 4) {
                $('#pin').addClass('border-red-500');
                errorMessage = 'Please enter a valid 4-digit PIN';
                isValid = false;
            }

            if (!isValid) {
                showMessage('error', errorMessage);
                return;
            }

            // Show loading overlay
            $('#loadingOverlay').show();

            // Get form data
            const formData = $(this).serialize();

            // Send AJAX request
            $.ajax({
                url: 'ajax/purchase-product.php',
                type: 'POST',
                data: formData,
                dataType: 'json',
                success: function(response) {
                    $('#loadingOverlay').hide();
                    
                    if (response.success) {
                        showMessage('success', response.message);
                        
                        // Update wallet balance
                        if (response.new_balance !== undefined) {
                            $('#walletBalance').text('₦' + parseFloat(response.new_balance).toFixed(2));
                        }
                        
                        // Disable form and show success message
                        $('#purchaseForm :input').prop('disabled', true);
                        $('button[type="submit"]')
                            .html('<i class="fas fa-check mr-2"></i> Purchase Completed')
                            .removeClass('bg-yellow-500 hover:bg-yellow-600')
                            .addClass('bg-green-500 cursor-not-allowed');
                        
                        // Redirect after 2 seconds
                        setTimeout(() => {
                            if (response.reference) {
                                window.location.href = 'purchase_success.php?reference=' + response.reference;
                            } else {
                                window.location.href = 'vendor-products.php?vendor_id=<?= $vendor_id ?>';
                            }
                        }, 2000);
                    } else {
                        showMessage('error', response.message || 'An error occurred');
                    }
                },
                error: function(xhr, status, error) {
                    $('#loadingOverlay').hide();
                    let errorMsg = 'An error occurred while processing your request';
                    
                    try {
                        const response = JSON.parse(xhr.responseText);
                        if (response.message) {
                            errorMsg = response.message;
                        }
                    } catch (e) {
                        // Use default error message
                    }
                    
                    showMessage('error', errorMsg);
                    console.error('AJAX Error:', error);
                }
            });
        });

        // Initial update
        updateOrderSummary();
    });
    </script>

    <?php include 'include/footer.php'; ?>
</body>
</html>