<?php
// check_withdrawal_status.php
session_start();
require_once '../config/conn.php';

if (!isset($_SESSION['user_id'])) {
    exit();
}

$student_id = $_SESSION['user_id'];

// Get pending withdrawals for this user
$stmt = $conn->prepare("
    SELECT wt.*, sba.bank_name, sba.account_number
    FROM wallet_transactions wt
    JOIN student_wallets sw ON wt.wallet_id = sw.id
    LEFT JOIN student_bank_accounts sba ON wt.bank_account_id = sba.id
    WHERE sw.student_id = ?
    AND wt.transaction_type = 'withdrawal'
    AND wt.status IN ('pending', 'processing')
    ORDER BY wt.created_at DESC
");
$stmt->bind_param("i", $student_id);
$stmt->execute();
$result = $stmt->get_result();

$withdrawals = [];
while ($row = $result->fetch_assoc()) {
    $withdrawals[] = $row;
}

header('Content-Type: application/json');
echo json_encode(['withdrawals' => $withdrawals]);
?>