<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
require '../config/conn.php';

$errors = [
    'email' => ''
];

$form_data = isset($_SESSION['form_data']) ? $_SESSION['form_data'] : [];
$email = $form_data['email'] ?? '';

if (isset($_SESSION['reset_success'])) {
    $reset_success = $_SESSION['reset_success'];
    unset($_SESSION['reset_success']);
}

if (isset($_SESSION['reset_error'])) {
    $reset_error = $_SESSION['reset_error'];
    unset($_SESSION['reset_error']);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Campus Services - Reset Password</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body { font-family: 'Poppins', sans-serif; }
    </style>
</head>
<body class=" bg-gray-100 flex items-center justify-center p-4">
    <div class="w-full max-w-sm">
        <!-- Logo and Header -->
        <div class="text-center mb-6">
            <div class="w-16 h-16 mx-auto mb-3 flex items-center justify-center">
                <img src="../img/schools.png" alt="School Logo" class="max-w-full max-h-full">
            </div>
            <h1 class="text-xl font-bold text-gray-800">Campus Services</h1>
            <p class="text-gray-500 text-sm mt-1">Reset Password</p>
        </div>

        <!-- Messages -->
        <div id="messageContainer" class="mb-4"></div>

        <?php 
        if (isset($_SESSION['success_message'])) {
            echo '<div class="bg-green-50 border border-green-200 p-3 mb-4 text-green-700 text-sm rounded-lg">' . $_SESSION['success_message'] . '</div>';
            unset($_SESSION['success_message']);
        }
        
        if (isset($_SESSION['error_messages'])) {
            foreach ($_SESSION['error_messages'] as $error) {
                echo '<div class="bg-red-50 border border-red-200 p-3 mb-4 text-red-700 text-sm rounded-lg">' . $error . '</div>';
            }
            unset($_SESSION['error_messages']);
        }
        
        if (isset($reset_success)): ?>
            <div class="bg-green-50 border border-green-200 p-3 mb-4 text-green-700 text-sm rounded-lg">
                <?php echo $reset_success; ?>
            </div>
        <?php endif; 
        
        if (isset($reset_error)): ?>
            <div class="bg-red-50 border border-red-200 p-3 mb-4 text-red-700 text-sm rounded-lg">
                <?php echo $reset_error; ?>
            </div>
        <?php endif; ?>

        <!-- Password Reset Form -->
        <div class="bg-white  p-6">
            <div class="bg-yellow-50 border border-yellow-200 p-3 mb-4 text-yellow-700 text-xs rounded-lg">
                <p class="font-medium mb-1">How to reset:</p>
                <p>1. Enter your email below</p>
                <p>2. Check email for reset link</p>
                <p>3. Set new password</p>
            </div>

            <form id="forgotForm" method="POST">
                <!-- Email -->
                <div class="mb-5">
                    <label class="block text-gray-700 text-sm font-medium mb-1">Email Address</label>
                    <div class="relative">
                        <i class="fas fa-envelope absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400 text-sm"></i>
                        <input type="email" name="email" 
                               value="<?php echo htmlspecialchars($email); ?>"
                               class="w-full pl-9 pr-3 py-2 text-sm border border-gray-300 rounded-lg focus:outline-none focus:ring-1 focus:ring-[#fbbb01] focus:border-[#fbbb01]"
                               placeholder="student@school.edu"
                               required>
                    </div>
                    <small class="text-red-500 text-xs mt-1 block" id="email_error"><?php echo $errors['email']; ?></small>
                </div>
                
                <!-- Submit Button -->
                <button type="submit" id="submitBtn" 
                        class="w-full py-2.5 bg-[#fbbb01] text-white text-sm font-medium rounded-lg hover:bg-[#e0a800] transition disabled:opacity-70 disabled:cursor-not-allowed">
                    <span id="btnText">Send Reset Link</span>
                    <span id="loadingSpinner" class="hidden ml-2">
                        <i class="fas fa-spinner fa-spin"></i>
                    </span>
                </button>
                
                <!-- Back to Login -->
                <div class="text-center mt-4">
                    <p class="text-gray-500 text-xs">
                        Remember your password? 
                        <a href="login.php" class="text-[#fbbb01] hover:text-[#e0a800] font-medium">Login here</a>
                    </p>
                </div>
            </form>
        </div>
    </div>

    <script>
    function showMessage(message, type) {
        const container = document.getElementById('messageContainer');
        const colors = {
            success: 'bg-green-50 text-green-700 border border-green-200',
            error: 'bg-red-50 text-red-700 border border-red-200',
            info: 'bg-blue-50 text-blue-700 border border-blue-200'
        };
        
        const div = document.createElement('div');
        div.className = `p-3 rounded-lg text-sm mb-3 ${colors[type] || colors.info}`;
        div.innerHTML = `
            <div class="flex items-center">
                <i class="fas ${type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle'} mr-2"></i>
                <span>${message}</span>
            </div>
        `;
        
        container.prepend(div);
        setTimeout(() => div.remove(), 4000);
    }

    function isValidEmail(email) {
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return emailRegex.test(email);
    }

    document.getElementById('forgotForm').addEventListener('submit', async function(e) {
        e.preventDefault();
        
        const btn = document.getElementById('submitBtn');
        const btnText = document.getElementById('btnText');
        const spinner = document.getElementById('loadingSpinner');
        const emailInput = document.querySelector('input[name="email"]');
        const emailError = document.getElementById('email_error');
        
        // Validate email
        const email = emailInput.value.trim();
        if (!isValidEmail(email)) {
            emailError.textContent = 'Please enter a valid email address';
            return;
        }
        
        btn.disabled = true;
        btnText.textContent = 'Sending...';
        spinner.classList.remove('hidden');
        
        // Clear messages
        document.getElementById('messageContainer').innerHTML = '';
        emailError.textContent = '';
        
        try {
            const formData = new FormData(this);
            formData.append('forgot_password', '1');
            
            const response = await fetch('process_forgot_password.php', {
                method: 'POST',
                body: formData
            });
            
            const data = await response.json();
            
            btn.disabled = false;
            btnText.textContent = 'Send Reset Link';
            spinner.classList.add('hidden');
            
            if (data.success) {
                showMessage(data.message, 'success');
                this.reset();
                
                if (data.redirect) {
                    setTimeout(() => {
                        window.location.href = data.redirect;
                    }, 2000);
                }
            } else {
                if (data.message) showMessage(data.message, 'error');
                if (data.errors && data.errors.email) {
                    emailError.textContent = data.errors.email;
                }
            }
        } catch (error) {
            btn.disabled = false;
            btnText.textContent = 'Send Reset Link';
            spinner.classList.add('hidden');
            showMessage('Network error. Try again.', 'error');
        }
    });

    // Email validation on blur
    document.querySelector('input[name="email"]').addEventListener('blur', function() {
        const email = this.value.trim();
        const emailError = document.getElementById('email_error');
        
        if (email && !isValidEmail(email)) {
            emailError.textContent = 'Please enter a valid email address';
        } else {
            emailError.textContent = '';
        }
    });

    document.addEventListener('DOMContentLoaded', function() {
        document.querySelector('input[name="email"]').focus();
    });
    </script>
</body>
</html>

<?php
if (isset($_SESSION['form_data'])) {
    unset($_SESSION['form_data']);
}
?>