<?php
ob_start();
include 'include/header.php';
require_once '../config/conn.php';

// Authentication check
if (!isset($_SESSION['user_id'])) {
    header("Location: student/login.php");
    exit();
}

$student_id = $_SESSION['user_id'];
?>

<!-- Main Container -->
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6" style="margin-bottom: 80px;" id="wallet-dashboard">
    <!-- Loading State -->
    <div class="col-span-3 text-center py-12">
        <div class="animate-spin rounded-full h-12 w-12 border-t-2 border-b-2 border-primary-500 mx-auto mb-4"></div>
        <p>Loading wallet dashboard...</p>
    </div>
</div>

<!-- Loading Overlay for AJAX operations -->
<div id="loading-overlay" class="hidden fixed inset-0 bg-black bg-opacity-50 z-50 flex items-center justify-center">
    <div class="bg-white p-6 rounded-lg shadow-lg text-center">
        <div class="animate-spin rounded-full h-12 w-12 border-t-2 border-b-2 border-primary-500 mx-auto mb-4"></div>
        <p>Loading...</p>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Load wallet dashboard
    loadWalletDashboard();
    
    // Set up periodic refresh (every 30 seconds)
    setInterval(loadWalletDashboard, 30000);
    
    // Add event delegation for balance toggle since content is loaded dynamically
    document.addEventListener('click', function(e) {
        if (e.target && (e.target.id === 'toggle-balance' || e.target.closest('#toggle-balance'))) {
            toggleBalanceVisibility();
        }
        
        if (e.target && (e.target.id === 'copy-wallet-id' || e.target.closest('#copy-wallet-id'))) {
            copyWalletId();
        }
    });
});

function toggleBalanceVisibility() {
    const balanceAmount = document.getElementById('balance-amount');
    const balanceMask = document.getElementById('balance-mask');
    const eyeIcon = document.getElementById('eye-icon');
    const eyeOffIcon = document.getElementById('eye-off-icon');
    
    if (balanceAmount.style.display === 'none') {
        balanceAmount.style.display = 'block';
        balanceMask.style.display = 'none';
        eyeIcon.classList.add('hidden');
        eyeOffIcon.classList.remove('hidden');
    } else {
        balanceAmount.style.display = 'none';
        balanceMask.style.display = 'block';
        eyeIcon.classList.remove('hidden');
        eyeOffIcon.classList.add('hidden');
    }
}

function loadWalletDashboard() {
    showLoading();
    fetch('load_wallet_dashboard.php')
        .then(response => response.text())
        .then(html => {
            document.getElementById('wallet-dashboard').innerHTML = html;
            hideLoading();
        })
        .catch(error => {
            document.getElementById('wallet-dashboard').innerHTML = `
                <div class="col-span-3 text-center py-12 text-red-500">
                    <i class="fas fa-exclamation-circle text-4xl mb-4"></i>
                    <p>Failed to load wallet data. Please try again.</p>
                    <button onclick="loadWalletDashboard()" class="mt-4 px-4 py-2 bg-primary-500 text-white rounded hover:bg-primary-600">
                        Retry
                    </button>
                </div>
            `;
            hideLoading();
        });
}

function copyWalletId() {
    const walletId = document.getElementById('wallet-id').textContent;
    navigator.clipboard.writeText(walletId).then(() => {
        alert('Wallet ID copied to clipboard!');
    }).catch(err => {
        console.error('Failed to copy: ', err);
    });
}

function showLoading() {
    document.getElementById('loading-overlay').classList.remove('hidden');
}

function hideLoading() {
    document.getElementById('loading-overlay').classList.add('hidden');
}
</script>

<?php include 'include/footer.php'; ?>