<?php
require_once '../config/conn.php';
header('Content-Type: application/json');

// Authenticate request
session_start();
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

$input = json_decode(file_get_contents('php://input'), true);
$action = $input['action'] ?? '';

try {
    switch ($action) {
        case 'initiate_transfer':
            // In a real implementation, you would:
            // 1. Initiate the bank transfer request
            // 2. Send OTP to user's phone
            // 3. Create a pending transaction record
            
            // For demo, we'll just simulate this
            $response = [
                'success' => true,
                'message' => 'OTP sent to your phone',
                'reference' => $input['reference']
            ];
            break;
            
        case 'resend_otp':
            // Resend OTP logic
            $response = [
                'success' => true,
                'message' => 'New OTP sent'
            ];
            break;
            
        case 'verify_otp':
            // In a real implementation, you would:
            // 1. Verify the OTP with your payment processor
            // 2. If valid, complete the transfer
            // 3. Update wallet balance
            // 4. Create transaction record
            
            // For demo, we'll simulate success if OTP is '123456'
            if ($input['otp'] === '123456') {
                // Update wallet balance (example)
                $amount = $input['amount'] / 100; // Convert back to Naira
                $student_id = $_SESSION['user_id'];
                
                $conn->begin_transaction();
                
                // Update wallet balance
                $stmt = $conn->prepare("UPDATE student_wallets SET balance = balance + ? WHERE student_id = ?");
                $stmt->bind_param("di", $amount, $student_id);
                $stmt->execute();
                
                // Create transaction record
                $txn_stmt = $conn->prepare("INSERT INTO wallet_transactions 
                    (student_id, wallet_id, amount, transaction_type, reference, status, description) 
                    VALUES (?, ?, ?, 'credit', ?, 'completed', 'Bank transfer deposit')");
                $txn_stmt->bind_param("iids", $student_id, $input['wallet_db_id'], $amount, $input['reference']);
                $txn_stmt->execute();
                
                $conn->commit();
                
                $response = ['success' => true, 'message' => 'Payment verified'];
            } else {
                $response = ['success' => false, 'message' => 'Invalid OTP'];
            }
            break;
            
        default:
            $response = ['success' => false, 'message' => 'Invalid action'];
    }
} catch (Exception $e) {
    $conn->rollback();
    $response = ['success' => false, 'message' => 'Error: ' . $e->getMessage()];
}

echo json_encode($response);
?>