<?php
// process_forgot_password.php
require '../config/conn.php';
require '../config/session.php';
require '../vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

// Set content type to JSON
header('Content-Type: application/json');

// Set timezone to UTC for consistency
date_default_timezone_set('UTC');

// Check if this is a form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['forgot_password'])) {
    $email = trim($_POST['email'] ?? '');
    
    // Store form data in session in case of errors
    $_SESSION['form_data'] = [
        'email' => $email
    ];
    
    // Validate email
    $errors = [];
    
    if (empty($email)) {
        $errors['email'] = "Email is required";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors['email'] = "Invalid email format";
    }
    
    if (!empty($errors)) {
        echo json_encode([
            'success' => false,
            'errors' => $errors,
            'message' => 'Please fix the errors below.'
        ]);
        exit();
    }
    
    // Check if email exists and account is verified
    $stmt = $conn->prepare("SELECT id, full_name, is_verified FROM students WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
        echo json_encode([
            'success' => false,
            'errors' => ['email' => 'Email not registered'],
            'message' => 'Email address not found in our system.'
        ]);
        exit();
    }
    
    $user = $result->fetch_assoc();
    
    if (!$user['is_verified']) {
        echo json_encode([
            'success' => false,
            'message' => 'Your account is not verified. Please verify your account first.',
            'redirect' => 'login.php'
        ]);
        exit();
    }
    
    // Generate reset token - use UTC time consistently
    $reset_token = bin2hex(random_bytes(32));
    $reset_token_expiry = gmdate('Y-m-d H:i:s', strtotime('+1 hour')); // Use UTC time (gmdate)
    
    // Update user record with reset token
    $stmt = $conn->prepare("UPDATE students SET reset_token = ?, reset_token_expiry = ? WHERE email = ?");
    $stmt->bind_param("sss", $reset_token, $reset_token_expiry, $email);
    
    if ($stmt->execute()) {
        // Send reset email
        $mail = new PHPMailer(true);
        
        try {
            // Server settings
            $mail->isSMTP();
            $mail->Host       = 'smtp.gmail.com';
            $mail->SMTPAuth   = true;
            $mail->Username   = 'olorodemicheal2274@gmail.com';
            $mail->Password   = 'farq ptyc vjtl eses';
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
            $mail->Port       = 465;
            
            // Recipients - Updated to Aletheia University
            $mail->setFrom('noreply@aletheia.edu', 'Aletheia University Campus Services');
            $mail->addAddress($email, $user['full_name']);
            
            // Content
            $mail->isHTML(true);
            $mail->Subject = 'Password Reset Request - Aletheia University';
            
            $reset_link = "https://adinoheightschols.com/student/reset_password.php?token=$reset_token&email=" . urlencode($email);
            
            $mail->Body = "
<!DOCTYPE html>
<html>
<head>
    <meta charset='UTF-8'>
    <title>Password Reset - Aletheia University</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .university-header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #2C3E50;
        }
        .university-name {
            font-size: 28px;
            font-weight: bold;
            color: #2C3E50;
            margin: 0;
            letter-spacing: 1px;
        }
        .subtitle {
            font-size: 16px;
            color: #666;
            margin: 5px 0 0 0;
        }
        .greeting {
            color: #2C3E50;
            font-size: 18px;
            margin-top: 0;
        }
        .info-box {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
            border-left: 4px solid #FBBB01;
        }
        .reset-button {
            text-align: center;
            margin: 30px 0;
        }
        .reset-button a {
            background-color: #2C3E50;
            color: #FFFFFF;
            padding: 12px 30px;
            text-decoration: none;
            border-radius: 4px;
            display: inline-block;
            font-weight: bold;
            border: 2px solid #FBBB01;
            font-size: 16px;
        }
        .reset-button a:hover {
            background-color: #1a252f;
        }
        .reset-link {
            background-color: #fff3cd;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
            border: 1px solid #ffeaa7;
            word-break: break-all;
            font-size: 14px;
        }
        .reset-link p {
            margin: 0;
            color: #856404;
        }
        .warning-box {
            background-color: #e8f4fd;
            padding: 15px;
            border-radius: 5px;
            margin: 25px 0;
            border-left: 4px solid #2196F3;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            color: #777;
            font-size: 12px;
        }
        .highlight {
            color: #FBBB01;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class='container'>
        <div class='university-header'>
            <h1 class='university-name'>ALETHEIA UNIVERSITY</h1>
            <p class='subtitle'>Campus Services Password Reset</p>
        </div>
        
        <h2 class='greeting'>Hello {$user['full_name']},</h2>
        
        <p>We received a request to reset your password for your Aletheia University Campus Services account.</p>
        
        <div class='info-box'>
            <p><strong>If you didn't request this password reset:</strong></p>
            <p>You can safely ignore this email. Your password will remain unchanged.</p>
            <p>If you're concerned about account security, please contact the IT Help Desk immediately.</p>
        </div>
        
        <p>To reset your password, click the button below:</p>
        
        <div class='reset-button'>
            <a href='$reset_link'>Reset Password</a>
        </div>
        
        <p style='text-align: center; color: #666; font-size: 14px;'>Or copy and paste this link in your browser:</p>
        
        <div class='reset-link'>
            <p>$reset_link</p>
        </div>
        
        
    
        
        <p>Best regards,<br>
        <strong>Aletheia University Campus Services</strong></p>
        
        <div class='footer'>
            <p>Aletheia University IT Services</p>
            <p>This is an automated message. Please do not reply to this email.</p>
            <p>© " . date('Y') . " Aletheia University. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
            ";
            
            $mail->AltBody = "ALETHEIA UNIVERSITY\nCampus Services Password Reset\n\n" .
                            "Hello {$user['full_name']},\n\n" .
                            "We received a request to reset your password for your Aletheia University Campus Services account.\n\n" .
                            "To reset your password, click the following link:\n" .
                            "$reset_link\n\n" .
                            "⚠️ Important: This password reset link will expire in 1 hour.\n\n" .
                            "If you didn't request this password reset, you can safely ignore this email.\n\n" .
                            "If you have any questions or need assistance, please contact the IT Help Desk.\n\n" .
                            "Best regards,\n" .
                            "Aletheia University Campus Services\n\n" .
                            "This is an automated message. Please do not reply to this email.\n" .
                            "© " . date('Y') . " Aletheia University. All rights reserved.";
            
            $mail->send();
            
            // Clear form data from session
            unset($_SESSION['form_data']);
            
            // Return success response
            echo json_encode([
                'success' => true,
                'message' => "Password reset link sent to your email. Please check your inbox (and spam folder)."
            ]);
            exit();
            
        } catch (Exception $e) {
            echo json_encode([
                'success' => false,
                'message' => "Failed to send password reset email. Please try again later.",
                'debug' => 'Email error: ' . $e->getMessage()
            ]);
            exit();
        }
    } else {
        echo json_encode([
            'success' => false,
            'message' => "Failed to process your request. Please try again."
        ]);
        exit();
    }
} else {
    // Not a POST request or missing forgot_password parameter
    echo json_encode([
        'success' => false,
        'message' => 'Invalid request.'
    ]);
    exit();
}
?>