<?php
// process_login.php
session_start();
require '../config/conn.php';
require '../vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $remember_me = isset($_POST['remember_me']) ? 1 : 0;

    $errors = [];

    // Basic validation
    if (empty($email)) {
        $errors['email'] = "Email is required";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors['email'] = "Invalid email format";
    }

    if (empty($password)) {
        $errors['password'] = "Password is required";
    }

    // Only proceed with database check if no validation errors
    if (empty($errors)) {
        // Check if user exists
        $stmt = $conn->prepare("SELECT id, student_id, full_name, email, password, is_verified FROM students WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows === 1) {
            $user = $result->fetch_assoc();

            // Verify password
            if (password_verify($password, $user['password'])) {
                // Check if account is verified
                if ($user['is_verified']) {
                    // Generate a 6-digit verification code
                    $verification_code = str_pad(mt_rand(0, 999999), 6, '0', STR_PAD_LEFT);
                    $expires_at = date('Y-m-d H:i:s', strtotime('+10 minutes'));
                    
                    // Store the code in the database
                    $stmt = $conn->prepare("INSERT INTO verification_codes (user_id, code, expires_at) VALUES (?, ?, ?)");
                    $stmt->bind_param("iss", $user['id'], $verification_code, $expires_at);
                    
                    if ($stmt->execute()) {
                        // Send the verification code via email
                        $mail = new PHPMailer(true);
                        try {
                            // Server settings
                            $mail->isSMTP();
                            $mail->Host       = 'smtp.gmail.com';
                            $mail->SMTPAuth   = true;
                            $mail->Username   = 'olorodemicheal2274@gmail.com';
                            $mail->Password   = 'farq ptyc vjtl eses';
                            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
                            $mail->Port       = 465;
                            
                            // Recipients
                            $mail->setFrom('noreply@aletheia.edu', 'Aletheia University Campus Services');
                            $mail->addAddress($email, $user['full_name']);
                            
                            // Content
                            $mail->isHTML(true);
                            $mail->Subject = 'Login Verification Code - Aletheia University';
                            
                            $mail->Body = "
<!DOCTYPE html>
<html>
<head>
    <meta charset='UTF-8'>
    <title>Login Verification - Aletheia University</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .university-header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #2C3E50;
        }
        .university-name {
            font-size: 28px;
            font-weight: bold;
            color: #2C3E50;
            margin: 0;
            letter-spacing: 1px;
        }
        .subtitle {
            font-size: 16px;
            color: #666;
            margin: 5px 0 0 0;
        }
        .greeting {
            color: #2C3E50;
            font-size: 18px;
            margin-top: 0;
        }
        .verification-code {
            font-size: 36px;
            font-weight: bold;
            color: #2C3E50;
            letter-spacing: 10px;
            font-family: 'Courier New', monospace;
            text-align: center;
            margin: 30px 0;
            padding: 20px;
            background-color: #f5f5f5;
            border-radius: 5px;
        }
        .code-label {
            text-align: center;
            font-size: 14px;
            color: #666;
            margin-bottom: 5px;
        }
        .instructions {
            background-color: #f9f9f9;
            padding: 15px;
            border-radius: 5px;
            margin: 25px 0;
            border-left: 4px solid #FBBB01;
        }
        .instructions p {
            margin: 8px 0;
            font-size: 14px;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            color: #777;
            font-size: 12px;
        }
        .highlight {
            color: #FBBB01;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class='container'>
        <div class='university-header'>
            <h1 class='university-name'>ALETHEIA UNIVERSITY</h1>
            <p class='subtitle'>Campus Services Login Verification</p>
        </div>
        
        <h2 class='greeting'>Hello {$user['full_name']},</h2>
        
        <p>You've requested to log in to your Aletheia University Campus Services account. To complete your login, please use the verification code below:</p>
        
        <p class='code-label'>Your verification code:</p>
        <div class='verification-code'>{$verification_code}</div>
        
        <div class='instructions'>
            <p><strong>Important Information:</strong></p>
            <p>• Enter this code on the verification page to complete your login</p>
            <p>• This code will expire in <span class='highlight'>10 minutes</span></p>
            <p>• Do not share this code with anyone</p>
            <p>• If you didn't request this code, please ignore this email</p>
        </div>
        
        <p>For security reasons, this code is required each time you log in from a new device or location.</p>
        
        <p>Best regards,<br>
        <strong>Aletheia University Campus Services</strong></p>
        
        <div class='footer'>
            <p>Aletheia University IT Services</p>
            <p>This is an automated message. Please do not reply to this email.</p>
            <p>© " . date('Y') . " Aletheia University. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
                            ";
                            
                            $mail->send();
                            
                            // Store user ID in session for verification
                            $_SESSION['2fa_user_id'] = $user['id'];
                            $_SESSION['2fa_remember_me'] = $remember_me;
                            
                            echo json_encode([
                                'success' => true,
                                'message' => 'Verification code sent to your email!',
                                'verification_required' => true
                            ]);
                            
                        } catch (Exception $e) {
                            echo json_encode([
                                'success' => false,
                                'message' => 'Failed to send verification code. Please try again.',
                                'errors' => ['email' => 'Email service temporarily unavailable']
                            ]);
                        }
                    } else {
                        echo json_encode([
                            'success' => false,
                            'message' => 'Failed to generate verification code. Please try again.'
                        ]);
                    }
                } else {
                    // Account not verified
                    echo json_encode([
                        'success' => false,
                        'message' => 'Account not verified. Please check your email for verification link.',
                        'errors' => ['email' => 'Account not verified'],
                        'resend_verification' => true,
                        'email' => $email
                    ]);
                }
            } else {
                echo json_encode([
                    'success' => false,
                    'message' => 'Incorrect password.',
                    'errors' => ['password' => 'Incorrect password']
                ]);
            }
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Email not registered.',
                'errors' => ['email' => 'Email not registered']
            ]);
        }
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Please fix the errors below.',
            'errors' => $errors
        ]);
    }
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid request method.'
    ]);
}
?>