<?php
// process_verify_code.php
ob_start();
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

// Set PHP timezone - IMPORTANT for time consistency
date_default_timezone_set('Africa/Lagos'); // Change to your server's timezone

require '../config/conn.php';
require '../vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

header('Content-Type: application/json');

// Also set MySQL timezone if connection exists
if (isset($conn) && $conn) {
    $conn->query("SET time_zone = '+01:00'"); // For Africa/Lagos (UTC+1)
}

if (!isset($_SESSION['2fa_user_id'])) {
    echo json_encode([
        'success' => false,
        'message' => 'Session expired. Please login again.',
        'redirect' => 'login.php'
    ]);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verify code submission
    if (isset($_POST['verify'])) {
        $code = trim($_POST['code'] ?? '');
        
        if (empty($code)) {
            echo json_encode([
                'success' => false,
                'message' => 'Verification code is required',
                'clear_input' => false
            ]);
            exit();
        }
        
        if (!preg_match('/^\d{6}$/', $code)) {
            echo json_encode([
                'success' => false,
                'message' => 'Invalid code format. Please enter a 6-digit number.',
                'clear_input' => true
            ]);
            exit();
        }
        
        // Debug logging (optional - remove in production)
        error_log("2FA Verification Attempt:");
        error_log("User ID: " . $_SESSION['2fa_user_id']);
        error_log("Code: " . $code);
        error_log("Server Time: " . date('Y-m-d H:i:s'));
        
        // Using UTC_TIMESTAMP() for consistent time comparison
        $stmt = $conn->prepare("SELECT vc.*, s.* 
                             FROM verification_codes vc
                             JOIN students s ON vc.user_id = s.id
                             WHERE vc.user_id = ? 
                             AND vc.code = ? 
                             AND vc.expires_at > UTC_TIMESTAMP() 
                             AND vc.used_at IS NULL
                             ORDER BY vc.created_at DESC LIMIT 1");
        $stmt->bind_param("is", $_SESSION['2fa_user_id'], $code);
        $stmt->execute();
        $result = $stmt->get_result();
        
        // Debug logging
        error_log("Rows found: " . $result->num_rows);
        
        if ($result->num_rows === 1) {
            $row = $result->fetch_assoc();
            
            // Debug logging
            error_log("Code expires at: " . $row['expires_at']);
            error_log("Current UTC: " . date('Y-m-d H:i:s', time()));
            
            $update_stmt = $conn->prepare("UPDATE verification_codes SET used_at = UTC_TIMESTAMP() WHERE id = ?");
            $update_stmt->bind_param("i", $row['id']);
            
            if ($update_stmt->execute()) {
                // Regenerate session ID
                session_regenerate_id(true);
                
                // Set session variables
                $_SESSION['user_id'] = $row['id'];
                $_SESSION['student_id'] = $row['student_id'];
                $_SESSION['full_name'] = $row['full_name'];
                $_SESSION['email'] = $row['email'];
                $_SESSION['logged_in'] = true;
                $_SESSION['last_activity'] = time();

                // Remember me functionality
                if (isset($_SESSION['2fa_remember_me']) && $_SESSION['2fa_remember_me']) {
                    $token = bin2hex(random_bytes(32));
                    $expiry = date('Y-m-d H:i:s', strtotime('+30 days'));
                    
                    $stmt = $conn->prepare("INSERT INTO remember_tokens (user_id, token, expires_at) VALUES (?, ?, ?)");
                    $stmt->bind_param("iss", $row['id'], $token, $expiry);
                    $stmt->execute();
                    
                    setcookie('remember_token', $token, time() + (30 * 24 * 60 * 60), '/', '', true, true);
                }

                // Record login history
                $ip_address = $_SERVER['REMOTE_ADDR'] ?? 'Unknown';
                $device_info = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
                
                $login_stmt = $conn->prepare("INSERT INTO login_history (user_id, ip_address, device_info, login_time) VALUES (?, ?, ?, UTC_TIMESTAMP())");
                $login_stmt->bind_param("iss", $row['id'], $ip_address, $device_info);
                $login_stmt->execute();
                
                // Update last login
                $update_stmt = $conn->prepare("UPDATE students SET last_login = UTC_TIMESTAMP() WHERE id = ?");
                $update_stmt->bind_param("i", $row['id']);
                $update_stmt->execute();

                // Clear 2FA session
                unset($_SESSION['2fa_user_id']);
                unset($_SESSION['2fa_remember_me']);
                
                echo json_encode([
                    'success' => true,
                    'message' => 'Verification successful! Redirecting...',
                    'redirect' => 'index.php'
                ]);
                exit();
            } else {
                error_log("Update failed: " . $update_stmt->error);
                echo json_encode([
                    'success' => false,
                    'message' => 'System error during verification. Please try again.',
                    'clear_input' => false
                ]);
                exit();
            }
        } else {
            // Additional debugging for expired codes
            $debug_stmt = $conn->prepare("SELECT expires_at, used_at FROM verification_codes WHERE user_id = ? AND code = ? ORDER BY created_at DESC LIMIT 1");
            $debug_stmt->bind_param("is", $_SESSION['2fa_user_id'], $code);
            $debug_stmt->execute();
            $debug_result = $debug_stmt->get_result();
            
            if ($debug_result->num_rows === 1) {
                $debug_row = $debug_result->fetch_assoc();
                error_log("Found code but expired/used:");
                error_log("Expires at: " . $debug_row['expires_at']);
                error_log("Used at: " . ($debug_row['used_at'] ?? 'Not used'));
                error_log("Current UTC: " . date('Y-m-d H:i:s'));
            }
            
            echo json_encode([
                'success' => false,
                'message' => 'Invalid verification code or code has expired',
                'clear_input' => true
            ]);
            exit();
        }
    }
    
    // Resend code functionality
    if (isset($_POST['resend'])) {
        // Generate a new 6-digit verification code
        $verification_code = str_pad(mt_rand(0, 999999), 6, '0', STR_PAD_LEFT);
        $expires_at = gmdate('Y-m-d H:i:s', strtotime('+10 minutes')); // Use UTC time
        
        // Store the new code in the database
        $stmt = $conn->prepare("INSERT INTO verification_codes (user_id, code, expires_at) VALUES (?, ?, ?)");
        $stmt->bind_param("iss", $_SESSION['2fa_user_id'], $verification_code, $expires_at);
        
        if ($stmt->execute()) {
            // Get user details
            $user_stmt = $conn->prepare("SELECT full_name, email FROM students WHERE id = ?");
            $user_stmt->bind_param("i", $_SESSION['2fa_user_id']);
            $user_stmt->execute();
            $user_result = $user_stmt->get_result();
            $user = $user_result->fetch_assoc();
            
            // Send the new verification code via email
            $mail = new PHPMailer(true);
            try {
                // Server settings
                $mail->isSMTP();
                $mail->Host       = 'smtp.gmail.com';
                $mail->SMTPAuth   = true;
                $mail->Username   = 'olorodemicheal2274@gmail.com';
                $mail->Password   = 'farq ptyc vjtl eses';
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
                $mail->Port       = 465;
                $mail->CharSet    = 'UTF-8';
                
                // Recipients - Updated to Aletheia University
                $mail->setFrom('noreply@aletheia.edu', 'Aletheia University Campus Services');
                $mail->addAddress($user['email'], $user['full_name']);
                
                // Content
                $mail->isHTML(true);
                $mail->Subject = 'Your New Login Verification Code - Aletheia University';
                
                // HTML email body with Aletheia University branding
                $mail->Body = "
<!DOCTYPE html>
<html>
<head>
    <meta charset='UTF-8'>
    <title>New Verification Code - Aletheia University</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .university-header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #2C3E50;
        }
        .university-name {
            font-size: 28px;
            font-weight: bold;
            color: #2C3E50;
            margin: 0;
            letter-spacing: 1px;
        }
        .subtitle {
            font-size: 16px;
            color: #666;
            margin: 5px 0 0 0;
        }
        .greeting {
            color: #2C3E50;
            font-size: 18px;
            margin-top: 0;
        }
        .verification-code-container {
            text-align: center;
            margin: 30px 0;
            padding: 20px;
            background-color: #F8F9FA;
            border-radius: 5px;
        }
        .verification-code {
            font-size: 36px;
            font-weight: bold;
            color: #2C3E50;
            letter-spacing: 10px;
            font-family: 'Courier New', monospace;
            padding: 15px 0;
        }
        .code-label {
            font-size: 14px;
            color: #666;
            margin-bottom: 10px;
        }
        .instructions {
            background-color: #FFF8E1;
            padding: 15px;
            border-radius: 5px;
            margin: 25px 0;
            border-left: 4px solid #FBBB01;
        }
        .instructions p {
            margin: 8px 0;
            font-size: 14px;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            color: #777;
            font-size: 12px;
        }
        .highlight {
            color: #FBBB01;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class='container'>
        <div class='university-header'>
            <h1 class='university-name'>ALETHEIA UNIVERSITY</h1>
            <p class='subtitle'>Campus Services Login Verification</p>
        </div>
        
        <h2 class='greeting'>Hello {$user['full_name']},</h2>
        
        <p>As requested, here is your new login verification code for Aletheia University Campus Services:</p>
        
        <div class='verification-code-container'>
            <p class='code-label'>Your new verification code:</p>
            <div class='verification-code'>{$verification_code}</div>
        </div>
        
        <div class='instructions'>
           
            <p>• Enter this code on the verification page to complete your login</p>
        </div>
        
        <p>For security reasons, this code is required each time you log in from a new device or location.</p>
        
        <p>If you have any questions or need assistance, please contact the IT Help Desk.</p>
        
        <p>Best regards,<br>
        <strong>Aletheia University Campus Services</strong></p>
        
        <div class='footer'>
            <p>Aletheia University IT Services</p>
            <p>This is an automated message. Please do not reply to this email.</p>
            <p>© " . date('Y') . " Aletheia University. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
                ";
                
                // Plain text version
                $mail->AltBody = "ALETHEIA UNIVERSITY\nCampus Services Login Verification\n\n" .
                    "Hello {$user['full_name']},\n\n" .
                    "As requested, here is your new login verification code for Aletheia University Campus Services:\n\n" .
                    "Verification Code: {$verification_code}\n\n" .
                    "Important Information:\n" .
                    "• Enter this code on the verification page to complete your login\n" .
                    "• This code will expire in 10 minutes\n" .
                    "• Do not share this code with anyone\n" .
                    "• If you didn't request this code, please ignore this email or contact IT Help Desk\n\n" .
                    "For security reasons, this code is required each time you log in from a new device or location.\n\n" .
                    "If you have any questions or need assistance, please contact the IT Help Desk.\n\n" .
                    "Best regards,\n" .
                    "Aletheia University Campus Services\n\n" .
                    "This is an automated message. Please do not reply to this email.\n" .
                    "© " . date('Y') . " Aletheia University. All rights reserved.";
                
                if ($mail->send()) {
                    error_log("New verification code sent to: " . $user['email']);
                    echo json_encode([
                        'success' => true,
                        'message' => 'A new verification code has been sent to your email.'
                    ]);
                    exit();
                } else {
                    error_log("Failed to send email: " . $mail->ErrorInfo);
                    echo json_encode([
                        'success' => false,
                        'message' => 'Failed to send new verification code. Please try again later.'
                    ]);
                    exit();
                }
                
            } catch (Exception $e) {
                error_log("PHPMailer Exception: " . $e->getMessage());
                echo json_encode([
                    'success' => false,
                    'message' => 'Email service error. Please try again later.'
                ]);
                exit();
            }
        } else {
            error_log("Failed to insert verification code: " . $stmt->error);
            echo json_encode([
                'success' => false,
                'message' => 'Failed to generate verification code. Please try again.'
            ]);
            exit();
        }
    }
}

echo json_encode([
    'success' => false,
    'message' => 'Invalid request.'
]);
exit();
?>