<?php
// purchase_success.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once '../config/conn.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$student_id = $_SESSION['user_id'];

// Get reference from URL or session
$reference = isset($_GET['reference']) ? $_GET['reference'] : (isset($_SESSION['purchase_reference']) ? $_SESSION['purchase_reference'] : '');

if (empty($reference)) {
    header("Location: vendors.php");
    exit();
}

// Get transaction details
$transaction_query = "
    SELECT wt.*, v.business_name, v.business_type,
           po.product_name, po.quantity, po.unit_price, po.total_amount, 
           po.special_instructions, po.created_at as order_date,
           sw.balance as current_balance
    FROM wallet_transactions wt
    LEFT JOIN purchase_orders po ON wt.reference = po.reference
    LEFT JOIN vendors v ON po.vendor_id = v.id
    LEFT JOIN student_wallets sw ON wt.student_id = sw.student_id
    WHERE wt.reference = '$reference' AND wt.student_id = '$student_id'
";

$transaction_result = mysqli_query($conn, $transaction_query);
$transaction = mysqli_fetch_assoc($transaction_result);

if (!$transaction) {
    $basic_query = "SELECT * FROM wallet_transactions WHERE reference = '$reference' AND student_id = '$student_id'";
    $basic_result = mysqli_query($conn, $basic_query);
    $transaction = mysqli_fetch_assoc($basic_result);
    
    if (!$transaction) {
        die("Transaction not found");
    }
}

// Clear the session reference
unset($_SESSION['purchase_reference']);

// Handle PDF receipt download - MUST BE AT THE VERY TOP BEFORE ANY OUTPUT
if (isset($_POST['download_receipt'])) {
    // Check if TCPDF is available
    $tcpdf_available = false;
    
    // Try multiple possible paths for TCPDF
    $possible_paths = [
        '../../vendor/tecnickcom/tcpdf/tcpdf.php',
        '../vendor/tecnickcom/tcpdf/tcpdf.php',
        'vendor/tecnickcom/tcpdf/tcpdf.php',
        '../../tcpdf/tcpdf.php',
        '../tcpdf/tcpdf.php',
        'tcpdf/tcpdf.php',
        '../../TCPDF/tcpdf.php',
        '../TCPDF/tcpdf.php',
        'TCPDF/tcpdf.php'
    ];
    
    foreach ($possible_paths as $path) {
        if (file_exists($path)) {
            require_once $path;
            $tcpdf_available = true;
            break;
        }
    }
    
    // Also try using Composer autoload if available
    if (!$tcpdf_available && file_exists('../../vendor/autoload.php')) {
        require_once '../../vendor/autoload.php';
        if (class_exists('TCPDF')) {
            $tcpdf_available = true;
        }
    }
    
    if (!$tcpdf_available) {
        // TCPDF not found - provide HTML receipt as fallback
        header('Content-Type: text/html; charset=utf-8');
        echo '<!DOCTYPE html>
        <html>
        <head>
            <title>Receipt - ' . $transaction['reference'] . '</title>
            <style>
                body { font-family: Arial, sans-serif; padding: 20px; }
                .receipt { border: 1px solid #ccc; padding: 20px; max-width: 800px; margin: 0 auto; }
                h1 { color: #4CAF50; }
                .header { text-align: center; margin-bottom: 30px; }
                .section { margin-bottom: 20px; }
                .section-title { background-color: #f5f5f5; padding: 10px; font-weight: bold; }
                .info-row { display: flex; margin-bottom: 10px; }
                .info-label { width: 200px; font-weight: bold; }
                .total { font-size: 24px; font-weight: bold; color: #4CAF50; text-align: right; margin: 30px 0; }
                @media print {
                    button { display: none; }
                }
            </style>
        </head>
        <body>
            <div class="receipt">
                <div class="header">
                    <h1>ePay Transaction Receipt</h1>
                    <p>Reference: ' . htmlspecialchars($transaction['reference']) . '</p>
                    <p>Date: ' . date('F j, Y g:i A', strtotime($transaction['created_at'])) . '</p>
                </div>
                
                <div class="section">
                    <div class="section-title">Transaction Details</div>
                    <div class="info-row">
                        <div class="info-label">Transaction ID:</div>
                        <div>' . htmlspecialchars($transaction['reference']) . '</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Date & Time:</div>
                        <div>' . date('F j, Y g:i A', strtotime($transaction['created_at'])) . '</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Type:</div>
                        <div>' . ucfirst($transaction['transaction_type']) . '</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Status:</div>
                        <div style="color: green;">' . ucfirst($transaction['status']) . '</div>
                    </div>';
        
        if (isset($transaction['product_name']) && !empty($transaction['product_name'])) {
            echo '<div class="info-row">
                    <div class="info-label">Product:</div>
                    <div>' . htmlspecialchars($transaction['product_name']) . '</div>
                </div>';
        }
        
        if (isset($transaction['business_name']) && !empty($transaction['business_name'])) {
            echo '<div class="info-row">
                    <div class="info-label">Vendor:</div>
                    <div>' . htmlspecialchars($transaction['business_name']) . '</div>
                </div>';
        }
        
        echo '</div>
                <div class="total">
                    Total Amount: ₦' . number_format(abs($transaction['amount']), 2) . '
                </div>
                
                <div style="text-align: center; margin-top: 30px;">
                    <button onclick="window.print()" style="padding: 10px 20px; background-color: #4CAF50; color: white; border: none; cursor: pointer;">
                        Print Receipt
                    </button>
                    <button onclick="window.close()" style="padding: 10px 20px; background-color: #f44336; color: white; border: none; margin-left: 10px; cursor: pointer;">
                        Close
                    </button>
                </div>
            </div>
            <script>window.onload = function() { window.print(); }</script>
        </body>
        </html>';
        exit();
    }
    
    // Create new PDF document
    $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    
    // Set document information
    $pdf->SetCreator('ePay System');
    $pdf->SetAuthor('ePay');
    $pdf->SetTitle('Receipt - ' . $transaction['reference']);
    $pdf->SetSubject('Transaction Receipt');
    
    // Remove default header/footer
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);
    
    // Set margins
    $pdf->SetMargins(15, 15, 15);
    
    // Add a page
    $pdf->AddPage();
    
    // Set font
    $pdf->SetFont('helvetica', 'B', 16);
    
    // Title
    $pdf->SetTextColor(0, 102, 204);
    $pdf->Cell(0, 10, 'ePay - Transaction Receipt', 0, 1, 'C');
    $pdf->Ln(5);
    
    // Reference and Date
    $pdf->SetFont('helvetica', '', 10);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->Cell(0, 6, 'Reference: ' . $transaction['reference'], 0, 1);
    $pdf->Cell(0, 6, 'Date: ' . date('F j, Y', strtotime($transaction['created_at'])), 0, 1);
    $pdf->Cell(0, 6, 'Time: ' . date('g:i A', strtotime($transaction['created_at'])), 0, 1);
    $pdf->Ln(5);
    
    // Transaction Details
    $pdf->SetFont('helvetica', 'B', 12);
    $pdf->SetFillColor(240, 240, 240);
    $pdf->Cell(0, 8, 'TRANSACTION DETAILS', 0, 1, 'L', true);
    $pdf->Ln(2);
    
    $pdf->SetFont('helvetica', '', 10);
    $data = array();
    
    if (isset($transaction['product_name']) && !empty($transaction['product_name'])) {
        $data[] = array('Product:', $transaction['product_name']);
    }
    
    if (isset($transaction['business_name']) && !empty($transaction['business_name'])) {
        $data[] = array('Vendor:', $transaction['business_name']);
        $data[] = array('Business Type:', $transaction['business_type']);
    }
    
    if (isset($transaction['quantity']) && !empty($transaction['quantity'])) {
        $data[] = array('Quantity:', $transaction['quantity']);
    }
    
    if (isset($transaction['unit_price']) && !empty($transaction['unit_price'])) {
        $data[] = array('Unit Price:', '₦' . number_format($transaction['unit_price'], 2));
    }
    
    foreach ($data as $row) {
        $pdf->Cell(40, 6, $row[0], 0, 0);
        $pdf->Cell(0, 6, $row[1], 0, 1);
    }
    
    $pdf->Ln(3);
    
    // Total Amount
    $pdf->SetFont('helvetica', 'B', 12);
    $pdf->SetTextColor(0, 128, 0);
    $pdf->Cell(40, 8, 'Total Amount:', 0, 0);
    $pdf->Cell(0, 8, '₦' . number_format(abs($transaction['amount']), 2), 0, 1);
    $pdf->Ln(5);
    
    // Transaction Info
    $pdf->SetFont('helvetica', 'B', 12);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetFillColor(240, 240, 240);
    $pdf->Cell(0, 8, 'TRANSACTION INFORMATION', 0, 1, 'L', true);
    $pdf->Ln(2);
    
    $pdf->SetFont('helvetica', '', 10);
    $pdf->Cell(40, 6, 'Transaction Type:', 0, 0);
    $pdf->Cell(0, 6, ucfirst($transaction['transaction_type']), 0, 1);
    
    $pdf->Cell(40, 6, 'Status:', 0, 0);
    $pdf->SetTextColor(0, 128, 0);
    $pdf->Cell(0, 6, ucfirst($transaction['status']), 0, 1);
    $pdf->SetTextColor(0, 0, 0);
    
    $pdf->Cell(40, 6, 'Date:', 0, 0);
    $pdf->Cell(0, 6, date('F j, Y', strtotime($transaction['created_at'])), 0, 1);
    
    $pdf->Cell(40, 6, 'Time:', 0, 0);
    $pdf->Cell(0, 6, date('g:i A', strtotime($transaction['created_at'])), 0, 1);
    $pdf->Ln(5);
    
    // Special Instructions
    if (isset($transaction['special_instructions']) && !empty($transaction['special_instructions'])) {
        $pdf->SetFont('helvetica', 'B', 12);
        $pdf->SetFillColor(240, 240, 240);
        $pdf->Cell(0, 8, 'SPECIAL INSTRUCTIONS', 0, 1, 'L', true);
        $pdf->Ln(2);
        
        $pdf->SetFont('helvetica', '', 10);
        $pdf->MultiCell(0, 6, $transaction['special_instructions'], 0, 'L');
        $pdf->Ln(5);
    }
    
    // Footer
    $pdf->SetY(-30);
    $pdf->SetFont('helvetica', 'I', 8);
    $pdf->SetTextColor(128, 128, 128);
    $pdf->Cell(0, 6, 'Thank you for using ePay!', 0, 1, 'C');
    $pdf->Cell(0, 6, 'This is an automated receipt.', 0, 1, 'C');
    $pdf->Cell(0, 6, 'Generated on: ' . date('Y-m-d H:i:s'), 0, 1, 'C');
    
    // Output PDF - NO OUTPUT BEFORE THIS!
    $filename = 'receipt-' . $transaction['reference'] . '.pdf';
    $pdf->Output($filename, 'D'); // 'D' for download
    
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Successful - ePay</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .rounded-xl {
            border-radius: 12px;
        }
    </style>
</head>
<body class="bg-gray-50 dark:bg-gray-900">
    <?php include 'include/header.php'; ?>

    <main class="main-content flex-1 p-6 overflow-y-auto">
        <div class="max-w-4xl mx-auto">
            <!-- Success Header -->
            <div class="text-center mb-8">
                <div class="relative inline-block">
                    <div class="w-24 h-24 bg-gradient-to-r from-green-400 to-green-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-check text-white text-4xl"></i>
                    </div>
                    <div class="absolute -top-2 -right-2 w-8 h-8 bg-yellow-400 rounded-full flex items-center justify-center">
                        <i class="fas fa-star text-white text-xs"></i>
                    </div>
                </div>
                <h1 class="text-4xl font-bold text-gray-900 dark:text-white mb-3">
                    Payment Successful!
                </h1>
                <p class="text-lg text-gray-600 dark:text-gray-400 mb-2">Your transaction has been completed successfully</p>
                <div class="inline-flex items-center bg-green-100 dark:bg-green-900 text-green-800 dark:text-green-200 px-4 py-2 rounded-lg text-sm font-medium">
                    <i class="fas fa-shield-check mr-2"></i>
                    Secured Transaction • Instant Confirmation
                </div>
            </div>

            <div class="grid lg:grid-cols-3 gap-6 mb-8">
                <!-- Main Transaction Card -->
                <div class="lg:col-span-2">
                    <div class="bg-white dark:bg-gray-800 rounded-xl overflow-hidden border border-green-100 dark:border-gray-700">
                        <div class="bg-gradient-to-r from-green-500 to-green-600 px-6 py-5">
                            <div class="flex justify-between items-center">
                                <h2 class="text-xl font-bold text-white">Order Confirmation</h2>
                                <div class="bg-white bg-opacity-20 px-3 py-1 rounded-lg">
                                    <span class="text-white text-sm font-semibold">COMPLETED</span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="p-6">
                            <!-- Reference & Date -->
                            <div class="grid md:grid-cols-2 gap-4 mb-6 pb-6 border-b dark:border-gray-700">
                                <div>
                                    <label class="text-sm font-medium text-gray-500 dark:text-gray-400 block mb-1">Reference Number</label>
                                    <div class="font-mono font-bold text-gray-900 dark:text-white text-lg bg-gray-50 dark:bg-gray-700 px-3 py-2 rounded-lg">
                                        <?= htmlspecialchars($transaction['reference']) ?>
                                    </div>
                                </div>
                                <div>
                                    <label class="text-sm font-medium text-gray-500 dark:text-gray-400 block mb-1">Transaction Date & Time</label>
                                    <div class="font-semibold text-gray-900 dark:text-white">
                                        <div class="text-lg"><?= date('F j, Y', strtotime($transaction['created_at'])) ?></div>
                                        <div class="text-sm text-gray-600 dark:text-gray-400"><?= date('g:i A', strtotime($transaction['created_at'])) ?></div>
                                    </div>
                                </div>
                            </div>

                            <!-- Order Details -->
                            <div class="space-y-4 mb-6">
                                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4 flex items-center">
                                    <i class="fas fa-shopping-bag mr-2 text-green-500"></i>
                                    Order Details
                                </h3>
                                
                                <?php if (isset($transaction['product_name']) && !empty($transaction['product_name'])): ?>
                                <div class="flex justify-between items-center p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                                    <div>
                                        <span class="text-gray-600 dark:text-gray-400 block text-sm">Product</span>
                                        <span class="font-semibold text-gray-900 dark:text-white"><?= htmlspecialchars($transaction['product_name']) ?></span>
                                    </div>
                                    <div class="text-right">
                                        <span class="text-gray-600 dark:text-gray-400 block text-sm">Qty</span>
                                        <span class="font-semibold text-gray-900 dark:text-white"><?= htmlspecialchars($transaction['quantity']) ?></span>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <?php if (isset($transaction['business_name']) && !empty($transaction['business_name'])): ?>
                                <div class="flex justify-between items-center p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                                    <div>
                                        <span class="text-gray-600 dark:text-gray-400 block text-sm">Vendor</span>
                                        <span class="font-semibold text-gray-900 dark:text-white"><?= htmlspecialchars($transaction['business_name']) ?></span>
                                    </div>
                                    <span class="text-sm text-gray-500 dark:text-gray-400"><?= htmlspecialchars($transaction['business_type']) ?></span>
                                </div>
                                <?php endif; ?>

                                <?php if (isset($transaction['unit_price']) && !empty($transaction['unit_price'])): ?>
                                <div class="flex justify-between items-center p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                                    <div>
                                        <span class="text-gray-600 dark:text-gray-400 block text-sm">Unit Price</span>
                                        <span class="font-semibold text-gray-900 dark:text-white">₦<?= number_format($transaction['unit_price'], 2) ?></span>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <div class="bg-gradient-to-r from-green-50 to-blue-50 dark:from-gray-700 dark:to-gray-600 p-4 rounded-lg border border-green-200 dark:border-green-800">
                                    <div class="flex justify-between items-center">
                                        <span class="text-lg font-bold text-gray-900 dark:text-white">Total Amount</span>
                                        <span class="text-2xl font-bold text-green-600">₦<?= number_format(abs($transaction['amount']), 2) ?></span>
                                    </div>
                                </div>
                            </div>

                            <!-- Receipt Preview -->
                            <div class="mb-6">
                                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4 flex items-center">
                                    <i class="fas fa-receipt mr-2 text-blue-500"></i>
                                    Receipt Preview
                                </h3>
                                <div class="receipt-preview text-center">
                                    <div class="mb-4">
                                        <i class="fas fa-file-pdf text-red-500 text-4xl mb-2"></i>
                                        <h4 class="font-semibold text-gray-900 dark:text-white">PDF Receipt Ready</h4>
                                        <p class="text-gray-600 dark:text-gray-400 text-sm">Download professional PDF receipt</p>
                                    </div>
                                    <div class="text-xs text-gray-500 space-y-1">
                                        <div>Reference: <?= htmlspecialchars($transaction['reference']) ?></div>
                                        <div>Date: <?= date('F j, Y', strtotime($transaction['created_at'])) ?></div>
                                        <div>Amount: ₦<?= number_format(abs($transaction['amount']), 2) ?></div>
                                    </div>
                                </div>
                            </div>

                            <?php if (isset($transaction['special_instructions']) && !empty($transaction['special_instructions'])): ?>
                            <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-xl p-4">
                                <h3 class="font-semibold text-blue-800 dark:text-blue-300 mb-2 flex items-center">
                                    <i class="fas fa-info-circle mr-2"></i>
                                    Special Instructions
                                </h3>
                                <p class="text-blue-700 dark:text-blue-400"><?= htmlspecialchars($transaction['special_instructions']) ?></p>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="space-y-6">
                    <!-- Quick Actions -->
                    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Quick Actions</h3>
                        <div class="space-y-3">
                            <form method="POST" class="w-full">
                                <button type="submit" name="download_receipt" 
                                        class="w-full flex items-center justify-center px-4 py-3 bg-red-500 text-white rounded-xl hover:bg-red-600 focus:outline-none focus:ring-2 focus:ring-red-500 font-semibold">
                                    <i class="fas fa-file-pdf mr-2"></i>
                                    Download PDF Receipt
                                </button>
                            </form>
                            
                            <a href="vendors.php" 
                               class="w-full flex items-center justify-center px-4 py-3 bg-yellow-500 text-white rounded-xl hover:bg-yellow-600 focus:outline-none focus:ring-2 focus:ring-yellow-500 font-semibold">
                                <i class="fas fa-store mr-2"></i>
                                Continue Shopping
                            </a>
                            
                            <a href="transaction_history.php" 
                               class="w-full flex items-center justify-center px-4 py-3 bg-blue-500 text-white rounded-xl hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-500 font-semibold">
                                <i class="fas fa-history mr-2"></i>
                                View History
                            </a>
                        </div>
                    </div>

                    <!-- Vendor Info -->
                    <?php if (isset($transaction['business_name'])): ?>
                    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4 flex items-center">
                            <i class="fas fa-store mr-2 text-purple-500"></i>
                            Vendor Information
                        </h3>
                        <div class="space-y-3">
                            <div class="flex items-center p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                                <i class="fas fa-building text-gray-400 mr-3"></i>
                                <div>
                                    <div class="font-semibold text-gray-900 dark:text-white"><?= htmlspecialchars($transaction['business_name']) ?></div>
                                    <div class="text-sm text-gray-600 dark:text-gray-400"><?= htmlspecialchars($transaction['business_type']) ?></div>
                                </div>
                            </div>
                            <div class="flex items-center p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                                <i class="fas fa-info-circle text-gray-400 mr-3"></i>
                                <div class="text-sm">
                                    <div class="text-gray-600 dark:text-gray-400">Status</div>
                                    <div class="font-medium text-green-600">Verified Vendor</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Transaction Summary -->
                    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4 flex items-center">
                            <i class="fas fa-receipt mr-2 text-orange-500"></i>
                            Transaction Summary
                        </h3>
                        <div class="space-y-2 text-sm">
                            <div class="flex justify-between">
                                <span class="text-gray-600 dark:text-gray-400">Transaction ID:</span>
                                <span class="font-mono text-gray-900 dark:text-white"><?= substr($transaction['reference'], 0, 12) ?>...</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600 dark:text-gray-400">Type:</span>
                                <span class="font-medium capitalize text-gray-900 dark:text-white"><?= htmlspecialchars($transaction['transaction_type']) ?></span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600 dark:text-gray-400">Status:</span>
                                <span class="font-medium text-green-600 capitalize"><?= htmlspecialchars($transaction['status']) ?></span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600 dark:text-gray-400">Date:</span>
                                <span class="font-medium text-gray-900 dark:text-white"><?= date('M j, Y', strtotime($transaction['created_at'])) ?></span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600 dark:text-gray-400">Time:</span>
                                <span class="font-medium text-gray-900 dark:text-white"><?= date('g:i A', strtotime($transaction['created_at'])) ?></span>
                            </div>
                        </div>
                    </div>

                    <!-- Support Card -->
                    <div class="bg-gradient-to-r from-yellow-50 to-orange-50 dark:from-yellow-900/20 dark:to-orange-900/20 rounded-xl p-6 border border-yellow-200 dark:border-yellow-800">
                        <div class="flex items-start">
                            <i class="fas fa-life-ring text-yellow-500 text-xl mr-3 mt-1"></i>
                            <div>
                                <h3 class="font-semibold text-yellow-800 dark:text-yellow-300 mb-2">Need Help?</h3>
                                <p class="text-yellow-700 dark:text-yellow-400 text-sm mb-3">
                                    Contact our support team for any issues with your order.
                                </p>
                                <a href="support.php" class="inline-flex items-center text-yellow-600 dark:text-yellow-400 hover:text-yellow-800 dark:hover:text-yellow-300 text-sm font-medium">
                                    Contact Support
                                    <i class="fas fa-arrow-right ml-1 text-xs"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Next Steps -->
            <div class="bg-white dark:bg-gray-800 rounded-xl p-6 mb-8 border border-gray-100 dark:border-gray-700">
                <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4 text-center">What's Next?</h3>
                <div class="grid md:grid-cols-3 gap-6 text-center">
                    <div class="p-4">
                        <div class="w-12 h-12 bg-blue-100 dark:bg-blue-900 rounded-full flex items-center justify-center mx-auto mb-3">
                            <i class="fas fa-file-pdf text-blue-500 text-xl"></i>
                        </div>
                        <h4 class="font-semibold text-gray-900 dark:text-white mb-2">Download Receipt</h4>
                        <p class="text-gray-600 dark:text-gray-400 text-sm">Get your professional PDF receipt</p>
                    </div>
                    <div class="p-4">
                        <div class="w-12 h-12 bg-green-100 dark:bg-green-900 rounded-full flex items-center justify-center mx-auto mb-3">
                            <i class="fas fa-box text-green-500 text-xl"></i>
                        </div>
                        <h4 class="font-semibold text-gray-900 dark:text-white mb-2">Collect Items</h4>
                        <p class="text-gray-600 dark:text-gray-400 text-sm">Visit vendor to collect your purchase</p>
                    </div>
                    <div class="p-4">
                        <div class="w-12 h-12 bg-purple-100 dark:bg-purple-900 rounded-full flex items-center justify-center mx-auto mb-3">
                            <i class="fas fa-star text-purple-500 text-xl"></i>
                        </div>
                        <h4 class="font-semibold text-gray-900 dark:text-white mb-2">Rate Experience</h4>
                        <p class="text-gray-600 dark:text-gray-400 text-sm">Share feedback about your purchase</p>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Auto-scroll to top
        window.scrollTo({ top: 0, behavior: 'smooth' });
    });
    </script>

    <?php include 'include/footer.php'; ?>
</body>
</html>