<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
require '../config/conn.php';

$errors = [
    'full_name' => '',
    'email' => '',
    'password' => '',
    'confirm_password' => '',
    'terms' => ''
];

$form_data = isset($_SESSION['form_data']) ? $_SESSION['form_data'] : [];
$full_name = $form_data['full_name'] ?? '';
$email = $form_data['email'] ?? '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Campus Services - Register</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body { font-family: 'Poppins', sans-serif; }
    </style>
</head>
<body class=" bg-gray-100 flex items-center justify-center p-4">
    <div class="w-full max-w-sm">
        <!-- Logo and Header -->
        <div class="text-center mb-6">
            <div class="w-16 h-16 mx-auto mb-3 flex items-center justify-center">
                <img src="../img/schools.png" alt="School Logo" class="max-w-full max-h-full">
            </div>
            <h1 class="text-xl font-bold text-gray-800">Campus Services</h1>
            <p class="text-gray-500 text-sm mt-1">Student Registration</p>
        </div>

        <!-- Messages -->
        <div id="messageContainer" class="mb-4"></div>

        <?php 
        if (isset($_SESSION['success_message'])) {
            echo '<div class="bg-green-50 border border-green-200 p-3 mb-4 text-green-700 text-sm rounded-lg">' . $_SESSION['success_message'] . '</div>';
            unset($_SESSION['success_message']);
        }
        
        if (isset($_SESSION['error_messages'])) {
            foreach ($_SESSION['error_messages'] as $error) {
                echo '<div class="bg-red-50 border border-red-200 p-3 mb-4 text-red-700 text-sm rounded-lg">' . $error . '</div>';
            }
            unset($_SESSION['error_messages']);
        }
        ?>

        <!-- Registration Form -->
        <div class="bg-white  p-6">
            <form id="registerForm" method="POST">
                <!-- Full Name -->
                <div class="mb-4">
                    <label class="block text-gray-700 text-sm font-medium mb-1">Full Name</label>
                    <div class="relative">
                        <i class="fas fa-user absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400 text-sm"></i>
                        <input type="text" name="full_name" 
                               value="<?php echo htmlspecialchars($full_name); ?>"
                               class="w-full pl-9 pr-3 py-2 text-sm border border-gray-300 rounded-lg focus:outline-none focus:ring-1 focus:ring-[#fbbb01] focus:border-[#fbbb01]"
                               placeholder="Your full name" 
                               required>
                    </div>
                    <small class="text-red-500 text-xs mt-1 block" id="full_name_error"><?php echo $errors['full_name']; ?></small>
                </div>
                
                <!-- Email -->
                <div class="mb-4">
                    <label class="block text-gray-700 text-sm font-medium mb-1">Email</label>
                    <div class="relative">
                        <i class="fas fa-envelope absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400 text-sm"></i>
                        <input type="email" name="email" 
                               value="<?php echo htmlspecialchars($email); ?>"
                               class="w-full pl-9 pr-3 py-2 text-sm border border-gray-300 rounded-lg focus:outline-none focus:ring-1 focus:ring-[#fbbb01] focus:border-[#fbbb01]"
                               placeholder="school@email.com" 
                               required>
                    </div>
                    <small class="text-red-500 text-xs mt-1 block" id="email_error"><?php echo $errors['email']; ?></small>
                </div>
                
                <!-- Password -->
                <div class="mb-4">
                    <label class="block text-gray-700 text-sm font-medium mb-1">Password</label>
                    <div class="relative">
                        <i class="fas fa-lock absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400 text-sm"></i>
                        <input type="password" id="password" name="password" 
                               class="w-full pl-9 pr-9 py-2 text-sm border border-gray-300 rounded-lg focus:outline-none focus:ring-1 focus:ring-[#fbbb01] focus:border-[#fbbb01]"
                               placeholder="••••••••" 
                               required>
                        <i class="fas fa-eye absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400 cursor-pointer text-sm" 
                           onclick="togglePassword('password', this)"></i>
                    </div>
                    <small class="text-red-500 text-xs mt-1 block" id="password_error"><?php echo $errors['password']; ?></small>
                </div>
                
                <!-- Confirm Password -->
                <div class="mb-5">
                    <label class="block text-gray-700 text-sm font-medium mb-1">Confirm Password</label>
                    <div class="relative">
                        <i class="fas fa-lock absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400 text-sm"></i>
                        <input type="password" id="confirm_password" name="confirm_password" 
                               class="w-full pl-9 pr-9 py-2 text-sm border border-gray-300 rounded-lg focus:outline-none focus:ring-1 focus:ring-[#fbbb01] focus:border-[#fbbb01]"
                               placeholder="••••••••" 
                               required>
                        <i class="fas fa-eye absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400 cursor-pointer text-sm" 
                           onclick="togglePassword('confirm_password', this)"></i>
                    </div>
                    <small class="text-red-500 text-xs mt-1 block" id="confirm_password_error"><?php echo $errors['confirm_password']; ?></small>
                </div>
                
                <!-- Terms -->
                <div class="mb-5">
                    <div class="flex items-start">
                        <input type="checkbox" id="acceptTerms" name="accept_terms" required 
                               class="mt-0.5 mr-2 w-4 h-4 text-[#fbbb01] border-gray-300 rounded focus:ring-[#fbbb01]">
                        <label for="acceptTerms" class="text-gray-700 text-xs">
                            I agree to <a href="#" class="text-[#fbbb01] hover:underline">Terms</a> & <a href="#" class="text-[#fbbb01] hover:underline">Privacy</a>
                        </label>
                    </div>
                    <small class="text-red-500 text-xs mt-1 block" id="terms_error"><?php echo $errors['terms']; ?></small>
                </div>
                
                <!-- Submit Button -->
                <button type="submit" id="submitBtn" 
                        class="w-full py-2.5 bg-[#fbbb01] text-white text-sm font-medium rounded-lg hover:bg-[#e0a800] transition disabled:opacity-70 disabled:cursor-not-allowed">
                    <span id="btnText">Create Account</span>
                    <span id="loadingSpinner" class="hidden ml-2">
                        <i class="fas fa-spinner fa-spin"></i>
                    </span>
                </button>
                
                <!-- Login Link -->
                <div class="text-center mt-4">
                    <p class="text-gray-500 text-xs">
                        Have an account? 
                        <a href="login.php" class="text-[#fbbb01] hover:text-[#e0a800] font-medium">Login</a>
                    </p>
                </div>
            </form>
        </div>
    </div>

    <script>
    function togglePassword(inputId, icon) {
        const input = document.getElementById(inputId);
        if (input.type === 'password') {
            input.type = 'text';
            icon.classList.replace('fa-eye', 'fa-eye-slash');
        } else {
            input.type = 'password';
            icon.classList.replace('fa-eye-slash', 'fa-eye');
        }
    }

    function showMessage(message, type) {
        const container = document.getElementById('messageContainer');
        const colors = {
            success: 'bg-green-50 text-green-700 border border-green-200',
            error: 'bg-red-50 text-red-700 border border-red-200',
            info: 'bg-blue-50 text-blue-700 border border-blue-200'
        };
        
        const div = document.createElement('div');
        div.className = `p-3 rounded-lg text-sm mb-3 ${colors[type] || colors.info}`;
        div.innerHTML = `
            <div class="flex items-center">
                <i class="fas ${type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle'} mr-2"></i>
                <span>${message}</span>
            </div>
        `;
        
        container.prepend(div);
        setTimeout(() => div.remove(), 4000);
    }

    document.getElementById('registerForm').addEventListener('submit', async function(e) {
        e.preventDefault();
        
        const btn = document.getElementById('submitBtn');
        const btnText = document.getElementById('btnText');
        const spinner = document.getElementById('loadingSpinner');
        
        btn.disabled = true;
        btnText.textContent = 'Creating...';
        spinner.classList.remove('hidden');
        
        // Clear messages
        document.getElementById('messageContainer').innerHTML = '';
        document.querySelectorAll('[id$="_error"]').forEach(el => el.textContent = '');
        
        try {
            const formData = new FormData(this);
            const response = await fetch('process_register.php', {
                method: 'POST',
                body: formData
            });
            
            const data = await response.json();
            
            btn.disabled = false;
            btnText.textContent = 'Create Account';
            spinner.classList.add('hidden');
            
            if (data.success) {
                showMessage(data.message, 'success');
                this.reset();
                setTimeout(() => {
                    window.location.href = 'login.php';
                }, 1500);
            } else {
                if (data.message) showMessage(data.message, 'error');
                if (data.errors) {
                    for (const field in data.errors) {
                        const el = document.getElementById(field + '_error');
                        if (el) el.textContent = data.errors[field];
                    }
                }
            }
        } catch (error) {
            btn.disabled = false;
            btnText.textContent = 'Create Account';
            spinner.classList.add('hidden');
            showMessage('Network error. Try again.', 'error');
        }
    });

    document.addEventListener('DOMContentLoaded', function() {
        document.querySelector('input[name="full_name"]').focus();
    });
    </script>
</body>
</html>

<?php
if (isset($_SESSION['form_data'])) {
    unset($_SESSION['form_data']);
}
?>