<?php
// support.php
 // Add this at the top of your config/auth_check.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once '../config/conn.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Support - ePay</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-gray-50 dark:bg-gray-900">
    <?php include 'include/header.php'; ?>

    <main class="main-content flex-1 p-6 dark:bg-gray-900 overflow-y-auto">
        <div class="max-w-4xl mx-auto">
            <div class="mb-8">
                <h1 class="text-3xl font-bold text-gray-900 dark:text-white mb-2">Support Center</h1>
                <p class="text-gray-600 dark:text-gray-400">Get help with your transactions and wallet</p>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <!-- Contact Information -->
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                    <h2 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Contact Information</h2>
                    <div class="space-y-4">
                        <div class="flex items-center">
                            <i class="fas fa-phone text-yellow-500 mr-3"></i>
                            <div>
                                <p class="font-medium text-gray-900 dark:text-white">Phone Support</p>
                                <p class="text-gray-600 dark:text-gray-400">+234 800 123 4567</p>
                            </div>
                        </div>
                        <div class="flex items-center">
                            <i class="fas fa-envelope text-yellow-500 mr-3"></i>
                            <div>
                                <p class="font-medium text-gray-900 dark:text-white">Email Support</p>
                                <p class="text-gray-600 dark:text-gray-400">support@epay.com</p>
                            </div>
                        </div>
                        <div class="flex items-center">
                            <i class="fas fa-clock text-yellow-500 mr-3"></i>
                            <div>
                                <p class="font-medium text-gray-900 dark:text-white">Support Hours</p>
                                <p class="text-gray-600 dark:text-gray-400">Mon - Fri: 8:00 AM - 6:00 PM</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Common Issues -->
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                    <h2 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Common Issues</h2>
                    <div class="space-y-3">
                        <details class="border border-gray-200 dark:border-gray-700 rounded-lg">
                            <summary class="p-3 cursor-pointer font-medium">Failed Transaction</summary>
                            <div class="p-3 border-t border-gray-200 dark:border-gray-700 text-sm text-gray-600 dark:text-gray-400">
                                If a transaction fails, funds are automatically returned to your wallet within 24 hours.
                            </div>
                        </details>
                        <details class="border border-gray-200 dark:border-gray-700 rounded-lg">
                            <summary class="p-3 cursor-pointer font-medium">Forgot PIN</summary>
                            <div class="p-3 border-t border-gray-200 dark:border-gray-700 text-sm text-gray-600 dark:text-gray-400">
                                Contact support to reset your wallet PIN. You'll need to verify your identity.
                            </div>
                        </details>
                        <details class="border border-gray-200 dark:border-gray-700 rounded-lg">
                            <summary class="p-3 cursor-pointer font-medium">Vendor Issues</summary>
                            <div class="p-3 border-t border-gray-200 dark:border-gray-700 text-sm text-gray-600 dark:text-gray-400">
                                For issues with vendors, contact the vendor directly first, then reach out to us if unresolved.
                            </div>
                        </details>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <?php include 'include/footer.php'; ?>
</body>
</html>