<?php
include 'include/header.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

require_once '../config/conn.php';

$student_id = $_SESSION['user_id'];

// Get vendor ID
if (!isset($_GET['vendor_id']) || empty($_GET['vendor_id'])) {
    die("Vendor ID is required");
}

$vendor_id = intval($_GET['vendor_id']);

// Get vendor details
$vendor_query = "SELECT * FROM vendors WHERE id = '$vendor_id'";
$vendor_result = mysqli_query($conn, $vendor_query);
$vendor = mysqli_fetch_assoc($vendor_result);

if (!$vendor) {
    die("Vendor not found");
}

// Get student wallet
$wallet_query = "SELECT * FROM student_wallets WHERE student_id = '$student_id'";
$wallet_result = mysqli_query($conn, $wallet_query);
$student_wallet = mysqli_fetch_assoc($wallet_result);

// Search
$search = isset($_GET['search']) ? trim(mysqli_real_escape_string($conn, $_GET['search'])) : '';

if (!empty($search)) {
    $products_query = "SELECT * FROM products WHERE vendor_id = '$vendor_id' AND stock_status = 'in_stock' 
                       AND (name LIKE '%$search%' OR description LIKE '%$search%') 
                       ORDER BY created_at DESC";
} else {
    $products_query = "SELECT * FROM products WHERE vendor_id = '$vendor_id' AND stock_status = 'in_stock' 
                       ORDER BY created_at DESC";
}

$products_result = mysqli_query($conn, $products_query);
?>

<div class="max-w-6xl mx-auto p-4 mb-6">
    <!-- Back Button -->
    <div class="mb-4">
        <a href="vendors.php" class="inline-flex items-center text-[#fbbb01] hover:text-[#e0a800] text-sm">
            <i class="fas fa-arrow-left mr-1"></i> Back to Vendors
        </a>
    </div>

    <!-- Vendor Info -->
    <div class=" p-4 mb-4">
        <div class="flex items-center mb-3">
            <div class="w-12 h-12 rounded-full bg-gray-100 flex items-center justify-center mr-3">
                <i class="fas fa-store text-gray-500"></i>
            </div>
            <div class="flex-1">
                <h1 class="text-lg font-bold text-gray-800"><?= htmlspecialchars($vendor['business_name']) ?></h1>
                <p class="text-gray-500 text-sm"><?= htmlspecialchars($vendor['business_type']) ?></p>
            </div>
        </div>
        
        <!-- Wallet Balance -->
        <?php if ($student_wallet): ?>
        <div class="bg-blue-50 border border-blue-200 rounded-lg p-3">
            <div class="flex items-center">
                <i class="fas fa-wallet text-blue-500 mr-2"></i>
                <div>
                    <p class="text-xs text-blue-700">Your Balance</p>
                    <p class="text-blue-800 font-medium">
                        ₦<?= number_format($student_wallet['balance'] ?? 0, 2) ?>
                    </p>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Search -->
    <div class=" p-4 mb-4">
        <div class="mb-2">
            <h2 class="text-base font-semibold text-gray-800">Available Products</h2>
            <p class="text-gray-500 text-sm">Browse products from this vendor</p>
        </div>
        
        <div class="relative">
            <i class="fas fa-search absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400 text-sm"></i>
            <input type="text" id="searchInput" value="<?= htmlspecialchars($search) ?>"
                   placeholder="Search products..."
                   class="w-full pl-9 pr-9 py-2 text-sm border border-gray-300 rounded-lg focus:outline-none focus:ring-1 focus:ring-[#fbbb01] focus:border-[#fbbb01]">
            <div id="searchLoading" class="absolute right-3 top-1/2 transform -translate-y-1/2 hidden">
                <div class="w-4 h-4 border-2 border-[#fbbb01] border-t-transparent rounded-full animate-spin"></div>
            </div>
        </div>
        
        <button id="clearSearchBtn" 
                class="mt-2 text-[#fbbb01] hover:text-[#e0a800] text-xs font-medium <?= empty($search) ? 'hidden' : '' ?>">
            <i class="fas fa-times mr-1"></i> Clear search
        </button>
    </div>

    <!-- Products Container -->
    <div id="productsContainer">
        <?php if ($products_result && mysqli_num_rows($products_result) > 0): 
            $product_count = mysqli_num_rows($products_result);
        ?>
        <!-- Products Grid -->
        <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-3" id="productsGrid">
            <?php while ($product = mysqli_fetch_assoc($products_result)): 
                // Truncate product name for mobile
                $display_name = strlen($product['name']) > 20 
                    ? substr($product['name'], 0, 20) . '...' 
                    : $product['name'];
            ?>
            <div class=" overflow-hidden  transition">
                <!-- Product Image -->
                <div class="h-36 bg-gray-100 relative">
                    <?php if (!empty($product['image_path'])): 
                        $image_path = strpos($product['image_path'], 'http') === 0 
                            ? $product['image_path'] 
                            : '../' . ltrim($product['image_path'], './');
                    ?>
                        <img src="<?= htmlspecialchars($image_path) ?>" 
                             alt="<?= htmlspecialchars($product['name']) ?>"
                             class="w-full h-full object-cover"
                             onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                    <?php endif; ?>
                    <div class="w-full h-full flex items-center justify-center bg-gray-100 <?= !empty($product['image_path']) ? 'hidden' : '' ?>">
                        <i class="fas fa-box text-3xl text-gray-300"></i>
                    </div>
                    
                    <!-- Stock Badge -->
                    <span class="absolute top-2 right-2 px-2 py-1 text-xs font-medium rounded-full bg-green-100 text-green-800">
                        In Stock
                    </span>
                </div>
                
                <!-- Product Details -->
                <div class="p-3">
                    <h3 class="text-sm font-medium text-gray-800 mb-1 truncate" title="<?= htmlspecialchars($product['name']) ?>">
                        <?= htmlspecialchars($display_name) ?>
                    </h3>
                    
                  
                    
                    <!-- Price and Buy Button -->
                    <div class="flex items-center justify-between">
                        <span class="text-base font-bold text-[#fbbb01]">
                            ₦<?= number_format($product['price'], 2) ?>
                        </span>
                        
                        <a href="buy-product.php?vendor_id=<?= $vendor_id ?>&product_id=<?= $product['id'] ?>" 
                           class="bg-[#fbbb01] hover:bg-[#e0a800] text-white text-xs font-medium py-1.5 px-3 rounded transition">
                            <i class="fas fa-shopping-cart mr-1"></i> Buy
                        </a>
                    </div>
                </div>
            </div>
            <?php endwhile; ?>
        </div>

        <!-- Product Count -->
        <div class="mt-4 text-center text-gray-500 text-sm">
            <p id="productCount">Showing <?= $product_count ?> product<?= $product_count > 1 ? 's' : '' ?></p>
        </div>
        
        <?php else: ?>
        <!-- No Products -->
        <div id="noProductsMessage" class=" p-8 text-center">
            <i class="fas fa-box-open text-4xl text-gray-300 mb-3"></i>
            <h3 class="text-lg font-medium text-gray-800 mb-2">No products found</h3>
            <p class="text-gray-500 text-sm mb-4">
                <?= !empty($search) ? 'Try a different search' : 'No products available' ?>
            </p>
            <?php if (!empty($search)): ?>
                <a href="vendor-products.php?vendor_id=<?= $vendor_id ?>" class="text-[#fbbb01] hover:text-[#e0a800] text-sm font-medium">
                    <i class="fas fa-times mr-1"></i> Clear search
                </a>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>

    <!-- Loading Indicator -->
    <div id="loadingIndicator" class="hidden text-center py-8">
        <div class="inline-block w-6 h-6 border-2 border-[#fbbb01] border-t-transparent rounded-full animate-spin mb-3"></div>
        <p class="text-gray-500 text-sm">Loading products...</p>
    </div>
</div>

<style>
.line-clamp-2 {
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('searchInput');
    const clearSearchBtn = document.getElementById('clearSearchBtn');
    const searchLoading = document.getElementById('searchLoading');
    const productsContainer = document.getElementById('productsContainer');
    const loadingIndicator = document.getElementById('loadingIndicator');
    const vendorId = <?= $vendor_id ?>;
    
    let searchTimeout;
    
    // AJAX search function
    function performSearch(searchTerm) {
        // Show loading
        searchLoading.classList.remove('hidden');
        productsContainer.classList.add('opacity-50');
        
        // Prepare form data
        const formData = new FormData();
        formData.append('search', searchTerm);
        formData.append('vendor_id', vendorId);
        
        // Make request
        fetch('ajax/search-products.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.text())
        .then(data => {
            // Update content
            productsContainer.innerHTML = data;
            productsContainer.classList.remove('opacity-50');
            
            // Update URL
            const url = new URL(window.location);
            if (searchTerm.trim()) {
                url.searchParams.set('search', searchTerm);
            } else {
                url.searchParams.delete('search');
            }
            window.history.pushState({}, '', url);
            
            // Toggle clear button
            clearSearchBtn.classList.toggle('hidden', !searchTerm.trim());
        })
        .catch(error => {
            console.error('Error:', error);
            productsContainer.innerHTML = `
                <div class="bg-red-50 border border-red-200 p-6 text-center rounded-lg">
                    <i class="fas fa-exclamation-triangle text-red-400 text-2xl mb-3"></i>
                    <h3 class="text-lg font-medium text-gray-800 mb-2">Error Loading</h3>
                    <p class="text-gray-500 text-sm">Please try again</p>
                </div>
            `;
            productsContainer.classList.remove('opacity-50');
        })
        .finally(() => {
            searchLoading.classList.add('hidden');
        });
    }
    
    // Search with debounce
    searchInput.addEventListener('input', function() {
        const searchTerm = this.value.trim();
        
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(() => {
            if (searchTerm.length >= 1 || searchTerm.length === 0) {
                performSearch(searchTerm);
            }
        }, 300);
    });
    
    // Clear search
    clearSearchBtn.addEventListener('click', function() {
        searchInput.value = '';
        performSearch('');
        clearSearchBtn.classList.add('hidden');
    });
    
    // Handle Enter key
    searchInput.addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
            performSearch(this.value.trim());
        }
    });
    
    // Handle browser navigation
    window.addEventListener('popstate', function() {
        const urlParams = new URLSearchParams(window.location.search);
        const searchParam = urlParams.get('search') || '';
        searchInput.value = searchParam;
        
        if (searchParam.trim()) {
            clearSearchBtn.classList.remove('hidden');
            performSearch(searchParam);
        } else {
            clearSearchBtn.classList.add('hidden');
            performSearch('');
        }
    });
});
</script>

<?php include 'include/footer.php'; ?>