<?php 
include 'include/header.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

require_once '../config/conn.php';

$vendor_id = $_GET['id'] ?? 0;

// Fetch vendor details
$stmt = $conn->prepare("SELECT `id`, `vendor_id`, `business_name`, `email`, `phone`, `business_type`, `address`, `contact_person`, `created_at`, `is_verified`, `profile_picture` FROM `vendors` WHERE id = ? AND is_verified = 1 AND is_approved = 1");
$stmt->bind_param("i", $vendor_id);
$stmt->execute();
$result = $stmt->get_result();
$vendor = $result->fetch_assoc();

if (!$vendor) {
    $_SESSION['error'] = "Vendor not found";
    header("Location: vendors.php");
    exit();
}
?>

<div class="max-w-4xl mx-auto p-4 mb-16">
    <!-- Back Button -->
    <div class="mb-4">
        <a href="vendors.php" class="inline-flex items-center text-[#fbbb01] hover:text-[#e0a800] text-sm">
            <i class="fas fa-arrow-left mr-1"></i> Back to Vendors
        </a>
    </div>

    <!-- Vendor Header -->
    <div class=" mb-6 overflow-hidden">
        <!-- Profile Image -->
        <div class="relative h-48 bg-gray-100">
            <?php if (!empty($vendor['profile_picture'])): 
                $image_path = strpos($vendor['profile_picture'], 'http') === 0 
                    ? $vendor['profile_picture'] 
                    : '../uploads/' . $vendor['profile_picture'];
            ?>
                <img src="<?= htmlspecialchars($image_path) ?>" 
                     alt="<?= htmlspecialchars($vendor['business_name']) ?>" 
                     class="w-full h-full object-cover"
                     onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
            <?php endif; ?>
            <div class="w-full h-full flex items-center justify-center bg-gray-100 <?= !empty($vendor['profile_picture']) ? 'hidden' : '' ?>">
                <i class="fas fa-store text-5xl text-gray-300"></i>
            </div>
            
            <!-- Business Type Badge -->
            <div class="absolute top-3 right-3">
                <span class="bg-[#fbbb01] text-white text-xs font-medium px-3 py-1 rounded-full">
                    <?= htmlspecialchars($vendor['business_type']) ?>
                </span>
            </div>
        </div>
        
        <!-- Vendor Info -->
        <div class="p-4">
            <div class="flex justify-between items-start mb-4">
                <div>
                    <h1 class="text-xl font-bold text-gray-800 mb-2">
                        <?= htmlspecialchars($vendor['business_name']) ?>
                    </h1>
                    <?php if ($vendor['is_verified']): ?>
                        <span class="inline-flex items-center text-xs text-green-600">
                            <i class="fas fa-check-circle mr-1"></i> Verified
                        </span>
                    <?php endif; ?>
                </div>
                <a href="vendor-products.php?vendor_id=<?= $vendor['id'] ?>" 
                   class="bg-[#fbbb01] hover:bg-[#e0a800] text-white text-sm font-medium px-4 py-2 rounded-lg transition">
                    <i class="fas fa-shopping-cart mr-1"></i> Buy
                </a>
            </div>
            
            <!-- Contact Info -->
            <div class="space-y-3 mb-6">
                <div class="flex items-center text-gray-700">
                    <div class="w-8 h-8 rounded-full bg-yellow-100 flex items-center justify-center mr-3">
                        <i class="fas fa-envelope text-yellow-500 text-sm"></i>
                    </div>
                    <div class="flex-1">
                        <p class="text-xs text-gray-500">Email</p>
                        <p class="text-sm truncate" title="<?= htmlspecialchars($vendor['email']) ?>">
                            <?= htmlspecialchars($vendor['email']) ?>
                        </p>
                    </div>
                </div>
                
                <?php if (!empty($vendor['phone'])): ?>
                <div class="flex items-center text-gray-700">
                    <div class="w-8 h-8 rounded-full bg-yellow-100 flex items-center justify-center mr-3">
                        <i class="fas fa-phone text-yellow-500 text-sm"></i>
                    </div>
                    <div class="flex-1">
                        <p class="text-xs text-gray-500">Phone</p>
                        <p class="text-sm"><?= htmlspecialchars($vendor['phone']) ?></p>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if (!empty($vendor['address'])): ?>
                <div class="flex items-center text-gray-700">
                    <div class="w-8 h-8 rounded-full bg-yellow-100 flex items-center justify-center mr-3">
                        <i class="fas fa-map-marker-alt text-yellow-500 text-sm"></i>
                    </div>
                    <div class="flex-1">
                        <p class="text-xs text-gray-500">Address</p>
                        <p class="text-sm"><?= htmlspecialchars($vendor['address']) ?></p>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if (!empty($vendor['contact_person'])): ?>
                <div class="flex items-center text-gray-700">
                    <div class="w-8 h-8 rounded-full bg-yellow-100 flex items-center justify-center mr-3">
                        <i class="fas fa-user text-yellow-500 text-sm"></i>
                    </div>
                    <div class="flex-1">
                        <p class="text-xs text-gray-500">Contact Person</p>
                        <p class="text-sm"><?= htmlspecialchars($vendor['contact_person']) ?></p>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            
            <!-- Member Since -->
            <div class="bg-gray-50 rounded-lg p-3 mb-4">
                <p class="text-xs text-gray-500 mb-1">Member Since</p>
                <p class="text-sm font-medium text-gray-800">
                    <?= date('F Y', strtotime($vendor['created_at'])) ?>
                </p>
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="space-y-3">
        <a href="vendor-products.php?vendor_id=<?= $vendor['id'] ?>" 
           class="block w-full bg-[#fbbb01] hover:bg-[#e0a800] text-white text-sm font-medium py-3 rounded-lg transition text-center">
            <i class="fas fa-shopping-cart mr-2"></i> Browse Products
        </a>
        
        <?php if (!empty($vendor['phone'])): ?>
            <a href="tel:<?= htmlspecialchars($vendor['phone']) ?>" 
               class="block w-full bg-gray-100 hover:bg-gray-200 text-gray-700 text-sm font-medium py-3 rounded-lg transition text-center">
                <i class="fas fa-phone mr-2"></i> Call Vendor
            </a>
        <?php else: ?>
            <button 
               class="block w-full bg-gray-100 text-gray-400 text-sm font-medium py-3 rounded-lg cursor-not-allowed text-center"
               disabled>
                <i class="fas fa-phone mr-2"></i> Phone Not Available
            </button>
        <?php endif; ?>
    </div>
</div>

<?php include 'include/footer.php'; ?>