<?php
require_once '../../config/conn.php';
session_start();
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

if (!isset($_SESSION['vendor_id'])) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit();
}

$vendor_id = $_SESSION['vendor_id'];
$account_id = $_POST['account_id'] ?? '';

if (empty($account_id)) {
    echo json_encode(['success' => false, 'message' => 'Account ID is required']);
    exit();
}

try {
    $stmt = $conn->prepare("DELETE FROM vendor_bank_accounts WHERE id = ? AND vendor_id = ?");
    $stmt->bind_param("ii", $account_id, $vendor_id);
    
    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Bank account deleted successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to delete bank account']);
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}
?>