<?php
session_start();
require '../config/conn.php';

// Initialize error messages
$errors = [
    'email' => ''
];

// Retrieve form data from session if available
$form_data = isset($_SESSION['form_data']) ? $_SESSION['form_data'] : [];
$email = $form_data['email'] ?? '';

// Check for password reset messages
if (isset($_SESSION['reset_success'])) {
    $reset_success = $_SESSION['reset_success'];
    unset($_SESSION['reset_success']);
}

if (isset($_SESSION['reset_error'])) {
    $reset_error = $_SESSION['reset_error'];
    unset($_SESSION['reset_error']);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ALETHEIA UNIVERSITY - Vendor Password Reset</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#fbbb01',
                        primaryDark: '#e0a800',
                    },
                    fontFamily: {
                        poppins: ['Poppins', 'sans-serif'],
                    }
                }
            }
        }
    </script>
    <style>
        body {
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        }
        .form-card {
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.05);
        }
    </style>
</head>
<body class="flex items-center justify-center p-5 font-poppins">
    <div class="w-full max-w-md">
        <!-- University Header - Plain without background color -->
        <div class="text-center mb-8">
            <div class="flex items-center justify-center mb-4">
                <div class="w-16 h-16  flex items-center justify-center mr-3 border border-gray-200">
                    <i class="fas fa-university text-2xl text-[#fbbb01]"></i>
                </div>
                <div class="text-left">
                    <h1 class="text-2xl font-bold text-gray-800">ALETHEIA UNIVERSITY</h1>
                    <p class="text-gray-600 text-sm">Campus Services Vendor Portal</p>
                </div>
            </div>
            <div class="mt-4">
                <h2 class="text-xl font-semibold text-gray-800">Password Recovery</h2>
                <p class="text-gray-600 text-sm mt-1">Reset your vendor account password</p>
            </div>
        </div>

        <!-- Messages Container -->
        <div id="messageContainer" class="mb-6"></div>

        <!-- Display session messages -->
        <?php 
        if (isset($_SESSION['success_message'])) {
            echo '<div class="bg-green-50 border border-green-200 p-4 rounded-lg mb-6 text-green-700">' . $_SESSION['success_message'] . '</div>';
            unset($_SESSION['success_message']);
        }
        
        if (isset($_SESSION['error_messages'])) {
            foreach ($_SESSION['error_messages'] as $error) {
                echo '<div class="bg-red-50 border border-red-200 p-4 rounded-lg mb-6 text-red-700">' . $error . '</div>';
            }
            unset($_SESSION['error_messages']);
        }
        
        if (isset($reset_success)): ?>
            <div class="bg-green-50 border border-green-200 p-4 rounded-lg mb-6 text-green-700">
                <?php echo $reset_success; ?>
            </div>
        <?php endif; 
        
        if (isset($reset_error)): ?>
            <div class="bg-red-50 border border-red-200 p-4  mb-6 text-red-700">
                <?php echo $reset_error; ?>
            </div>
        <?php endif; ?>

        <!-- Form Card -->
        <div class="bg-white l form-card p-8">
            <!-- Form Instructions -->
            <div class="mb-6">
                <p class="text-gray-700 text-center">
                    <i class="fas fa-info-circle text-[#fbbb01] mr-2"></i>
                    Enter your registered email address to receive password reset instructions
                </p>
            </div>

            <!-- Form -->
            <form id="forgotForm" class="space-y-5">
                <div>
                    <label for="forgotEmail" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-envelope mr-1 text-gray-500"></i>
                        Email Address
                    </label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <i class="fas fa-at text-gray-400"></i>
                        </div>
                        <input 
                            type="email" 
                            id="forgotEmail" 
                            name="email" 
                            class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[#fbbb01] focus:border-[#fbbb01] transition duration-200"
                            placeholder="vendor@example.com"
                            required 
                            value="<?php echo htmlspecialchars($email); ?>">
                    </div>
                    <small class="text-red-500 text-sm mt-1 block" id="email_error"><?php echo $errors['email']; ?></small>
                </div>

                <button 
                    type="submit" 
                    id="forgotBtn"
                    class="w-full py-3 bg-[#fbbb01] text-white rounded-lg font-medium hover:bg-[#e0a800] transition duration-200 disabled:opacity-70 disabled:cursor-not-allowed relative group">
                    <span class="btn-text">Send Reset Instructions</span>
                    <span class="loading-spinner hidden absolute inset-0 flex items-center justify-center">
                        <div class="w-5 h-5 border-2 border-white border-t-transparent rounded-full animate-spin"></div>
                    </span>
                    <span class="absolute inset-0 bg-white opacity-0 group-hover:opacity-10 transition-opacity rounded-lg"></span>
                </button>

                <!-- Security Notice -->
                <div class="mt-4 pt-4 border-t border-gray-100">
                    <p class="text-xs text-gray-500 text-center">
                        <i class="fas fa-shield-alt mr-1 text-[#fbbb01]"></i>
                        Your security is important. We'll send a secure password reset link to your email.
                    </p>
                </div>

                <!-- Back to Login -->
                <div class="text-center mt-4">
                    <a href="vendor_login.php" class="inline-flex items-center text-[#fbbb01] hover:text-[#e0a800] text-sm font-medium transition duration-200">
                        <i class="fas fa-arrow-left mr-2"></i>
                        Return to Login
                    </a>
                </div>
            </form>
        </div>

        <!-- Footer -->
        <div class="text-center mt-8 pt-6 border-t border-gray-200">
            <p class="text-gray-600 text-sm">
                <i class="fas fa-headset mr-1 text-[#fbbb01]"></i>
                Need assistance? Contact 
                <a href="mailto:vendorsupport@aletheiauniversity.edu" class="text-[#fbbb01] hover:text-[#e0a800] font-medium">
                    Campus Services Support
                </a>
            </p>
            <p class="text-gray-500 text-xs mt-2">
                © <?php echo date('Y'); ?> ALETHEIA UNIVERSITY. All rights reserved.
            </p>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const forgotForm = document.getElementById('forgotForm');
            const forgotBtn = document.getElementById('forgotBtn');
            const btnText = forgotBtn.querySelector('.btn-text');
            const loadingSpinner = forgotBtn.querySelector('.loading-spinner');
            const messageContainer = document.getElementById('messageContainer');
            const emailInput = document.getElementById('forgotEmail');
            const emailError = document.getElementById('email_error');

            // Real-time email validation
            emailInput.addEventListener('input', function() {
                const email = this.value.trim();
                if (email && !isValidEmail(email)) {
                    emailError.textContent = 'Please enter a valid email address';
                    this.classList.add('border-red-300');
                    this.classList.remove('border-gray-300');
                } else {
                    emailError.textContent = '';
                    this.classList.remove('border-red-300');
                    this.classList.add('border-gray-300');
                }
            });

            // Focus on email input
            setTimeout(() => {
                emailInput.focus();
            }, 300);

            forgotForm.addEventListener('submit', function(e) {
                e.preventDefault();
                
                // Validate email
                const email = emailInput.value.trim();
                if (!email || !isValidEmail(email)) {
                    emailError.textContent = 'Please enter a valid email address';
                    emailInput.classList.add('border-red-300');
                    emailInput.focus();
                    return;
                }
                
                // Show loading state
                setButtonLoading(forgotBtn, true);
                
                // Clear previous messages
                messageContainer.innerHTML = '';
                clearErrorMessages();
                
                // Get form data
                const formData = new FormData(forgotForm);
                formData.append('forgot_password', '1');
                
                // Send AJAX request
                fetch('process_vendor_forgot_password.php', {
                    method: 'POST',
                    body: formData,
                    credentials: 'same-origin'
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Network response was not ok');
                    }
                    return response.json();
                })
                .then(data => {
                    // Reset button state
                    setButtonLoading(forgotBtn, false);
                    
                    if (data.success) {
                        // Show success message
                        showMessage(data.message, 'success');
                        
                        // Clear form on success
                        forgotForm.reset();
                        
                        // Redirect to login after 3 seconds
                        setTimeout(() => {
                            window.location.href = 'vendor-login.php';
                        }, 3000);
                        
                    } else {
                        // Show error messages
                        if (data.message) {
                            showMessage(data.message, 'error');
                        }
                        
                        // Show field-specific errors
                        if (data.errors) {
                            displayFieldErrors(data.errors);
                        }
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    
                    // Reset button state
                    setButtonLoading(forgotBtn, false);
                    
                    showMessage('Network error. Please check your connection and try again.', 'error');
                });
            });

            function setButtonLoading(button, isLoading) {
                const btnText = button.querySelector('.btn-text');
                const loadingSpinner = button.querySelector('.loading-spinner');
                
                if (isLoading) {
                    button.disabled = true;
                    btnText.classList.add('opacity-0');
                    loadingSpinner.classList.remove('hidden');
                } else {
                    button.disabled = false;
                    btnText.classList.remove('opacity-0');
                    loadingSpinner.classList.add('hidden');
                }
            }

            function showMessage(message, type) {
                const messageDiv = document.createElement('div');
                messageDiv.className = `p-4 rounded-lg border mb-4 animate-fade-in ${
                    type === 'success' 
                    ? 'bg-green-50 border-green-200 text-green-700' 
                    : 'bg-red-50 border-red-200 text-red-700'
                }`;
                
                messageDiv.innerHTML = `
                    <div class="flex items-center">
                        <i class="fas ${type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle'} mr-3"></i>
                        <div>
                            <p class="font-medium">${type === 'success' ? 'Success!' : 'Error'}</p>
                            <p class="text-sm mt-1">${message}</p>
                        </div>
                    </div>
                `;
                
                messageContainer.appendChild(messageDiv);
                
                // Auto-hide success messages after 5 seconds
                if (type === 'success') {
                    setTimeout(() => {
                        if (messageDiv.parentNode) {
                            messageDiv.style.opacity = '0';
                            messageDiv.style.transition = 'opacity 0.5s ease';
                            setTimeout(() => {
                                if (messageDiv.parentNode) {
                                    messageDiv.remove();
                                }
                            }, 500);
                        }
                    }, 5000);
                }
            }

            function clearErrorMessages() {
                emailError.textContent = '';
                emailInput.classList.remove('border-red-300');
                emailInput.classList.add('border-gray-300');
            }

            function displayFieldErrors(errors) {
                for (const field in errors) {
                    const errorElement = document.getElementById(field + '_error');
                    if (errorElement && errors[field]) {
                        errorElement.textContent = errors[field];
                        const inputElement = document.getElementById('forgot' + field.charAt(0).toUpperCase() + field.slice(1));
                        if (inputElement) {
                            inputElement.classList.add('border-red-300');
                            inputElement.classList.remove('border-gray-300');
                        }
                    }
                }
            }

            function isValidEmail(email) {
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                return emailRegex.test(email);
            }
        });
    </script>
</body>
</html>
<?php
// Clear form data from session after displaying it
if (isset($_SESSION['form_data'])) {
    unset($_SESSION['form_data']);
}
?>