<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Vendor Portal - Registration</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        :root {
            --primary: #FBBB01;
            --primary-dark: #e0a800;
            --primary-light: #ffd54f;
            --text-primary: #1a202c;
            --text-secondary: #4a5568;
            --card-bg: #ffffff;
            --shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            --error-color: #e53e3e;
            --success-color: #48bb78;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            transition: background-color 0.3s, color 0.3s, transform 0.3s;
        }

        body {
            font-family: 'Poppins', 'Helvetica', sans-serif;
            background-color: #ffffff;
            color: var(--text-primary);
            line-height: 1.5;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 15px;
        }

        .error-text {
            color: var(--error-color);
            font-size: 0.75rem;
            margin-top: 4px;
            display: block;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(5px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @keyframes button-loading-spinner {
            from { transform: rotate(0turn); }
            to { transform: rotate(1turn); }
        }
        
        .portal-logo {
            max-height: 60px;
            margin-bottom: 15px;
        }

        .fade-in {
            animation: fadeIn 0.3s ease-in-out;
        }

        /* Password requirement styling */
        .password-requirements {
            background: #f8f9fa;
            border-radius: 6px;
            padding: 10px 12px;
            margin-top: 8px;
            border-left: 3px solid #FBBB01;
        }
        
        .password-requirement {
            font-size: 0.8rem;
            color: #4a5568;
            margin-bottom: 3px;
            display: flex;
            align-items: center;
            gap: 6px;
        }
        
        .password-requirement i {
            font-size: 0.7rem;
            width: 14px;
        }
        
        .requirement-met {
            color: #48bb78;
        }
        
        .requirement-not-met {
            color: #cbd5e0;
        }

        /* Fixed password input wrapper */
        .password-input-wrapper {
            position: relative;
            width: 100%;
            margin-bottom: 0;
        }
        
        .password-input-wrapper .form-control {
            width: 100%;
            padding-right: 70px !important; /* Space for both icons */
            padding-left: 35px !important;
        }
        
        .password-input-wrapper .icon-left {
            position: absolute;
            left: 12px;
            top: 50%;
            transform: translateY(-50%);
            color: #4a5568;
            pointer-events: none;
            z-index: 10;
        }
        
        .password-input-wrapper .icon-right {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            color: #4a5568;
            cursor: pointer;
            z-index: 10;
            background: none;
            border: none;
            padding: 0;
            width: 24px;
            height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Mobile-specific styles */
        @media (max-width: 640px) {
            body {
                padding: 10px;
                align-items: flex-start;
                padding-top: 20px;
            }
            
            .auth-header {
                margin-bottom: 20px !important;
            }
            
            .auth-header h1 {
                font-size: 1.75rem !important;
                margin-bottom: 5px !important;
            }
            
            .auth-header p {
                font-size: 0.9rem !important;
            }
            
            .auth-form {
                padding: 20px !important;
                margin-bottom: 20px;
            }
            
            .form-group {
                margin-bottom: 16px !important;
            }
            
            .form-control {
                padding: 10px 15px !important;
                padding-left: 35px !important;
                font-size: 0.9rem !important;
                min-height: 42px;
            }
            
            .input-wrapper i {
                left: 12px !important;
                font-size: 0.9rem;
            }
            
            label {
                font-size: 0.9rem;
                margin-bottom: 6px !important;
                display: block;
            }
            
            button[type="submit"] {
                padding: 11px !important;
                font-size: 0.95rem !important;
                margin-top: 20px !important;
                min-height: 44px;
            }
            
            .auth-switch {
                font-size: 0.9rem;
                margin-top: 20px !important;
            }
            
            /* Password input wrapper for mobile */
            .password-input-wrapper .form-control {
                padding-right: 60px !important;
                padding-left: 35px !important;
            }
            
            .password-input-wrapper .icon-left,
            .password-input-wrapper .icon-right {
                font-size: 0.9rem;
            }
            
            /* Make form elements more compact */
            .form-control::placeholder {
                font-size: 0.9rem;
            }
            
            /* Adjust message containers */
            #messageContainer {
                margin-bottom: 15px !important;
            }
            
            .w-full.max-w-\[500px\] {
                padding: 10px 12px !important;
                font-size: 0.85rem;
                margin-bottom: 15px !important;
            }
            
            /* Password requirements for mobile */
            .password-requirements {
                padding: 8px 10px;
                margin-top: 6px;
            }
            
            .password-requirement {
                font-size: 0.75rem;
                margin-bottom: 2px;
            }
        }

        /* Tablet adjustments */
        @media (min-width: 641px) and (max-width: 768px) {
            body {
                padding: 20px;
            }
            
            .auth-form {
                padding: 25px !important;
            }
            
            .auth-header h1 {
                font-size: 2rem !important;
            }
        }

        /* Password column specific spacing */
        .password-column {
            margin-bottom: 24px !important;
        }
        
        .password-column .form-control {
            margin-bottom: 0;
        }
        
        .password-hint {
            margin-top: 5px;
            margin-bottom: 8px;
        }
    </style>
</head>
<body>
    <div class="auth-container max-w-[1200px] w-full flex flex-col items-center">
        <!-- Campus Services Header -->
        <div class="text-center mb-6">
            <div class="w-16 h-16 mx-auto mb-3 flex items-center justify-center">
                <img src="../img/schools.png" alt="School Logo" class="max-w-full max-h-full">
            </div>
            <h1 class="text-xl font-bold text-gray-800">Campus Services</h1>
            <p class="text-gray-500 text-sm mt-1">Vendor Registration</p>
        </div>

        <div class="auth-header text-center mb-[25px]">
            <h1 class="text-[2rem] mb-[8px] bg-gradient-to-r from-[#FBBB01] to-[#ffd54f] bg-clip-text text-transparent">Vendor Portal</h1>
            <p class="text-[#4a5568] text-[1rem]">Register your business to start working with us</p>
        </div>

        <!-- Messages Container -->
        <div id="messageContainer" class="w-full max-w-[500px] mb-[15px]"></div>

        <!-- Display session messages -->
        <?php 
        if (isset($_SESSION['success_message'])) {
            echo '<div class="w-full max-w-[500px] bg-[rgba(72,187,120,0.1)] text-[#48bb78] border-l-[3px] border-[#48bb78] px-[15px] py-[10px] rounded-[8px] mb-[15px] fade-in">' . $_SESSION['success_message'] . '</div>';
            unset($_SESSION['success_message']);
        }
        
        if (isset($_SESSION['error_messages'])) {
            foreach ($_SESSION['error_messages'] as $error) {
                echo '<div class="w-full max-w-[500px] bg-[rgba(229,62,62,0.1)] text-[#e53e3e] border-l-[3px] border-[#e53e3e] px-[15px] py-[10px] rounded-[8px] mb-[15px] fade-in">' . $error . '</div>';
            }
            unset($_SESSION['error_messages']);
        }
        ?>

        <form id="registerForm" class="auth-form active w-full max-w-[500px] border border-gray-200 fade-in">
            <div class="form-group mb-[15px]">
                <label for="businessName" class="block mb-[5px] font-[500] text-[#1a202c]">Business Name</label>
                <div class="input-wrapper relative">
                    <i class="fas fa-building absolute left-[12px] top-[50%] transform -translate-y-1/2 text-[#4a5568]"></i>
                    <input type="text" id="businessName" name="business_name" class="form-control w-full px-[12px] py-[10px] pl-[35px] border border-gray-300 rounded-[6px] bg-white text-[#1a202c] font-['Poppins'] text-[0.95rem] focus:outline-none focus:border-[#FBBB01] focus:ring-1 focus:ring-[#FBBB01]" 
                           placeholder="Enter business name" required value="<?php echo htmlspecialchars($business_name); ?>">
                </div>
                <small class="error-text" id="business_name_error"><?php echo $errors['business_name']; ?></small>
            </div>
            
            <div class="form-group mb-[15px]">
                <label for="registerEmail" class="block mb-[5px] font-[500] text-[#1a202c]">Email Address</label>
                <div class="input-wrapper relative">
                    <i class="fas fa-envelope absolute left-[12px] top-[50%] transform -translate-y-1/2 text-[#4a5568]"></i>
                    <input type="email" id="registerEmail" name="email" class="form-control w-full px-[12px] py-[10px] pl-[35px] border border-gray-300 rounded-[6px] bg-white text-[#1a202c] font-['Poppins'] text-[0.95rem] focus:outline-none focus:border-[#FBBB01] focus:ring-1 focus:ring-[#FBBB01]" 
                           placeholder="Enter your email" required value="<?php echo htmlspecialchars($email); ?>">
                </div>
                <small class="error-text" id="email_error"><?php echo $errors['email']; ?></small>
            </div>
            
            <div class="form-group mb-[15px]">
                <label for="contactPerson" class="block mb-[5px] font-[500] text-[#1a202c]">Contact Person</label>
                <div class="input-wrapper relative">
                    <i class="fas fa-user absolute left-[12px] top-[50%] transform -translate-y-1/2 text-[#4a5568]"></i>
                    <input type="text" id="contactPerson" name="contact_person" class="form-control w-full px-[12px] py-[10px] pl-[35px] border border-gray-300 rounded-[6px] bg-white text-[#1a202c] font-['Poppins'] text-[0.95rem] focus:outline-none focus:border-[#FBBB01] focus:ring-1 focus:ring-[#FBBB01]" 
                           placeholder="Contact person name" required value="<?php echo htmlspecialchars($contact_person); ?>">
                </div>
                <small class="error-text" id="contact_person_error"><?php echo $errors['contact_person']; ?></small>
            </div>
            
            <!-- Redesigned Password Column with fixed input -->
            <div class="form-group password-column mb-[24px]">
                <label for="registerPassword" class="block mb-[6px] font-[500] text-[#1a202c]">Password</label>
                <div class="password-input-wrapper mb-[8px]">
                    <i class="fas fa-lock icon-left"></i>
                    <input type="password" id="registerPassword" name="password" 
                           class="form-control w-full px-[12px] py-[10px] border border-gray-300 rounded-[6px] bg-white text-[#1a202c] font-['Poppins'] text-[0.95rem] focus:outline-none focus:border-[#FBBB01] focus:ring-1 focus:ring-[#FBBB01]" 
                           placeholder="Create password" required autocomplete="new-password">
                    <button type="button" class="icon-right" id="toggleRegisterPasswordBtn">
                        <i class="fas fa-eye"></i>
                    </button>
                </div>
                <small class="error-text" id="password_error"><?php echo $errors['password']; ?></small>
                
                <!-- Password Requirements Box -->
                <div class="password-requirements mt-[8px]">
                    <div class="password-requirement" id="req-length">
                        <i class="fas fa-circle requirement-not-met"></i>
                        <span>At least 8 characters</span>
                    </div>
                    <div class="password-requirement" id="req-uppercase">
                        <i class="fas fa-circle requirement-not-met"></i>
                        <span>One uppercase letter</span>
                    </div>
                    <div class="password-requirement" id="req-lowercase">
                        <i class="fas fa-circle requirement-not-met"></i>
                        <span>One lowercase letter</span>
                    </div>
                    <div class="password-requirement" id="req-number">
                        <i class="fas fa-circle requirement-not-met"></i>
                        <span>One number</span>
                    </div>
                    <div class="password-requirement" id="req-special">
                        <i class="fas fa-circle requirement-not-met"></i>
                        <span>One special character</span>
                    </div>
                </div>
            </div>
            
            <!-- Confirm Password Column with fixed input -->
            <div class="form-group mb-[15px]">
                <label for="registerConfirmPassword" class="block mb-[6px] font-[500] text-[#1a202c]">Confirm Password</label>
                <div class="password-input-wrapper">
                    <i class="fas fa-lock icon-left"></i>
                    <input type="password" id="registerConfirmPassword" name="confirm_password" 
                           class="form-control w-full px-[12px] py-[10px] border border-gray-300 rounded-[6px] bg-white text-[#1a202c] font-['Poppins'] text-[0.95rem] focus:outline-none focus:border-[#FBBB01] focus:ring-1 focus:ring-[#FBBB01]" 
                           placeholder="Confirm password" required autocomplete="new-password">
                    <button type="button" class="icon-right" id="toggleConfirmPasswordBtn">
                        <i class="fas fa-eye"></i>
                    </button>
                </div>
                <small class="error-text" id="confirm_password_error"><?php echo $errors['confirm_password']; ?></small>
                <small class="text-[#4a5568] block mt-[5px] text-[0.8rem]" id="password-match-hint">
                    Passwords must match
                </small>
            </div>
            
            <div class="form-group mb-[15px]">
                <div class="flex items-start">
                    <input type="checkbox" id="acceptTerms" name="accept_terms" required class="mr-[8px] mt-1">
                    <label for="acceptTerms" class="text-[#1a202c] text-[0.9rem]">I agree to the <a href="terms.php" class="text-[#FBBB01] hover:underline">Terms</a> and <a href="privacy.php" class="text-[#FBBB01] hover:underline">Privacy Policy</a></label>
                </div>
                <small class="error-text block" id="terms_error"><?php echo $errors['terms']; ?></small>
            </div>
            
            <button type="submit" class="btn w-full py-[10px] bg-[#FBBB01] text-white border-none rounded-[6px] font-['Poppins'] text-[0.95rem] font-[500] cursor-pointer hover:bg-[#e0a800] mt-[20px] relative transition-colors duration-300 disabled:opacity-70 disabled:cursor-not-allowed" id="submitBtn" name="register">
                <span class="btn-text">Register Business</span>
                <span class="loading-spinner hidden absolute inset-0 flex items-center justify-center">
                    <div class="w-4 h-4 border-2 border-white border-t-transparent rounded-full animate-button-loading-spinner"></div>
                </span>
            </button>
            
            <div class="auth-switch text-center text-[#4a5568] mt-[15px] text-[0.9rem]">
                Already have an account? <a href="vendor-login.php" class="text-[#FBBB01] no-underline ml-[3px] hover:underline">Sign in</a>
            </div>
        </form>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Password Toggle Visibility - FIXED VERSION
            function setupPasswordToggle(buttonId, inputId) {
                const toggleBtn = document.getElementById(buttonId);
                const input = document.getElementById(inputId);
                const icon = toggleBtn.querySelector('i');
                
                toggleBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    
                    if (input.type === 'password') {
                        input.type = 'text';
                        icon.classList.remove('fa-eye');
                        icon.classList.add('fa-eye-slash');
                    } else {
                        input.type = 'password';
                        icon.classList.remove('fa-eye-slash');
                        icon.classList.add('fa-eye');
                    }
                    
                    // Focus back on input after toggle
                    input.focus();
                });
                
                // Prevent button from interfering with input
                toggleBtn.addEventListener('mousedown', function(e) {
                    e.preventDefault();
                });
            }
            
            setupPasswordToggle('toggleRegisterPasswordBtn', 'registerPassword');
            setupPasswordToggle('toggleConfirmPasswordBtn', 'registerConfirmPassword');
            
            // Real-time Password Validation
            const passwordInput = document.getElementById('registerPassword');
            const confirmPasswordInput = document.getElementById('registerConfirmPassword');
            const passwordMatchHint = document.getElementById('password-match-hint');
            
            // Password requirement elements
            const reqLength = document.getElementById('req-length');
            const reqUppercase = document.getElementById('req-uppercase');
            const reqLowercase = document.getElementById('req-lowercase');
            const reqNumber = document.getElementById('req-number');
            const reqSpecial = document.getElementById('req-special');
            
            function validatePassword(password) {
                // Length check
                const hasLength = password.length >= 8;
                updateRequirement(reqLength, hasLength);
                
                // Uppercase check
                const hasUppercase = /[A-Z]/.test(password);
                updateRequirement(reqUppercase, hasUppercase);
                
                // Lowercase check
                const hasLowercase = /[a-z]/.test(password);
                updateRequirement(reqLowercase, hasLowercase);
                
                // Number check
                const hasNumber = /[0-9]/.test(password);
                updateRequirement(reqNumber, hasNumber);
                
                // Special character check
                const hasSpecial = /[!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?]/.test(password);
                updateRequirement(reqSpecial, hasSpecial);
                
                return hasLength && hasUppercase && hasLowercase && hasNumber && hasSpecial;
            }
            
            function updateRequirement(element, isMet) {
                const icon = element.querySelector('i');
                if (isMet) {
                    icon.classList.remove('requirement-not-met');
                    icon.classList.add('requirement-met');
                    icon.classList.remove('fa-circle');
                    icon.classList.add('fa-check-circle');
                } else {
                    icon.classList.remove('requirement-met');
                    icon.classList.add('requirement-not-met');
                    icon.classList.remove('fa-check-circle');
                    icon.classList.add('fa-circle');
                }
            }
            
            function checkPasswordMatch() {
                const password = passwordInput.value;
                const confirmPassword = confirmPasswordInput.value;
                
                if (confirmPassword === '') {
                    passwordMatchHint.textContent = 'Passwords must match';
                    passwordMatchHint.style.color = '#4a5568';
                    return false;
                } else if (password === confirmPassword) {
                    passwordMatchHint.textContent = '✓ Passwords match';
                    passwordMatchHint.style.color = '#48bb78';
                    return true;
                } else {
                    passwordMatchHint.textContent = '✗ Passwords do not match';
                    passwordMatchHint.style.color = '#e53e3e';
                    return false;
                }
            }
            
            // Event listeners for real-time validation
            passwordInput.addEventListener('input', function() {
                validatePassword(this.value);
                checkPasswordMatch();
            });
            
            confirmPasswordInput.addEventListener('input', checkPasswordMatch);
            
            // Initialize validation on page load
            validatePassword('');
            
            // AJAX Form Submission
            const registerForm = document.getElementById('registerForm');
            const submitBtn = document.getElementById('submitBtn');
            const btnText = submitBtn.querySelector('.btn-text');
            const loadingSpinner = submitBtn.querySelector('.loading-spinner');
            const messageContainer = document.getElementById('messageContainer');
            
            registerForm.addEventListener('submit', function(e) {
                e.preventDefault();
                
                // Validate password before submission
                const password = passwordInput.value;
                const confirmPassword = confirmPasswordInput.value;
                const isPasswordValid = validatePassword(password);
                const isPasswordMatch = checkPasswordMatch();
                
                if (!isPasswordValid) {
                    showMessage('Please meet all password requirements', 'error');
                    return;
                }
                
                if (!isPasswordMatch) {
                    showMessage('Passwords do not match', 'error');
                    return;
                }
                
                if (!document.getElementById('acceptTerms').checked) {
                    document.getElementById('terms_error').textContent = 'You must accept the terms and conditions';
                    return;
                }
                
                // Show loading state
                submitBtn.disabled = true;
                btnText.classList.add('opacity-0');
                loadingSpinner.classList.remove('hidden');
                
                // Clear previous messages
                messageContainer.innerHTML = '';
                clearErrorMessages();
                
                // Get form data
                const formData = new FormData(registerForm);
                formData.append('register', '1');
                
                // Send AJAX request
                fetch('process_vendor_register.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    // Reset button state
                    submitBtn.disabled = false;
                    btnText.classList.remove('opacity-0');
                    loadingSpinner.classList.add('hidden');
                    
                    if (data.success) {
                        // Show success message
                        showMessage(data.message, 'success');
                        
                        // Clear form if registration was successful
                        registerForm.reset();
                        validatePassword(''); // Reset password requirements
                        
                        // Redirect to login page after 3 seconds
                        setTimeout(() => {
                            window.location.href = 'vendor-login.php';
                        }, 3000);
                    } else {
                        // Show error messages
                        if (data.message) {
                            showMessage(data.message, 'error');
                        }
                        
                        // Show field-specific errors
                        if (data.errors) {
                            displayFieldErrors(data.errors);
                        }
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    
                    // Reset button state
                    submitBtn.disabled = false;
                    btnText.classList.remove('opacity-0');
                    loadingSpinner.classList.add('hidden');
                    
                    showMessage('An error occurred. Please try again.', 'error');
                });
            });
            
            function showMessage(message, type) {
                const messageDiv = document.createElement('div');
                messageDiv.className = `p-3 rounded-lg border-l-3 fade-in text-sm ${
                    type === 'success' 
                    ? 'bg-green-50 text-green-700 border-green-500' 
                    : 'bg-red-50 text-red-700 border-red-500'
                }`;
                messageDiv.textContent = message;
                messageContainer.appendChild(messageDiv);
                
                // Auto-hide success messages after 5 seconds
                if (type === 'success') {
                    setTimeout(() => {
                        messageDiv.remove();
                    }, 5000);
                }
            }
            
            function clearErrorMessages() {
                const errorElements = document.querySelectorAll('[id$="_error"]');
                errorElements.forEach(element => {
                    element.textContent = '';
                });
            }
            
            function displayFieldErrors(errors) {
                for (const field in errors) {
                    const errorElement = document.getElementById(field + '_error');
                    if (errorElement && errors[field]) {
                        errorElement.textContent = errors[field];
                    }
                }
            }
            
            // Fix: Ensure inputs are clickable and focusable
            document.querySelectorAll('.password-input-wrapper .form-control').forEach(input => {
                input.addEventListener('click', function(e) {
                    e.stopPropagation();
                });
                
                input.addEventListener('focus', function() {
                    this.parentElement.style.zIndex = '20';
                });
                
                input.addEventListener('blur', function() {
                    this.parentElement.style.zIndex = '10';
                });
            });
        });
    </script>
</body>
</html>
<?php
// Clear form data from session after displaying it
if (isset($_SESSION['form_data'])) {
    unset($_SESSION['form_data']);
}
?>