<?php
// ajax_delete_vendor_bank_account.php
header('Content-Type: application/json');
session_start();

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'vendor') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

require_once '../config/conn.php';

$account_id = $_POST['account_id'] ?? '';

if (empty($account_id)) {
    echo json_encode(['success' => false, 'message' => 'Account ID is required']);
    exit();
}

// Get vendor ID from session
$vendor_id = $_SESSION['user_id'];

// First get vendor details
$vendor_stmt = $conn->prepare("SELECT id FROM vendors WHERE user_id = ?");
$vendor_stmt->bind_param("i", $vendor_id);
$vendor_stmt->execute();
$vendor_result = $vendor_stmt->get_result();
$vendor = $vendor_result->fetch_assoc();

if (!$vendor) {
    echo json_encode(['success' => false, 'message' => 'Vendor not found']);
    exit();
}

// Check if account belongs to vendor and get details before deletion
$check_stmt = $conn->prepare("
    SELECT account_number, bank_name, is_default 
    FROM vendor_bank_accounts 
    WHERE id = ? AND vendor_id = ?
");
$check_stmt->bind_param("ii", $account_id, $vendor['id']);
$check_stmt->execute();
$check_result = $check_stmt->get_result();

if ($check_result->num_rows === 0) {
    echo json_encode(['success' => false, 'message' => 'Account not found or unauthorized']);
    exit();
}

$account = $check_result->fetch_assoc();

// Check if it's the only account
$count_stmt = $conn->prepare("
    SELECT COUNT(*) as count FROM vendor_bank_accounts 
    WHERE vendor_id = ?
");
$count_stmt->bind_param("i", $vendor['id']);
$count_stmt->execute();
$count_result = $count_stmt->get_result();
$count = $count_result->fetch_assoc();

if ($count['count'] <= 1) {
    echo json_encode(['success' => false, 'message' => 'Cannot delete your only bank account']);
    exit();
}

// Delete the account
$delete_stmt = $conn->prepare("DELETE FROM vendor_bank_accounts WHERE id = ?");
$delete_stmt->bind_param("i", $account_id);

if ($delete_stmt->execute()) {
    // If deleted account was default, set another as default
    if ($account['is_default']) {
        $new_default_stmt = $conn->prepare("
            UPDATE vendor_bank_accounts 
            SET is_default = 1 
            WHERE vendor_id = ? 
            LIMIT 1
        ");
        $new_default_stmt->bind_param("i", $vendor['id']);
        $new_default_stmt->execute();
    }
    
    // Log activity
    $log_stmt = $conn->prepare("
        INSERT INTO vendor_activity_log 
        (vendor_id, activity_type, description, created_at)
        VALUES (?, 'bank_account_deleted', ?, NOW())
    ");
    $activity_desc = "Deleted bank account: " . $account['bank_name'] . " - " . $account['account_number'];
    $log_stmt->bind_param("is", $vendor['id'], $activity_desc);
    $log_stmt->execute();
    
    echo json_encode(['success' => true, 'message' => 'Bank account deleted successfully']);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to delete bank account']);
}