<?php  
session_start();
require_once '../config/conn.php';

// Check if vendor is logged in
if (!isset($_SESSION['vendor_id'])) {
    header("Location: vendor-login.php");
    exit();
}

$vendor_id = $_SESSION['vendor_id'];

// Fetch vendor data from database to ensure session variables are set
$query = "SELECT business_name, email FROM vendors WHERE vendor_id = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "s", $vendor_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$vendor = mysqli_fetch_assoc($result);

if ($vendor) {
    // Set session variables if not already set
    if (!isset($_SESSION['business_name'])) {
        $_SESSION['business_name'] = $vendor['business_name'];
    }
    if (!isset($_SESSION['vendor_email'])) {
        $_SESSION['vendor_email'] = $vendor['email'];
    }
}
mysqli_stmt_close($stmt);
?>
<!doctype html>
<html>
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <script src="https://cdn.tailwindcss.com"></script>
   <link href="output.css" rel="stylesheet">
  <script>
    tailwind.config = {
      darkMode: 'class',
      theme: {
        extend: {
          colors: {
            primary: {
              DEFAULT: '#fbbb01',
              100: '#fef4d5',
              200: '#fde8ab',
              300: '#fbdd81',
              400: '#fad157',
              500: '#fbbb01',
              600: '#c99601',
              700: '#977001',
              800: '#644b00',
              900: '#322500',
            }
          }
        }
      }
    }
  </script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
    body {
      font-family: 'Poppins', sans-serif;
      transition: background-color 0.3s ease;
    }
    /* Custom scrollbar */
    ::-webkit-scrollbar {
      width: 6px;
    }
    ::-webkit-scrollbar-track {
      background: #f1f1f1;
    }
    ::-webkit-scrollbar-thumb {
      background: #fbbb01;
      border-radius: 3px;
    }
    .dark ::-webkit-scrollbar-track {
      background: #1f2937;
    }
    .dark ::-webkit-scrollbar-thumb {
      background: #c99601;
    }
    .sidebar {
      transition: all 0.3s ease;
    }
    @media (max-width: 1023px) {
      .sidebar {
        transform: translateX(-100%);
        position: fixed;
        z-index: 50;
        height: 100vh;
      }
      .sidebar.active {
        transform: translateX(0);
      }
    }
    /* Profile dropdown */
    .profile-dropdown {
      display: none;
      position: absolute;
      right: 1rem;
      top: 4rem;
      width: 200px;
      background: white;
      border-radius: 0.5rem;
      box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
      z-index: 50;
    }
    .dark .profile-dropdown {
      background: #1f2937;
      border: 1px solid #374151;
      box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.3), 0 2px 4px -1px rgba(0, 0, 0, 0.2);
    }
    .profile-dropdown.active {
      display: block;
    }
    /* Bottom nav */
    .bottom-nav {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      background: white;
      display: flex;
      justify-content: space-around;
      padding: 0.75rem 0;
      border-top: 1px solid #e5e7eb;
      z-index: 40;
    }
    .dark .bottom-nav {
      background: #111827;
      border-top: 1px solid #374151;
    }
    .bottom-nav-item {
      display: flex;
      flex-direction: column;
      align-items: center;
      text-decoration: none;
    }
    .bottom-nav-icon {
      font-size: 1.5rem;
      margin-bottom: 0.25rem;
    }
    .bottom-nav-text {
      font-size: 0.75rem;
    }
    /* Feed items */
    .feed-item {
      width: 100%;
      border-radius: 0.5rem;
      overflow: hidden;
      margin-bottom: 1rem;
      position: relative;
    }
    .feed-item-content {
      padding: 1rem;
      background: white;
    }
    .dark .feed-item-content {
      background: #1f2937;
    }
    /* Main content padding adjustment for mobile */
    .main-content {
      padding-bottom: 4rem; /* Space for bottom nav */
    }
    @media (min-width: 1024px) {
      .main-content {
        padding-bottom: 0;
      }
      .bottom-nav {
        display: none;
      }
      .sidebar-toggle {
        display: none !important;
      }
    }
    /* Vendor specific styles */
    .vendor-card {
      transition: transform 0.2s ease;
    }
    .vendor-card:hover {
      transform: translateY(-2px);
    }
    .balance-card {
      transition: all 0.3s ease;
    }
    .balance-card:hover {
      transform: translateY(-3px);
      box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
    }
  </style>
</head>
<body class="bg-gray-50 dark:bg-gray-900">
  <div class="flex min-h-screen">
  <?php include 'sidebar.php'; ?>
    <div class="flex-1 flex flex-col">
    <?php include 'navbar.php'; ?>