<!-- Top Bar -->
<?php  

require_once '../config/conn.php';

// Check if vendor is logged in
if (!isset($_SESSION['vendor_id'])) {
    header("Location: vendor-login.php");
    exit();
}

$vendor_id = $_SESSION['vendor_id'];

// Fetch vendor data from database to ensure session variables are set
$query = "SELECT business_name, email FROM vendors WHERE vendor_id = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "s", $vendor_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$vendor = mysqli_fetch_assoc($result);

if ($vendor) {
    // Set session variables if not already set
    if (!isset($_SESSION['business_name'])) {
        $_SESSION['business_name'] = $vendor['business_name'];
    }
    if (!isset($_SESSION['vendor_email'])) {
        $_SESSION['vendor_email'] = $vendor['email'];
    }
}
mysqli_stmt_close($stmt);
?>

<header class="bg-white dark:bg-gray-800 border-b border-gray-200 dark:border-gray-700 p-4 flex justify-between items-center sticky top-0 z-30">
  <button class="sidebar-toggle p-2 lg:hidden">
    <i class="fas fa-bars text-gray-600 dark:text-gray-300 text-xl"></i>
  </button>
  <h2 class="text-xl font-semibold text-gray-700 dark:text-gray-200">Balance Overview</h2>
  <div class="flex items-center space-x-4 relative">
    <button id="theme-toggle" class="p-2 rounded-full hover:bg-gray-100 dark:hover:bg-gray-700">
      <i class="fas fa-moon text-gray-500 dark:text-primary-300" id="theme-icon"></i>
    </button>
    <button class="p-2 rounded-full hover:bg-gray-100 dark:hover:bg-gray-700">
      <i class="fas fa-bell text-gray-500 dark:text-gray-300"></i>
    </button>
    <button id="profile-toggle" class="w-8 h-8 bg-primary-100 dark:bg-primary-200 rounded-full flex items-center justify-center">
      <i class="fas fa-store text-primary-500 dark:text-primary-600"></i>
    </button>
    <div id="profile-dropdown" class="profile-dropdown dark:text-white">
      <div class="p-4 border-b border-gray-100 dark:border-gray-600">
        <p class="font-medium"><?php echo isset($_SESSION['business_name']) ? htmlspecialchars($_SESSION['business_name']) : 'Business Name'; ?></p>
        <p class="text-xs text-gray-500 dark:text-gray-400"><?php echo isset($_SESSION['vendor_email']) ? htmlspecialchars($_SESSION['vendor_email']) : 'email@example.com'; ?></p>
      </div>
      <a href="profile.php" class="block px-4 py-2 hover:bg-gray-50 dark:hover:bg-gray-700 text-sm">Profile</a>
      <a href="#" class="block px-4 py-2 hover:bg-gray-50 dark:hover:bg-gray-700 text-sm">Settings</a>
      <a href="../logout.php" class="block px-4 py-2 hover:bg-gray-50 dark:hover:bg-gray-700 text-sm border-t border-gray-100 dark:border-gray-600">Logout</a>
    </div>
  </div>
</header>

