<?php
// vendor/vendor-dashboard.php
include 'include/header.php';

if (!isset($_SESSION['vendor_id']) || empty($_SESSION['vendor_id'])) {
    header("Location: vendor-login.php");
    exit();
}

$vendor_id = $_SESSION['vendor_id'];

// Get current wallet data
require_once '../config/conn.php';
$wallet_query = "SELECT * FROM vendor_wallets WHERE vendor_id = '$vendor_id'";
$wallet_result = mysqli_query($conn, $wallet_query);
$wallet = mysqli_fetch_assoc($wallet_result);

// Get today's transactions
$today = date('Y-m-d');
$today_trans_query = "SELECT COUNT(*) as count, SUM(amount) as total 
                     FROM vendor_wallet_transactions 
                     WHERE vendor_id = '$vendor_id' 
                     AND DATE(created_at) = '$today' 
                     AND transaction_type = 'credit'";
$today_result = mysqli_query($conn, $today_trans_query);
$today_stats = mysqli_fetch_assoc($today_result);

// Get recent transactions
$recent_query = "SELECT * FROM vendor_wallet_transactions 
                WHERE vendor_id = '$vendor_id' 
                ORDER BY created_at DESC LIMIT 3"; // Reduced from 5 to 3
$recent_result = mysqli_query($conn, $recent_query);
$recent_transactions = [];
while ($row = mysqli_fetch_assoc($recent_result)) {
    $recent_transactions[] = $row;
}

mysqli_close($conn);
?>

<!DOCTYPE html>

    <style>
        @media (max-width: 768px) {
            .compact-card {
                padding: 1rem !important;
                margin-bottom: 0.75rem !important;
            }
            .compact-text {
                font-size: 1.5rem !important;
            }
            .compact-table th, .compact-table td {
                padding: 0.5rem !important;
                font-size: 0.875rem !important;
            }
            .hide-on-mobile {
                display: none !important;
            }
            .mobile-stack {
                flex-direction: column !important;
            }
            .mobile-small-text {
                font-size: 0.75rem !important;
            }
            .mobile-padding {
                padding: 1rem !important;
            }
        }
    </style>
</head>
<body class="bg-gray-50 dark:bg-gray-900">
    
    <div class="container mx-auto px-2 sm:px-4 py-4">
        <!-- Compact Page Header -->
        <div class="mb-4">
            <h1 class="text-xl sm:text-2xl font-bold text-gray-900 dark:text-white">Dashboard</h1>
            <p class="text-sm text-gray-600 dark:text-gray-400">Real-time earnings</p>
        </div>
        
        <!-- Compact Real-time Balance Cards -->
        <div id="real-time-balances" class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4 mb-6">
            <!-- Pending Balance -->
            <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800  compact-card">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs sm:text-sm font-medium text-blue-600 dark:text-blue-400">Pending</p>
                        <p id="pending-balance" class="text-xl sm:text-2xl compact-text font-bold text-blue-800 dark:text-blue-300 mt-1">
                            ₦<?= number_format($wallet['pending_balance'] ?? 0, 2) ?>
                        </p>
                        <p class="text-xs mobile-small-text text-blue-600/70 dark:text-blue-400/70 mt-1">
                            <i class="fas fa-clock mr-1"></i>Awaiting approval
                        </p>
                    </div>
                    <div class="text-blue-500 text-xl sm:text-2xl">
                        <i class="fas fa-hourglass-half"></i>
                    </div>
                </div>
            </div>
            
            <!-- Approved Balance -->
            <div class="bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800  compact-card">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs sm:text-sm font-medium text-green-600 dark:text-green-400">Approved</p>
                        <p id="approved-balance" class="text-xl sm:text-2xl compact-text font-bold text-green-800 dark:text-green-300 mt-1">
                            ₦<?= number_format($wallet['balance'] ?? 0, 2) ?>
                        </p>
                        <p class="text-xs mobile-small-text text-green-600/70 dark:text-green-400/70 mt-1">
                            <i class="fas fa-check-circle mr-1"></i>Available
                        </p>
                    </div>
                    <div class="text-green-500 text-xl sm:text-2xl">
                        <i class="fas fa-wallet"></i>
                    </div>
                </div>
            </div>
            
            <!-- Today's Earnings -->
            <div class="bg-purple-50 dark:bg-purple-900/20 border border-purple-200 dark:border-purple-800  compact-card">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs sm:text-sm font-medium text-purple-600 dark:text-purple-400">Today</p>
                        <p class="text-xl sm:text-2xl compact-text font-bold text-purple-800 dark:text-purple-300 mt-1">
                            ₦<?= number_format($today_stats['total'] ?? 0, 2) ?>
                        </p>
                        <p class="text-xs mobile-small-text text-purple-600/70 dark:text-purple-400/70 mt-1">
                            <i class="fas fa-shopping-cart mr-1"></i><?= $today_stats['count'] ?? 0 ?> txn
                        </p>
                    </div>
                    <div class="text-purple-500 text-xl sm:text-2xl">
                        <i class="fas fa-chart-line"></i>
                    </div>
                </div>
            </div>
            
            <!-- Quick Actions -->
            <div class="bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800  compact-card">
                <div>
                    <p class="text-xs sm:text-sm font-medium text-yellow-600 dark:text-yellow-400">Actions</p>
                    <div class="mt-2 space-y-2">
                        <a href="vendor-transactions.php" class="block w-full bg-yellow-500 hover:bg-yellow-600 text-white py-1.5 px-3 rounded text-center text-sm transition duration-200">
                            <i class="fas fa-history mr-1"></i>Transactions
                        </a>
                        <a href="bank-account.php" class="block w-full bg-white dark:bg-gray-800 border border-yellow-500 text-yellow-600 dark:text-yellow-400 hover:bg-yellow-50 dark:hover:bg-yellow-900/30 py-1.5 px-3 rounded text-center text-sm transition duration-200">
                            <i class="fas fa-box mr-1"></i>Add Bank Account
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Compact Recent Transactions -->
        <div class="bg-white dark:bg-gray-800  p-3 sm:p-4 mb-6">
            <div class="flex justify-between items-center mb-4">
                <h2 class="text-lg font-bold text-gray-900 dark:text-white">Recent</h2>
                <a href="vendor-transactions.php" class="text-yellow-600 hover:text-yellow-800 dark:text-yellow-400 dark:hover:text-yellow-300 text-xs sm:text-sm">
                    View All <i class="fas fa-arrow-right ml-1"></i>
                </a>
            </div>
            
            <div id="transactions-container">
                <?php if (empty($recent_transactions)): ?>
                    <div class="text-center py-4 text-gray-500 dark:text-gray-400 text-sm">
                        <i class="fas fa-exchange-alt text-xl mb-2"></i>
                        <p>No transactions</p>
                    </div>
                <?php else: ?>
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700 compact-table">
                            <thead>
                                <tr class="bg-gray-50 dark:bg-gray-700/50">
                                    <th class="px-2 sm:px-3 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Date</th>
                                    <th class="px-2 sm:px-3 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase hide-on-mobile">Desc</th>
                                    <th class="px-2 sm:px-3 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase hide-on-mobile">Ref</th>
                                    <th class="px-2 sm:px-3 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Amount</th>
                                    <th class="px-2 sm:px-3 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Status</th>
                                </tr>
                            </thead>
                            <tbody id="recent-transactions-list" class="divide-y divide-gray-200 dark:divide-gray-700">
                                <?php foreach ($recent_transactions as $txn): ?>
                                <tr class="hover:bg-gray-50 dark:hover:bg-gray-700/50">
                                    <td class="px-2 sm:px-3 py-2 whitespace-nowrap text-xs text-gray-700 dark:text-gray-300">
                                        <?= date('M j, g:i', strtotime($txn['created_at'])) ?>
                                    </td>
                                    <td class="px-2 sm:px-3 py-2 text-xs text-gray-900 dark:text-white hide-on-mobile">
                                        <?= htmlspecialchars(substr($txn['description'], 0, 20)) . (strlen($txn['description']) > 20 ? '...' : '') ?>
                                    </td>
                                    <td class="px-2 sm:px-3 py-2 whitespace-nowrap text-xs text-gray-700 dark:text-gray-300 hide-on-mobile">
                                        <?= substr($txn['reference'], 0, 8) . '...' ?>
                                    </td>
                                    <td class="px-2 sm:px-3 py-2 whitespace-nowrap text-xs <?= $txn['transaction_type'] == 'credit' ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' ?> font-medium">
                                        <?= $txn['transaction_type'] == 'credit' ? '+' : '-' ?>₦<?= number_format($txn['amount'], 2) ?>
                                    </td>
                                    <td class="px-2 sm:px-3 py-2 whitespace-nowrap">
                                        <span class="px-1.5 py-0.5 text-xs font-medium rounded-full 
                                            <?= $txn['status'] == 'completed' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 
                                               ($txn['status'] == 'failed' ? 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200' : 
                                               'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200') ?>">
                                            <?= ucfirst(substr($txn['status'], 0, 3)) ?>
                                        </span>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Compact Live Activity -->
        <div class="bg-white dark:bg-gray-800 p-3 sm:p-4 mb-20">
            <h2 class="text-lg font-bold text-gray-900 dark:text-white mb-4 flex items-center">
                <i class="fas fa-bolt text-yellow-500 mr-2 text-sm"></i> Transactions
            </h2>
            
            <div id="live-activity" class="space-y-2 max-h-60 overflow-y-auto text-sm">
                <div class="text-center py-3 text-gray-500 dark:text-gray-400 text-sm">
                   
                    Waiting for updates...
                </div>
            </div>
        </div>
    </div>
    
    <!-- Compact Toast Notification Container -->
    <div id="toast-container" class="fixed bottom-2 right-2 z-50 space-y-2 w-64 sm:w-72"></div>
    
    <script>
    // Optimized real-time updates for mobile
    let eventSource = null;
    let lastUpdateTime = Date.now();
    
    // Start real-time updates
    function startRealTimeUpdates() {
        const vendorId = '<?= $vendor_id ?>';
        
        if (eventSource) {
            eventSource.close();
        }
        
        eventSource = new EventSource(`../api/sse-vendor-updates.php?vendor_id=${vendorId}`);
        
        eventSource.onopen = function() {
            console.log('SSE connected');
        };
        
        eventSource.onmessage = function(event) {
            try {
                const data = JSON.parse(event.data);
                lastUpdateTime = Date.now();
                
                // Update balances
                if (data.balances) {
                    document.getElementById('pending-balance').textContent = 
                        `₦${data.balances.pending.toFixed(2)}`;
                    document.getElementById('approved-balance').textContent = 
                        `₦${data.balances.approved.toFixed(2)}`;
                }
                
                // Handle new transactions
                if (data.new_transactions && data.new_transactions.length > 0) {
                    data.new_transactions.forEach(transaction => {
                        handleNewTransaction(transaction);
                    });
                }
                
            } catch (error) {
                console.error('Error parsing SSE data:', error);
            }
        };
        
        eventSource.onerror = function() {
            setTimeout(() => {
                if (eventSource.readyState === EventSource.CLOSED) {
                    startRealTimeUpdates();
                }
            }, 3000);
        };
    }
    
    // Handle new transaction
    function handleNewTransaction(transaction) {
        // Show toast notification
        showToastNotification(transaction);
        
        // Add to activity feed
        addToActivityFeed(transaction);
        
        // Prepend to recent transactions table
        prependToTransactionsTable(transaction);
    }
    
    // Show compact toast notification
    function showToastNotification(transaction) {
        const toastContainer = document.getElementById('toast-container');
        
        const toast = document.createElement('div');
        toast.className = 'bg-white dark:bg-gray-800 shadow-lg rounded p-3 border-l-3 border-green-500 transform transition-all duration-300 translate-x-full';
        
        toast.innerHTML = `
            <div class="flex items-start">
                <div class="flex-shrink-0">
                    <i class="fas fa-${transaction.type === 'credit' ? 'money-bill-wave text-green-500' : 'arrow-up text-red-500'}"></i>
                </div>
                <div class="ml-2 flex-1">
                    <p class="font-medium text-gray-900 dark:text-white text-sm">
                        ${transaction.type === 'credit' ? 'Payment!' : 'Withdrawal'}
                    </p>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mt-0.5">
                        ${(transaction.description || 'Transaction').substring(0, 30)}${(transaction.description || '').length > 30 ? '...' : ''}
                    </p>
                    <div class="flex justify-between items-center mt-1">
                        <p class="text-xs font-medium ${transaction.type === 'credit' ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400'}">
                            ${transaction.type === 'credit' ? '+' : '-'}₦${parseFloat(transaction.amount).toFixed(2)}
                        </p>
                        <p class="text-xs text-gray-500">Now</p>
                    </div>
                </div>
                <button onclick="this.parentElement.parentElement.remove()" class="ml-2 text-gray-400 hover:text-gray-600 text-xs">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        `;
        
        toastContainer.appendChild(toast);
        
        setTimeout(() => {
            toast.classList.remove('translate-x-full');
        }, 10);
        
        setTimeout(() => {
            toast.style.opacity = '0';
            toast.style.transform = 'translateX(100%)';
            setTimeout(() => {
                if (toast.parentNode) {
                    toast.remove();
                }
            }, 300);
        }, 4000);
    }
    
    // Add to compact activity feed
    function addToActivityFeed(transaction) {
        const activityContainer = document.getElementById('live-activity');
        
        const placeholder = activityContainer.querySelector('.text-center');
        if (placeholder) {
            placeholder.remove();
        }
        
        const activityItem = document.createElement('div');
        activityItem.className = 'flex items-center p-2 bg-gray-50 dark:bg-gray-700/50 rounded text-xs';
        
        const time = new Date(transaction.created_at).toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
        
        activityItem.innerHTML = `
            <div class="flex-shrink-0 w-8 h-8 rounded-full ${transaction.type === 'credit' ? 'bg-green-100 dark:bg-green-900/30' : 'bg-red-100 dark:bg-red-900/30'} flex items-center justify-center">
                <i class="fas fa-${transaction.type === 'credit' ? 'shopping-cart text-green-600 dark:text-green-400' : 'arrow-up text-red-600 dark:text-red-400'} text-xs"></i>
            </div>
            <div class="ml-3 flex-1">
                <p class="font-medium text-gray-900 dark:text-white">
                    ${(transaction.description || 'Transaction').substring(0, 25)}${(transaction.description || '').length > 25 ? '...' : ''}
                </p>
                <div class="flex justify-between items-center mt-0.5">
                    <p class="text-gray-500">${time}</p>
                    <p class="font-medium ${transaction.type === 'credit' ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400'}">
                        ${transaction.type === 'credit' ? '+' : '-'}₦${parseFloat(transaction.amount).toFixed(2)}
                    </p>
                </div>
            </div>
        `;
        
        activityContainer.insertBefore(activityItem, activityContainer.firstChild);
        
        const items = activityContainer.querySelectorAll('.flex.items-center');
        if (items.length > 5) {
            activityContainer.removeChild(items[items.length - 1]);
        }
    }
    
    // Prepend to compact transactions table
    function prependToTransactionsTable(transaction) {
        const tbody = document.getElementById('recent-transactions-list');
        if (!tbody) return;
        
        const time = new Date(transaction.created_at).toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
        const date = new Date(transaction.created_at).toLocaleDateString('en-US', {month: 'short', day: 'numeric'});
        
        const row = document.createElement('tr');
        row.className = 'hover:bg-gray-50 dark:hover:bg-gray-700/50';
        
        row.innerHTML = `
            <td class="px-2 sm:px-3 py-2 whitespace-nowrap text-xs text-gray-700 dark:text-gray-300">
                ${date}, ${time}
            </td>
            <td class="px-2 sm:px-3 py-2 text-xs text-gray-900 dark:text-white hide-on-mobile">
                ${(transaction.description || 'New').substring(0, 20)}${(transaction.description || '').length > 20 ? '...' : ''}
            </td>
            <td class="px-2 sm:px-3 py-2 whitespace-nowrap text-xs text-gray-700 dark:text-gray-300 hide-on-mobile">
                ${(transaction.reference || 'N/A').substring(0, 8)}${(transaction.reference || '').length > 8 ? '...' : ''}
            </td>
            <td class="px-2 sm:px-3 py-2 whitespace-nowrap text-xs ${transaction.type === 'credit' ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400'} font-medium">
                ${transaction.type === 'credit' ? '+' : '-'}₦${parseFloat(transaction.amount).toFixed(2)}
            </td>
            <td class="px-2 sm:px-3 py-2 whitespace-nowrap">
                <span class="px-1.5 py-0.5 text-xs font-medium rounded-full bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">
                    ${(transaction.status || 'completed').substring(0, 3)}
                </span>
            </td>
        `;
        
        tbody.insertBefore(row, tbody.firstChild);
        
        const rows = tbody.querySelectorAll('tr');
        if (rows.length > 3) {
            tbody.removeChild(rows[rows.length - 1]);
        }
    }
    
    // Initialize on page load
    document.addEventListener('DOMContentLoaded', function() {
        startRealTimeUpdates();
        
        setInterval(() => {
            if (Date.now() - lastUpdateTime > 10000) {
                startRealTimeUpdates();
            }
        }, 30000);
        
        window.addEventListener('beforeunload', () => {
            if (eventSource) {
                eventSource.close();
            }
        });
    });
    
    window.showToastNotification = showToastNotification;
    </script>
    
    <?php include 'include/footer.php'; ?>
</body>
</html>