<?php
// process_vendor_forgot_password.php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
require '../config/conn.php';
require '../vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Set content type to JSON
header('Content-Type: application/json');

$response = [
    'success' => false,
    'message' => '',
    'errors' => []
];

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['forgot_password'])) {
        throw new Exception('Invalid request method');
    }

    $email = trim($_POST['email'] ?? '');
    
    // Store form data in session in case of errors
    $_SESSION['form_data'] = ['email' => $email];
    
    // Validate email
    if (empty($email)) {
        $response['errors']['email'] = "Business email is required";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $response['errors']['email'] = "Invalid email format";
    }
    
    if (!empty($response['errors'])) {
        $response['message'] = 'Please fix the errors below.';
        echo json_encode($response);
        exit();
    }
    
    // Check if vendor exists and account is verified
    $stmt = $conn->prepare("SELECT id, vendor_id, business_name, contact_person, email, is_verified, is_approved FROM vendors WHERE email = ?");
    if (!$stmt) {
        throw new Exception('Database error: ' . $conn->error);
    }
    
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
        // For security, don't reveal if email exists
        $response['message'] = 'If an account exists with this email, you will receive a password reset link shortly.';
        $response['success'] = true; // Return success for security
        echo json_encode($response);
        exit();
    }
    
    $vendor = $result->fetch_assoc();
    $stmt->close();
    
    // Check account status
    if (!$vendor['is_verified']) {
        $response['message'] = 'Your vendor account is not verified. Please verify your account first.';
        $response['redirect'] = 'vendor_login.php';
        echo json_encode($response);
        exit();
    }

    if ($vendor['is_approved'] != 1) {
        if ($vendor['is_approved'] == 0) {
            $response['message'] = 'Your vendor account is pending approval. Please contact support for password reset.';
        } elseif ($vendor['is_approved'] == -1) {
            $response['message'] = 'Your vendor account has been disapproved. Please contact support.';
        }
        echo json_encode($response);
        exit();
    }
    
    // Generate reset token
    $reset_token = bin2hex(random_bytes(32));
    $reset_token_expiry = date('Y-m-d H:i:s', strtotime('+1 hour'));
    
    // First, check if password_reset_tokens table exists
    $table_check = $conn->query("SHOW TABLES LIKE 'password_reset_tokens'");
    if ($table_check->num_rows == 0) {
        // Create password_reset_tokens table
        $create_table_sql = "CREATE TABLE password_reset_tokens (
            id INT PRIMARY KEY AUTO_INCREMENT,
            vendor_id INT NOT NULL,
            token VARCHAR(64) NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            expires_at DATETIME NOT NULL,
            used TINYINT(1) DEFAULT 0,
            used_at DATETIME NULL,
            FOREIGN KEY (vendor_id) REFERENCES vendors(id) ON DELETE CASCADE,
            INDEX idx_token (token),
            INDEX idx_expires_at (expires_at),
            INDEX idx_vendor_id (vendor_id)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
        
        if (!$conn->query($create_table_sql)) {
            throw new Exception('Failed to create password reset table: ' . $conn->error);
        }
    }
    
    // Delete any existing unused tokens for this vendor
    $cleanup_stmt = $conn->prepare("DELETE FROM password_reset_tokens WHERE vendor_id = ? AND (used = 0 OR expires_at < NOW())");
    $cleanup_stmt->bind_param("i", $vendor['id']);
    $cleanup_stmt->execute();
    $cleanup_stmt->close();
    
    // Insert new reset token
    $insert_stmt = $conn->prepare("INSERT INTO password_reset_tokens (vendor_id, token, expires_at) VALUES (?, ?, ?)");
    if (!$insert_stmt) {
        throw new Exception('Database error: ' . $conn->error);
    }
    
    $insert_stmt->bind_param("iss", $vendor['id'], $reset_token, $reset_token_expiry);
    
    if ($insert_stmt->execute()) {
        $insert_stmt->close();
        
        // Send reset email
        $mail = new PHPMailer(true);
        
        try {
            // Server settings
            $mail->isSMTP();
            $mail->Host       = 'smtp.gmail.com';
            $mail->SMTPAuth   = true;
            $mail->Username   = 'olorodemicheal2274@gmail.com';
            $mail->Password   = 'farq ptyc vjtl eses';
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
            $mail->Port       = 465;
            $mail->SMTPDebug = 0;
            $mail->Timeout    = 30;
            $mail->CharSet = 'UTF-8';
            
            // Recipients - Update university name
            $mail->setFrom('noreply@aletheiauniversity.edu', 'ALETHEIA UNIVERSITY Campus Services');
            $mail->addAddress($email, $vendor['business_name']);
            
            // Content
            $mail->isHTML(true);
            $mail->Subject = 'ALETHEIA UNIVERSITY - Vendor Password Reset Request';
            
            // Use actual domain, not localhost for production
            $reset_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]" . dirname($_SERVER['PHP_SELF']) . "/vendor_reset_password.php?token=$reset_token&email=" . urlencode($email);
            
            $recipient_name = !empty($vendor['contact_person']) ? $vendor['contact_person'] : $vendor['business_name'];
            
            $mail->Body = "
            <!DOCTYPE html>
            <html lang='en'>
            <head>
                <meta charset='UTF-8'>
                <meta name='viewport' content='width=device-width, initial-scale=1.0'>
                <title>Password Reset</title>
                <style>
                    body { font-family: 'Arial', sans-serif; line-height: 1.6; color: #333; background: #f5f5f5; padding: 20px; }
                    .container { max-width: 600px; margin: 0 auto; background: #ffffff; border-radius: 10px; overflow: hidden; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
                    .header { background: linear-gradient(135deg, #1a365d 0%, #2d3748 100%); padding: 30px; text-align: center; }
                    .header h1 { color: white; margin: 0; font-size: 24px; }
                    .header p { color: rgba(255,255,255,0.9); margin: 5px 0 0; }
                    .content { padding: 30px; }
                    .button { display: inline-block; padding: 12px 30px; background: #fbbb01; color: white; text-decoration: none; border-radius: 5px; font-weight: bold; transition: all 0.3s ease; }
                    .button:hover { background: #e0a800; transform: translateY(-2px); }
                    .info-box { background: #f8f9fa; padding: 15px; border-radius: 5px; margin: 20px 0; border-left: 4px solid #fbbb01; }
                    .footer { background: #f5f5f5; padding: 20px; text-align: center; font-size: 12px; color: #666; border-top: 1px solid #eee; }
                    .university-logo { font-size: 18px; font-weight: bold; color: white; }
                </style>
            </head>
            <body>
                <div class='container'>
                    <div class='header'>
                        <div class='university-logo'>ALETHEIA UNIVERSITY</div>
                        <p>Campus Services Vendor Portal</p>
                        <h1>Password Reset Request</h1>
                    </div>
                    
                    <div class='content'>
                        <h2 style='color: #1a365d; margin-top: 0;'>Hello {$recipient_name},</h2>
                        
                        <p>We received a request to reset your password for your vendor account at ALETHEIA UNIVERSITY Campus Services.</p>
                        
                        <div class='info-box'>
                            <p style='margin: 0 0 10px; font-weight: bold; color: #1a365d;'><i class='fas fa-building'></i> Vendor Details:</p>
                            <p><strong>Business:</strong> {$vendor['business_name']}</p>
                            <p><strong>Vendor ID:</strong> {$vendor['vendor_id']}</p>
                            <p><strong>Email:</strong> {$email}</p>
                        </div>
                        
                        <div style='text-align: center; margin: 30px 0;'>
                            <a href='$reset_link' class='button'>
                                <i class='fas fa-key'></i> Reset Your Password
                            </a>
                        </div>
                        
                        <p style='color: #666; font-size: 14px; text-align: center;'>
                            <i class='fas fa-clock'></i> This link will expire in 1 hour.
                        </p>
                        
                        <div style='background: #fff3cd; padding: 15px; border-radius: 5px; margin-top: 25px; border: 1px solid #ffeaa7;'>
                            <p style='margin: 0; color: #856404;'>
                                <i class='fas fa-shield-alt'></i> <strong>Security Notice:</strong> 
                                If you didn't request this reset, please ignore this email and contact Campus Services support immediately.
                            </p>
                        </div>
                        
                        <div style='margin-top: 25px; padding-top: 20px; border-top: 1px solid #eee;'>
                            <p style='font-size: 12px; color: #888; margin: 5px 0;'>
                                <strong>ALETHEIA UNIVERSITY Campus Services</strong><br>
                                Vendor Management System<br>
                                Email: vendorsupport@aletheiauniversity.edu
                            </p>
                        </div>
                    </div>
                    
                    <div class='footer'>
                        <p>&copy; " . date('Y') . " ALETHEIA UNIVERSITY. All rights reserved.</p>
                        <p style='font-size: 11px; color: #999; margin-top: 5px;'>
                            This is an automated message. Please do not reply to this email.
                        </p>
                    </div>
                </div>
            </body>
            </html>
            ";
            
            $mail->AltBody = "ALETHEIA UNIVERSITY - Vendor Password Reset Request\n\n" .
                "Hello {$recipient_name},\n\n" .
                "We received a request to reset your password for your vendor account at ALETHEIA UNIVERSITY Campus Services.\n\n" .
                "Vendor Details:\n" .
                "Business: {$vendor['business_name']}\n" .
                "Vendor ID: {$vendor['vendor_id']}\n" .
                "Email: {$email}\n\n" .
                "To reset your password, please click the following link:\n" .
                "$reset_link\n\n" .
                "This link will expire in 1 hour.\n\n" .
                "Security Notice: If you didn't request this reset, please ignore this email and contact Campus Services support immediately.\n\n" .
                "ALETHEIA UNIVERSITY Campus Services\n" .
                "Vendor Management System\n" .
                "Email: vendorsupport@aletheiauniversity.edu\n\n" .
                "© " . date('Y') . " ALETHEIA UNIVERSITY. All rights reserved.\n" .
                "This is an automated message. Please do not reply to this email.";
            
            $mail->send();
            
            // Clear form data from session
            unset($_SESSION['form_data']);
            
            // Log the reset request
            $log_check = $conn->query("SHOW TABLES LIKE 'vendor_activity_log'");
            if ($log_check->num_rows > 0) {
                $log_stmt = $conn->prepare("INSERT INTO vendor_activity_log (vendor_id, activity_type, description) VALUES (?, 'password_reset_request', 'Vendor requested password reset')");
                $log_stmt->bind_param("i", $vendor['id']);
                $log_stmt->execute();
                $log_stmt->close();
            }
            
            $response['success'] = true;
            $response['message'] = "Password reset link sent to {$email}. Please check your inbox (and spam folder).";
            
        } catch (Exception $e) {
            error_log("Email error: " . $e->getMessage());
            $response['message'] = "Failed to send password reset email. Please try again later.";
        }
    } else {
        $response['message'] = "Failed to process your request. Please try again.";
    }
    
} catch (Exception $e) {
    error_log("Password reset error: " . $e->getMessage());
    $response['message'] = 'An error occurred. Please try again.';
}

echo json_encode($response);
exit();
?>