<?php
// resend_vendor_verification.php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

require '../config/conn.php';
require '../vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Set PHP timezone
date_default_timezone_set('Africa/Lagos');

// Set JSON header
header('Content-Type: application/json');

// Initialize response array
$response = [
    'success' => false,
    'message' => ''
];

try {
    // Check if session exists
    if (!isset($_SESSION['2fa_vendor_id']) || !isset($_SESSION['2fa_email'])) {
        throw new Exception('Session expired. Please login again.');
    }

    $vendor_id = $_SESSION['2fa_vendor_id'];
    $email = $_SESSION['2fa_email'];

    // Check if vendor exists
    $stmt = $conn->prepare("SELECT id, vendor_id, business_name, email, is_verified, is_approved FROM vendors WHERE id = ? AND email = ?");
    $stmt->bind_param("is", $vendor_id, $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        session_destroy();
        throw new Exception('Vendor account not found.');
    }

    $vendor = $result->fetch_assoc();
    $stmt->close();

    // Check account status
    if ($vendor['is_verified'] == 0) {
        throw new Exception('Account not verified. Please complete registration first.');
    }

    if ($vendor['is_approved'] != 1) {
        if ($vendor['is_approved'] == 0) {
            throw new Exception('Your account is pending approval.');
        } elseif ($vendor['is_approved'] == -1) {
            throw new Exception('Your account has been disapproved.');
        }
    }

    // Set MySQL timezone
    $conn->query("SET time_zone = '+01:00'");

    // Generate new verification code
    $new_verification_code = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);
    $expires_at = date('Y-m-d H:i:s', strtotime('+10 minutes'));

    // Delete any existing unused codes for this vendor
    $cleanup = $conn->prepare("DELETE FROM vendor_verification_codes WHERE vendor_id = ? AND used = 0");
    $cleanup->bind_param("i", $vendor_id);
    $cleanup->execute();
    $cleanup->close();

    // Insert new code
    $insert_stmt = $conn->prepare("INSERT INTO vendor_verification_codes (vendor_id, code, expires_at) VALUES (?, ?, ?)");
    $insert_stmt->bind_param("iss", $vendor_id, $new_verification_code, $expires_at);
    
    if (!$insert_stmt->execute()) {
        throw new Exception('Failed to generate new verification code: ' . $conn->error);
    }
    
    $insert_id = $insert_stmt->insert_id;
    $insert_stmt->close();

    // Debug: Log resend attempt
    error_log("Code resent - Vendor ID: $vendor_id, New Code: $new_verification_code, Expires: $expires_at");

    // Send email
    $mail = new PHPMailer(true);
    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host       = 'smtp.gmail.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'olorodemicheal2274@gmail.com';
        $mail->Password   = 'farq ptyc vjtl eses';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port       = 465;
        $mail->Timeout    = 30;
        $mail->CharSet = 'UTF-8';
        
        // Recipients
        $mail->setFrom('noreply@aletheiauniversity.edu', 'ALETHEIA UNIVERSITY Campus Services');
        $mail->addAddress($email, $vendor['business_name']);
        
        // Content
        $mail->isHTML(true);
        $mail->Subject = 'ALETHEIA UNIVERSITY - New Verification Code';
        
        $mail->Body = "
        <div style='max-width: 600px; margin: 0 auto; border: 1px solid #e0e0e0; border-radius: 8px; overflow: hidden; font-family: Arial, sans-serif;'>
            <div style='background-color: #1a365d; padding: 25px; text-align: center;'>
                <h1 style='color: white; margin: 0; font-size: 24px;'>ALETHEIA UNIVERSITY</h1>
                <p style='color: rgba(255,255,255,0.8); margin: 5px 0 0; font-size: 16px;'>New Verification Code</p>
            </div>
            
            <div style='padding: 25px;'>
                <h2 style='color: #1a365d; margin-top: 0;'>Hello {$vendor['business_name']},</h2>
                
                <p style='font-size: 16px; color: #333;'>Your new verification code is:</p>
                
                <div style='text-align: center; margin: 25px 0;'>
                    <div style='display: inline-block; padding: 15px 30px; background-color: #f5f5f5; border: 2px dashed #1a365d; border-radius: 5px; font-size: 24px; font-weight: bold; letter-spacing: 5px; color: #1a365d;'>
                        $new_verification_code
                    </div>
                </div>
                
                <p style='font-size: 14px; color: #666;'>
                    <strong>This code will expire in 10 minutes.</strong>
                </p>
            </div>
        </div>
        ";
        
        $mail->AltBody = "ALETHEIA UNIVERSITY - New Verification Code\n\n" .
            "Hello {$vendor['business_name']},\n\n" .
            "Your new verification code is: $new_verification_code\n\n" .
            "This code will expire in 10 minutes.\n\n";
        
        $mail->send();
        
        // Update session creation time
        $_SESSION['2fa_created_at'] = time();
        
        $response['success'] = true;
        $response['message'] = 'New verification code sent successfully!';
        
    } catch (Exception $e) {
        error_log("Email error: " . $e->getMessage());
        
        // Delete the code if email failed
        $delete_stmt = $conn->prepare("DELETE FROM vendor_verification_codes WHERE id = ?");
        $delete_stmt->bind_param("i", $insert_id);
        $delete_stmt->execute();
        $delete_stmt->close();
        
        throw new Exception('Failed to send verification code. Please try again.');
    }

} catch (Exception $e) {
    error_log("Resend error: " . $e->getMessage());
    $response['message'] = $e->getMessage();
}

echo json_encode($response);
exit;
?>