<?php
// webhook/paystack_webhook.php
require_once '../config/conn.php';
require_once '../config/paystack_config.php';

// Get input
$input = @file_get_contents("php://input");
$signature = $_SERVER['HTTP_X_PAYSTACK_SIGNATURE'] ?? '';

// Verify signature
if ($signature !== hash_hmac('sha512', $input, PAYSTACK_SECRET_KEY)) {
    http_response_code(401);
    exit();
}

$event = json_decode($input);

if ($event->event === 'transfer.success') {
    $transfer = $event->data;
    
    // Update transaction and withdrawal status
    $stmt = $conn->prepare("
        UPDATE wallet_transactions wt
        JOIN withdrawals w ON wt.id = w.transaction_id
        SET wt.status = 'completed',
            w.status = 'completed',
            w.processor_response = ?,
            w.processed_at = NOW(),
            wt.updated_at = NOW(),
            w.updated_at = NOW()
        WHERE wt.paystack_transfer_code = ?
    ");
    $stmt->bind_param("ss", json_encode($event), $transfer->transfer_code);
    $stmt->execute();
    
} elseif ($event->event === 'transfer.failed' || $event->event === 'transfer.reversed') {
    $transfer = $event->data;
    
    // Update status to failed and refund wallet
    $conn->begin_transaction();
    
    try {
        // Update transaction status
        $stmt = $conn->prepare("
            UPDATE wallet_transactions 
            SET status = 'failed',
                updated_at = NOW()
            WHERE paystack_transfer_code = ?
        ");
        $stmt->bind_param("s", $transfer->transfer_code);
        $stmt->execute();
        
        // Update withdrawal status
        $stmt2 = $conn->prepare("
            UPDATE withdrawals 
            SET status = 'failed',
                processor_response = ?,
                processed_at = NOW(),
                updated_at = NOW()
            WHERE processor_reference = ?
        ");
        $stmt2->bind_param("ss", json_encode($event), $transfer->reference);
        $stmt2->execute();
        
        // Refund to wallet
        $stmt3 = $conn->prepare("
            UPDATE student_wallets sw
            JOIN wallet_transactions wt ON sw.id = wt.wallet_id
            SET sw.balance = sw.balance + wt.amount
            WHERE wt.paystack_transfer_code = ?
        ");
        $stmt3->bind_param("s", $transfer->transfer_code);
        $stmt3->execute();
        
        $conn->commit();
    } catch (Exception $e) {
        $conn->rollback();
    }
}

http_response_code(200);
?>